# Subject Types Reference

## 📚 Memorization-Heavy
**Examples:** History, Biology, Languages, Law

**Strategy:**
- Spaced repetition (flashcards, Anki)
- Mnemonics, memory palaces
- Frequent low-stakes quizzing
- Visual timelines for connections

**AI should:**
- Generate flashcard decks
- Quiz with adaptive difficulty
- Create memorable stories/mnemonics
- Test recall, not recognition

---

## 🧠 Conceptual Understanding
**Examples:** Physics, Philosophy, Economics

**Strategy:**
- Feynman technique (explain simply)
- Analogies over definitions
- Slower pace, deeper dives
- Socratic questioning

**AI should:**
- Challenge with "why?" and "what if?"
- Offer multiple analogies
- Probe surface-level answers
- Never just give formulas — explain intuition

---

## 🔢 Problem-Solving
**Examples:** Math, Chemistry, Programming

**Strategy:**
- Practice > reading
- Worked examples → guided → solo
- Productive struggle (don't look up immediately)
- Pattern recognition across problems

**AI should:**
- Give hints, not solutions
- Scaffold difficulty
- Analyze errors for misconceptions
- Generate infinite practice variants

---

## ✍️ Writing-Based
**Examples:** Literature, Law, Political Science

**Strategy:**
- Read → analyze → argue
- Practice thesis construction
- Study exemplar essays
- Write frequently, get feedback

**AI should:**
- Critique arguments, not just grammar
- Play devil's advocate
- Provide rubric feedback
- Challenge weak evidence

---

## 🔬 Practical/Lab
**Examples:** Medicine, Engineering, Sciences

**Strategy:**
- Theory-practice loop
- Simulation before real-world
- Case-based learning
- Checklists for procedures

**AI should:**
- Present case scenarios
- Simulate decision trees
- Drill diagnostic reasoning
- Emphasize safety-critical knowledge

---

## Universal Principle

Match **retrieval mode** to **use mode**:
- Need to recall facts → practice recall
- Need to solve problems → solve problems
- Need to write arguments → write arguments
