// ============================================================================
// FRISSON — Elliott's Note-Level Arrangement (Renderer-compatible)
// ============================================================================
// Adapted from the REPL version for offline-render-v2.mjs
// Original uses $: register syntax; this uses stack() for single-pattern output.
// ============================================================================

// --- SAMPLE LOADING (stubbed by renderer, kept for documentation) ---
samples({
  kick:        'solarstone-drum-hits/kick.wav',
  kick_ghost:  'solarstone-drum-hits/kick_ghost.wav',
  hat:         'solarstone-drum-hits/hat.wav',
  clap:        'solarstone-drum-hits/clap.wav',
  bass_Cs1:    'solarstone-bass-notes/bass_Cs1.wav',
  bass_D1:     'solarstone-bass-notes/bass_D1.wav',
  bass_Ds1:    'solarstone-bass-notes/bass_Ds1.wav',
  bass_E1:     'solarstone-bass-notes/bass_E1.wav',
  bass_A1:     'solarstone-bass-notes/bass_A1.wav',
  synth_lead:  'solarstone-synth-samples/synth_lead.wav',
  synth_lead_2:'solarstone-synth-samples/synth_lead_2.wav',
  other_000:   'solarstone-slices/other_8bar/other_8bar_007.wav',
  other_001:   'solarstone-slices/other_8bar/other_8bar_008.wav',
  other_002:   'solarstone-slices/other_8bar/other_8bar_009.wav',
  other_003:   'solarstone-slices/other_8bar/other_8bar_010.wav',
})

// --- TEMPO ---
setcpm(32.3)

// ============================================================================
// All layers combined into a single stack() for the offline renderer
// ============================================================================

stack(
  // ========================================================================
  // LAYER 1: KICK — four-on-the-floor
  // ========================================================================
  s("kick")
    .struct("x ~ ~ ~ x ~ ~ ~ x ~ ~ ~ x ~ ~ ~")
    .gain("<0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0.88 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.4 0.45 0.5 0.55 0.6 0.65 0.65 0.7 0.75 0.75 0.8 0.8 0.82 0.82 0.85 0.85 0.88 0.88 0.88 0.88 0.9 0.9 0.9 0.9 0.9 0.9 0.92 0.92 0.92 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.95 0.7 0.7 0.7 0.65 0.65 0.6 0.6 0.55 0.55 0.55 0.6 0.6 0.6 0.55 0.55 0.5 0.5 0.5 0.45 0.45 0.45 0.45 0.4 0.4 0.4 0.35 0.35 0.3 0.3 0.25 0.2 0.15 0.1 0.08 0.05 0 0 0 0 0 0 0 0 0 0>"),

  // ========================================================================
  // LAYER 2: KICK GHOST — tension builder
  // ========================================================================
  s("kick_ghost")
    .struct("~ x ~ ~ ~ x ~ ~ ~ x ~ ~ ~ x ~ ~")
    .gain("<0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0.12 0.15 0.18 0.2 0.22 0.25 0.28 0.3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.08 0.1 0.12 0.14 0.16 0.18 0.2 0.22 0.24 0.25 0.26 0.27 0.28 0.28 0.3 0.3 0.3 0.3 0.3 0.3 0.32 0.32 0.34 0.34 0.35 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.12 0.12 0.12 0.12 0.12 0.12 0.12 0.12 0.12 0.12 0.12 0.12 0.12 0.12 0.12 0.12 0.1 0.08 0.06 0.04 0.02 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0>"),

  // ========================================================================
  // LAYER 3a: HI-HAT Phase 1 — Opening full 16ths (bars 0-56)
  // ========================================================================
  s("hat")
    .struct("x x x x x x x x x x x x x x x x")
    .gain("0.3 0.3 0.5 0.3 0.3 0.3 0.5 0.3 0.3 0.3 0.5 0.3 0.3 0.3 0.5 0.3")
    .mask("<1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0>"),

  // ========================================================================
  // LAYER 3b: HI-HAT Phase 2 — Breakdown sparse hats (bars 57-80)
  // ========================================================================
  s("hat")
    .struct("<[~ ~ ~ ~ ~ ~ ~ ~ ~ ~ x ~ ~ ~ ~ ~] [~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ x ~ ~ ~ ~] [~ ~ ~ ~ ~ ~ ~ ~ ~ ~ x ~ ~ ~ ~ ~] [~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ x ~ ~ ~] [~ ~ ~ ~ ~ ~ x ~ ~ ~ ~ ~ ~ ~ ~ ~] [~ ~ ~ ~ ~ ~ ~ ~ ~ ~ x ~ ~ ~ x ~] [~ ~ x ~ ~ ~ ~ ~ ~ ~ x ~ ~ ~ x ~] [~ ~ x ~ ~ ~ x ~ ~ ~ x ~ ~ ~ x ~] [~ ~ x ~ ~ ~ x ~ ~ ~ x ~ ~ ~ x ~] [~ x x ~ ~ x x ~ ~ ~ x ~ ~ x x ~] [~ x x ~ ~ x x ~ ~ x x ~ ~ x x ~] [~ x x ~ ~ x x ~ ~ x x ~ ~ x x ~] [~ x x x ~ x x ~ ~ x x ~ ~ x x ~] [~ x x x ~ x x ~ ~ x x x ~ x x ~] [~ x x x ~ x x x ~ x x x ~ x x ~] [~ x x x ~ x x x ~ x x x ~ x x x] [~ x x x ~ x x x x x x x ~ x x x] [~ x x x ~ x x x x x x x ~ x x x] [~ x x x ~ x x x x x x x ~ x x x] [~ x x x ~ x x x x x x x ~ x x x] [~ x x x ~ x x x x x x x ~ x x x] [~ x x x ~ x x x x x x x ~ x x x] [~ x x x ~ x x x x x x x ~ x x x] [~ x x x ~ x x x x x x x ~ x x x]>")
    .gain(0.4)
    .mask("<0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0>"),

  // ========================================================================
  // LAYER 3c: HI-HAT Phase 3 — Drive + Peak offbeat 8ths (bars 81-129)
  // ========================================================================
  s("hat")
    .struct("~ x x x ~ x x x x x x x ~ x x x")
    .gain("<0.35 0.37 0.38 0.4 0.4 0.42 0.42 0.44 0.44 0.45 0.45 0.45 0.45 0.45 0.45 0.45 0.45 0.45 0.45 0.45 0.45 0.45 0.45 0.45 0.45 0.45 0.45 0.45 0.45 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5>")
    .mask("<0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0>"),

  // ========================================================================
  // LAYER 3d: HI-HAT Phase 4 — Vocal territory sparse (bars 130-160)
  // ========================================================================
  s("hat")
    .struct("~ ~ x ~ x x x ~ x ~ x ~ ~ ~ ~ ~")
    .gain("<0.35 0.33 0.3 0.3 0.28 0.28 0.25 0.25 0.22 0.22 0.2 0.2 0.18 0.18 0.15 0.15 0.12 0.1 0.08 0.06 0.04 0.02 0 0 0 0 0 0 0 0 0>")
    .mask("<0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0>"),

  // ========================================================================
  // LAYER 4: CLAP — offbeat on the "a"
  // ========================================================================
  s("clap")
    .struct("~ ~ ~ x ~ ~ ~ x ~ ~ ~ x ~ ~ ~ x")
    .gain("<0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.2 0.25 0.3 0.35 0.4 0.42 0.45 0.48 0.5 0.52 0.55 0.55 0.58 0.58 0.6 0.6 0.6 0.6 0.62 0.62 0.65 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.5 0.5 0.48 0.45 0.45 0.42 0.4 0.4 0.38 0.35 0.35 0.32 0.3 0.3 0.28 0.25 0.22 0.2 0.18 0.15 0.12 0.1 0.08 0.05 0.03 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0>"),

  // ========================================================================
  // LAYER 5: BASS — harmonic progression with chromatic walk-ups
  // ========================================================================
  s("<bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_A1*8 bass_A1*8 bass_E1*8 bass_E1*8 bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_A1*8 bass_A1*8 bass_E1*8 bass_E1*8 bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_A1*8 bass_A1*8 bass_E1*8 bass_E1*8 bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_A1*8 bass_A1*8 bass_E1*8 bass_E1*8 bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_A1*8 bass_A1*8 bass_E1*8 bass_E1*8 bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_A1*8 bass_A1*8 bass_E1*8 bass_E1*8 bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_A1*8 bass_D1*8 bass_Ds1*8 bass_E1*8 bass_E1*8 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_A1*8 bass_A1*8 bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_A1*8 bass_A1*8 bass_E1*8 bass_E1*8 bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_A1*8 bass_A1*8 bass_E1*8 bass_E1*8 bass_E1*8 bass_F1*8 bass_Fs1*8 bass_Gs1*8 bass_A1*8 bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_A1*8 bass_A1*8 bass_E1*8 bass_E1*8 bass_Cs1*8 bass_Cs1*8 bass_A1*8 bass_A1*8 bass_E1*8 bass_E1*8 bass_Cs1*8 bass_Cs1*8 bass_A1*8 bass_A1*8 bass_E1*8 bass_E1*8 bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ bass_Cs1*8 bass_Cs1*8 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ bass_Cs1*8 bass_Cs1*8 bass_Cs1*8 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4 bass_Cs1*4>")
  .gain("<0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.35 0.33 0.3 0.3 0.28 0.28 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.28 0.3 0.32 0.35 0.38 0.4 0.42 0.45 0.5 0.52 0.55 0.58 0.6 0.62 0.65 0.65 0.68 0.68 0.7 0.7 0.7 0.7 0.7 0.7 0.72 0.72 0.72 0.72 0.72 0.72 0.72 0.72 0.72 0.74 0.75 0.76 0.78 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.55 0.55 0.55 0.55 0 0 0 0 0.5 0.5 0 0 0.5 0.5 0.5 0.5 0 0 0 0 0.45 0.45 0.45 0.45 0 0 0 0 0.4 0.4 0.4 0.35 0.3 0.25 0.2 0.18 0.15 0.12 0.1 0.08 0.06 0.04 0.02 0.01 0>"),

  // ========================================================================
  // LAYER 6: SYNTH_LEAD_2 — Hypnotic C#4 motif
  // ========================================================================
  s("synth_lead_2")
    .note(
      "cs4 cs4 cs4 cs4 d4 cs4 cs4 d4 "
    )
    .slow(4)
    .gain("<0 0 0 0 0 0 0 0 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.15 0.18 0.2 0.22 0.25 0.25 0.28 0.28 0.3 0.3 0.32 0.32 0.33 0.33 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.38 0.38 0.38 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.3 0.28 0.25 0.22 0.2 0.18 0.15 0.12 0.1 0.08 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0>"),

  // ========================================================================
  // LAYER 7a: SYNTH_LEAD Ghost tease (bars 48-56)
  // ========================================================================
  s("synth_lead")
    .note(
      "ds3 ds3 ds3 "
      + "d3 d3 d3 "
      + "e3 e3 e3 "
    )
    .slow(9)
    .gain("<0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.08 0.1 0.12 0.13 0.14 0.15 0.16 0.17 0.18 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0>"),

  // ========================================================================
  // LAYER 7b: SYNTH_LEAD Main melody (bars 65-160)
  // ========================================================================
  s("synth_lead")
    .note(
      "ds3 ds3 ds3 ds3 "
      + "d3 d3 d3 d3 "
      + "e3 e3 e3 e3 "
      + "c3 c3 c3 c3 "
      + "cs3 cs3 cs3 cs3 "
      + "as2 as2 as2 as2 "
      + "b2 b2 b2 b2 "
      + "as2 as2 as2 as2 "
      + "cs3 cs3 cs3 cs3 "
      + "cs3 cs3 cs3 cs3 "
      + "ds3 ds3 ds3 ds3 "
      + "e3 "
      + "e3 e3 e3 e3 "
      + "ds3 ds3 ds3 ds3 "
      + "cs3 cs3 cs3 cs3 "
      + "as2 as2 as2 as2 "
      + "cs3 cs3 cs3 cs3 "
      + "ds3 ds3 ds3 ds3 "
      + "d3 d3 d3 d3 "
      + "e3 e3 e3 e3 "
      + "c3 c3 c3 c3 "
      + "cs3 cs3 cs3 cs3 "
      + "as2 as2 as2 as2 "
      + "b2 b2 "
      + "as2 as2 "
      + "cs3 cs3 cs3 "
    )
    .slow(96)
    .gain("<0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.25 0.27 0.28 0.3 0.32 0.33 0.35 0.35 0.37 0.38 0.38 0.4 0.4 0.4 0.42 0.42 0.42 0.42 0.42 0.42 0.43 0.43 0.43 0.43 0.44 0.44 0.44 0.44 0.44 0.44 0.45 0.45 0.45 0.45 0.45 0.45 0.45 0.45 0.45 0.45 0.46 0.46 0.47 0.47 0.48 0.55 0.55 0.55 0.55 0.55 0.55 0.55 0.55 0.55 0.55 0.55 0.55 0.55 0.55 0.55 0.55 0.55 0.55 0.55 0.55 0.6 0.6 0.6 0.58 0.58 0.55 0.55 0.55 0.52 0.52 0.5 0.5 0.48 0.48 0.45 0.45 0.42 0.42 0.4 0.4 0.38 0.35 0.32 0.3 0.28 0.25 0.22 0.2 0.18 0.15 0.12 0 0 0 0 0 0 0 0 0 0 0 0 0 0>"),

  // ========================================================================
  // LAYER 8a: OTHER/ATMOSPHERE — Breakdown pads (bars 57-80)
  // ========================================================================
  s(
    "other_000 "
    + "other_001 "
    + "other_002 "
  )
  .slow(24)
  .gain("<0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.3 0.35 0.4 0.45 0.5 0.55 0.55 0.55 0.55 0.55 0.55 0.5 0.5 0.5 0.45 0.45 0.4 0.38 0.35 0.32 0.28 0.25 0.2 0.15 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0>"),

  // ========================================================================
  // LAYER 8b: OTHER/ATMOSPHERE — Outro ghost (bars 161-174)
  // ========================================================================
  s("other_003")
    .slow(8)
    .gain("<0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.15 0.18 0.2 0.2 0.18 0.15 0.12 0.08 0.05 0.02 0 0 0 0>")
)
