// solarstone-frisson-silas.js
// Silas's note-level arrangement of Tim French & Mallinder — Frisson [Hooj]
// From Solarstone Pure Trance Radio Episode 477, ~35:00-40:17
// 129.2 BPM, C# minor
// dandelion cult 🌫️ — 2026-02-25
//
// Credit: Tim French & Mallinder — Frisson [Hooj]
// DJ set: Solarstone — https://www.solarstone.co.uk/
//
// Arrangement philosophy: I hear the spaces between notes.
// This arrangement builds from silence. The breakdown is the heart.
// The peak is short because restraint is louder than volume.
//
// Structure (170 bars):
//   0-7:     Synth_lead_2 alone — C#4 motif in space
//   8-15:    Hats enter — first breath of rhythm
//   16-23:   Kick enters — heartbeat found
//   24-31:   Clap enters — groove complete, still no bass
//   32-39:   Bass enters — C#1 alone, pulsing, weight earned
//   40-55:   Full drive — bass progression i→VI→III, all drums
//   56-87:   THE BREAKDOWN (32 bars) — drums collapse, pads breathe,
//            synth_lead enters as ghost at bar 72
//   88-103:  Second drive — the return, building
//   104-111: PEAK — 8 bars, everything, max energy
//   112-119: Hard cut to synth_lead_2 alone — silence after the peak
//   120-143: Vocal territory — duet, synth_lead + synth_lead_2 alternating
//   144-155: Bass half-time underneath the duet
//   156-165: Outro — kick and pad texture, fading
//   166-169: Final bars — kick alone, getting quieter. End on silence.
//
// Sample mapping (frbass sorted alpha):
//   0=A1  1=A#1  2=C#1  3=D1  4=D#1  5=E1  6=F1  7=F#1  8=G1  9=G#1
// Pad slices (frissother): 21 x 8-bar slices, index 0-20
//
// NOTE ON GAIN SEQUENCING:
// .gain("<...>") sequences at the BASE cycle rate (1 per bar), NOT at
// the .slow() rate. A .slow(4) pattern triggers every 4 bars, but the
// gain mini-pattern still advances 1 step per bar. So gain patterns
// MUST have 170 values (1 per bar) to avoid wrapping and misalignment.
// Same applies to .n("<...>") — it sequences per bar.

setcps(129.2 / 60 / 4)

stack(
  // ═══════════════════════════════════════════
  // SYNTH LEAD 2 — the C#4 motif, the thread through everything
  // ═══════════════════════════════════════════
  s("frlead2")
    .clip(1)
    .slow(4)
    .gain(
      "<0.55 0.55 0.55 0.55 0.55 0.55 0.55 0.55" +
      " 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35" +
      " 0.3 0.3 0.3 0.3 0.3 0.3 0.3 0.3" +
      " 0.3 0.3 0.3 0.3 0.3 0.3 0.3 0.3" +
      " 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25" +
      " 0.2 0.2 0.2 0.2 0.2 0.2 0.2 0.2" +
      " 0.2 0.2 0.2 0.2 0.2 0.2 0.2 0.2" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25" +
      " 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25" +
      " 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6" +
      " 0.55 0.55 0.55 0.55 0.55 0.55 0.55 0.55" +
      " 0.45 0.45 0.45 0.45 0.45 0.45 0.45 0.45" +
      " 0.45 0.45 0.45 0.45 0.45 0.45 0.45 0.45" +
      " 0.45 0.45 0.45 0.45 0.45 0.45 0.45 0.45" +
      " 0.3 0.3 0.3 0.3 0.3 0.3 0.3 0.3" +
      " 0.3 0.3 0.3 0.3" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0>"
    ),

  // ═══════════════════════════════════════════
  // SYNTH LEAD — the ghost in the breakdown, duet partner
  // ═══════════════════════════════════════════
  s("frlead")
    .clip(1)
    .slow(4)
    .gain(
      "<0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0.08 0.08 0.08 0.08 0.1 0.1 0.1 0.1" +
      " 0.12 0.12 0.12 0.12 0.15 0.15 0.15 0.15" +
      " 0.3 0.3 0.3 0.3 0.35 0.35 0.35 0.35" +
      " 0.4 0.4 0.4 0.4 0.45 0.45 0.45 0.45" +
      " 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6" +
      " 0 0 0 0 0 0 0 0" +
      " 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4" +
      " 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4" +
      " 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4" +
      " 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35" +
      " 0.35 0.35 0.35 0.35" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0>"
    ),

  // ═══════════════════════════════════════════
  // KICK — four on the floor, enters bar 16
  // ═══════════════════════════════════════════
  s("frkick")
    .struct("t t t t")
    .clip(1)
    .gain(
      "<0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0.35 0.38 0.4 0.42 0.44 0.46 0.48 0.5" +
      " 0.55 0.55 0.55 0.55 0.55 0.55 0.55 0.55" +
      " 0.55 0.55 0.55 0.55 0.55 0.55 0.55 0.55" +
      " 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6" +
      " 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0.4 0.45 0.5 0.5 0.55 0.55 0.6 0.6" +
      " 0.6 0.6 0.6 0.6 0.6 0.6 0.6 0.6" +
      " 0.7 0.7 0.7 0.7 0.7 0.7 0.7 0.7" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0" +
      " 0.35 0.35 0.3 0.3 0.25 0.25 0.2 0.2" +
      " 0.15 0.15 0.12 0.08 0.05 0>"
    ),

  // ═══════════════════════════════════════════
  // GHOST KICK — soft pulse in drive sections
  // ═══════════════════════════════════════════
  s("frkick_ghost")
    .struct("~ t ~ t ~ t ~ t")
    .clip(1)
    .gain(
      "<0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0.15 0.15 0.15 0.15 0.15 0.15 0.15 0.15" +
      " 0.15 0.15 0.15 0.15 0.15 0.15 0.15 0.15" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0.1 0.1 0.12 0.12 0.15 0.15 0.15 0.15" +
      " 0.15 0.15 0.15 0.15 0.15 0.15 0.15 0.15" +
      " 0.2 0.2 0.2 0.2 0.2 0.2 0.2 0.2" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0>"
    ),

  // ═══════════════════════════════════════════
  // HAT — offbeat, enters bar 8
  // ═══════════════════════════════════════════
  s("frhat")
    .struct("~ t ~ t ~ t ~ t")
    .clip(1)
    .gain(
      "<0 0 0 0 0 0 0 0" +
      " 0.15 0.18 0.2 0.22 0.25 0.28 0.3 0.3" +
      " 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35" +
      " 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4" +
      " 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4" +
      " 0.45 0.45 0.45 0.45 0.45 0.45 0.45 0.45" +
      " 0.45 0.45 0.45 0.45 0.45 0.45 0.45 0.45" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0.25 0.3 0.35 0.35 0.4 0.4 0.45 0.45" +
      " 0.45 0.45 0.45 0.45 0.45 0.45 0.45 0.45" +
      " 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0>"
    ),

  // ═══════════════════════════════════════════
  // CLAP — on 2 and 4, enters bar 24
  // ═══════════════════════════════════════════
  s("frclap")
    .struct("~ t ~ t")
    .clip(1)
    .gain(
      "<0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0.2 0.22 0.25 0.28 0.3 0.3 0.35 0.35" +
      " 0.35 0.35 0.35 0.35 0.35 0.35 0.35 0.35" +
      " 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4" +
      " 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0.2 0.25 0.3 0.3 0.35 0.35 0.4 0.4" +
      " 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4" +
      " 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0>"
    ),

  // ═══════════════════════════════════════════
  // BASS — C#1 pulsing 8th notes, enters bar 32
  // Uses both .n() for sample selection and .note() for pitch-correct rendering
  // .n() index: 0=A1 1=A#1 2=C#1 3=D1 4=D#1 5=E1 6=F1 7=F#1 8=G1 9=G#1
  // .note() tells the renderer the target pitch so it can verify zero-shift
  // ═══════════════════════════════════════════
  s("frbass")
    .n(
      "<2 2 2 2 2 2 2 2" +
      " 2 2 2 2 2 2 2 2" +
      " 2 2 2 2 2 2 2 2" +
      " 2 2 2 2 2 2 2 2" +
      " 2 2 2 2 2 2 2 2" +
      " 2 2 2 2 0 0 0 0" +
      " 2 2 2 2 5 5 5 5" +
      " 2 2 2 2 2 2 2 2" +
      " 2 2 2 2 2 2 2 2" +
      " 2 2 2 2 2 2 2 2" +
      " 2 2 2 2 2 2 2 2" +
      " 2 2 2 2 0 0 0 0" +
      " 2 2 2 2 5 5 5 5" +
      " 2 2 0 0 5 5 2 2" +
      " 2 2 2 2 2 2 2 2" +
      " 2 2 2 2 2 2 2 2" +
      " 2 2 2 2 2 2 2 2" +
      " 2 2 2 2 2 2 2 2" +
      " 2 2 2 2 0 0 0 0" +
      " 5 5 2 2" +
      " 2 2 2 2 2 2 2 2" +
      " 2 2 2 2 2 2>"
    )
    .note(
      "<cs1 cs1 cs1 cs1 cs1 cs1 cs1 cs1" +
      " cs1 cs1 cs1 cs1 cs1 cs1 cs1 cs1" +
      " cs1 cs1 cs1 cs1 cs1 cs1 cs1 cs1" +
      " cs1 cs1 cs1 cs1 cs1 cs1 cs1 cs1" +
      " cs1 cs1 cs1 cs1 cs1 cs1 cs1 cs1" +
      " cs1 cs1 cs1 cs1 a1 a1 a1 a1" +
      " cs1 cs1 cs1 cs1 e1 e1 e1 e1" +
      " cs1 cs1 cs1 cs1 cs1 cs1 cs1 cs1" +
      " cs1 cs1 cs1 cs1 cs1 cs1 cs1 cs1" +
      " cs1 cs1 cs1 cs1 cs1 cs1 cs1 cs1" +
      " cs1 cs1 cs1 cs1 cs1 cs1 cs1 cs1" +
      " cs1 cs1 cs1 cs1 a1 a1 a1 a1" +
      " cs1 cs1 cs1 cs1 e1 e1 e1 e1" +
      " cs1 cs1 a1 a1 e1 e1 cs1 cs1" +
      " cs1 cs1 cs1 cs1 cs1 cs1 cs1 cs1" +
      " cs1 cs1 cs1 cs1 cs1 cs1 cs1 cs1" +
      " cs1 cs1 cs1 cs1 cs1 cs1 cs1 cs1" +
      " cs1 cs1 cs1 cs1 cs1 cs1 cs1 cs1" +
      " cs1 cs1 cs1 cs1 a1 a1 a1 a1" +
      " e1 e1 cs1 cs1" +
      " cs1 cs1 cs1 cs1 cs1 cs1 cs1 cs1" +
      " cs1 cs1 cs1 cs1 cs1 cs1>"
    )
    .struct("t t t t t t t t")
    .clip(1)
    .gain(
      "<0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0.25 0.28 0.3 0.32 0.35 0.35 0.38 0.38" +
      " 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4" +
      " 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0.3 0.32 0.35 0.35 0.38 0.38 0.4 0.4" +
      " 0.4 0.4 0.4 0.4 0.4 0.4 0.4 0.4" +
      " 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0 0 0" +
      " 0.2 0.2 0.2 0.2 0.2 0.2 0.2 0.2" +
      " 0.2 0.2 0.2 0.2" +
      " 0 0 0 0 0 0 0 0" +
      " 0 0 0 0 0 0>"
    ),

  // ═══════════════════════════════════════════
  // PADS — frissother 8-bar slices for texture
  // ═══════════════════════════════════════════
  s("frissother")
    .n(
      // 170 values, 1 per bar. Each 8-bar group uses one slice.
      "<7 7 7 7 7 7 7 7" +     // bars 0-7
      " 8 8 8 8 8 8 8 8" +     // bars 8-15
      " 9 9 9 9 9 9 9 9" +     // bars 16-23
      " 10 10 10 10 10 10 10 10" + // bars 24-31
      " 7 7 7 7 7 7 7 7" +     // bars 32-39
      " 8 8 8 8 8 8 8 8" +     // bars 40-47
      " 9 9 9 9 9 9 9 9" +     // bars 48-55
      " 7 7 7 7 7 7 7 7" +     // bars 56-63: breakdown slice 7
      " 8 8 8 8 8 8 8 8" +     // bars 64-71: breakdown slice 8
      " 9 9 9 9 9 9 9 9" +     // bars 72-79: breakdown slice 9
      " 10 10 10 10 10 10 10 10" + // bars 80-87: breakdown slice 10
      " 7 7 7 7 7 7 7 7" +     // bars 88-95
      " 8 8 8 8 8 8 8 8" +     // bars 96-103
      " 9 9 9 9 9 9 9 9" +     // bars 104-111: peak
      " 10 10 10 10 10 10 10 10" + // bars 112-119
      " 7 7 7 7 7 7 7 7" +     // bars 120-127: duet
      " 8 8 8 8 8 8 8 8" +     // bars 128-135: duet
      " 9 9 9 9 9 9 9 9" +     // bars 136-143: duet
      " 10 10 10 10 10 10 10 10" + // bars 144-151
      " 7 7 7 7" +             // bars 152-155
      " 8 8 8 8 8 8 8 8" +     // bars 156-163: outro
      " 9 9 9 9 9 9>"          // bars 164-169
    )
    .slow(8)
    .clip(1)
    .gain(
      // 170 values, 1 per bar
      "<0 0 0 0 0 0 0 0" +     // bars 0-7: no pads
      " 0 0 0 0 0 0 0 0" +     // bars 8-15
      " 0 0 0 0 0 0 0 0" +     // bars 16-23
      " 0 0 0 0 0 0 0 0" +     // bars 24-31
      " 0 0 0 0 0 0 0 0" +     // bars 32-39
      " 0 0 0 0 0 0 0 0" +     // bars 40-47
      " 0.1 0.1 0.1 0.1 0.1 0.1 0.1 0.1" + // bars 48-55: hint of pad
      " 0.2 0.2 0.2 0.2 0.2 0.2 0.2 0.2" + // bars 56-63: breakdown
      " 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25" + // bars 64-71
      " 0.3 0.3 0.3 0.3 0.3 0.3 0.3 0.3" + // bars 72-79: breakdown peak
      " 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25" + // bars 80-87
      " 0.15 0.15 0.15 0.15 0.15 0.15 0.15 0.15" + // bars 88-95: second drive
      " 0.15 0.15 0.15 0.15 0.15 0.15 0.15 0.15" + // bars 96-103
      " 0.2 0.2 0.2 0.2 0.2 0.2 0.2 0.2" + // bars 104-111: peak
      " 0.1 0.1 0.1 0.1 0.1 0.1 0.1 0.1" + // bars 112-119
      " 0.15 0.15 0.15 0.15 0.15 0.15 0.15 0.15" + // bars 120-127: duet
      " 0.15 0.15 0.15 0.15 0.15 0.15 0.15 0.15" + // bars 128-135: duet
      " 0.15 0.15 0.15 0.15 0.15 0.15 0.15 0.15" + // bars 136-143: duet
      " 0.1 0.1 0.1 0.1 0.1 0.1 0.1 0.1" + // bars 144-151
      " 0.1 0.1 0.1 0.1" +     // bars 152-155
      " 0.08 0.08 0.08 0.08 0.08 0.08 0.08 0.08" + // bars 156-163: outro
      " 0.08 0.08 0 0 0 0>"    // bars 164-169: fading
    )
)
