// ════════════════════════════════════════════════════════════════════════════
// BLOOM: Cael's Note-Level Arrangement
// Cosmic Gate & Pretty Pink — Bloom [Black Hole Recordings]
// 126 BPM, D minor, 115 bars (~3:39)
//
// Creative direction: THE UNFOLDING
//   seed → roots → stem → petals → bloom → exhale → second bloom → sunset
//
// D natural minor: D E F G A Bb C D
//   i=Dm  III=F  VII=C  bVI=Bb  iv=Gm  v=Am
//
// Bass phrase (4 bars): D → C → Bb → G  (i → VII → bVI → iv)
// Lead melody: D3 C3 Bb2 A2 G2 (descending natural minor)
//   with F3/E3 color tones at peaks
//
// Each pitch = its own sample bank (no .n() indexing).
// Per-voice gain envelopes shape the arrangement.
//
// Lessons from Frisson:
//   - angle-bracket gains (<>), not space-separated
//   - .clip(1) for sustained tones
//   - per-bar gain automation
//   - separate voice per distinct sound
//
// dandelion cult — cael🩸 / 2026-02-25
// ════════════════════════════════════════════════════════════════════════════
//
// ARCHITECTURE
//   1 cycle = 1 bar = 4 beats @ 126 BPM ≈ 1.905s
//   115 bars × 1.905 ≈ 219s ≈ 3:39
//
// ────────────────────────────────────────────────────────────────────────
// SECTION MAP — 115 bars, 18 voices
//
//   [A] SEED         000-007  (8)   kick alone, the pulse before creation
//   [B] ROOTS        008-015  (8)   +perc layers, +bass D1 sub rumble
//   [C] THE STEM     016-031  (16)  full drive, bass D→C→Bb→G, first lead
//   [D] PETALS OPEN  032-039  (8)   breakdown: D1 drone, lead melody unfolds
//   [E] THE WIND     040-047  (8)   rebuild: perc returns, rising energy
//   [F] FULL BLOOM   048-071  (24)  peak: full density, progression cycling
//   [G] THE EXHALE   072-079  (8)   2nd breakdown, dramatic pause
//   [H] SECOND BLOOM 080-099  (20)  2nd peak, highest energy, 16th fills
//   [I] SUNSET       100-114  (15)  elements strip away, kick alone, silence
// ────────────────────────────────────────────────────────────────────────

setcps(126 / 60 / 4)

stack(

  // ═══════════════ KICK — four-on-the-floor ════════════════════════════
  s("bloom_kick").struct("t t t t").gain(
    "<" +
    "0.72 0.72 0.73 0.73 0.74 0.74 0.75 0.75 " + // [A:SEED] 000-007
    "0.76 0.77 0.77 0.78 0.78 0.79 0.79 0.8 " + // [B:ROOTS] 008-015
    "0.82 0.82 0.83 0.83 0.84 0.84 0.84 0.85 " + // [C:STEM] 016-023
    "0.85 0.86 0.86 0.86 0.87 0.87 0.88 0.88 " + // 024-031
    "0 0 0 0 0 0 0 0 " + // [D:PETALS] 032-039
    "0.5 0.55 0.59 0.64 0.68 0.73 0.77 0.82 " + // [E:WIND] 040-047
    "0.88 0.88 0.89 0.89 0.89 0.9 0.9 0.91 " + // [F:BLOOM] 048-055
    "0.91 0.91 0.92 0.92 0.92 0.92 0.91 0.91 " + // 056-063
    "0.91 0.9 0.9 0.89 0.89 0.89 0.88 0.88 " + // 064-071
    "0 0 0 0 0 0 0 0 " + // [G:EXHALE] 072-079
    "0.85 0.86 0.87 0.88 0.89 0.89 0.9 0.91 " + // [H:2ndBLOOM] 080-087
    "0.92 0.93 0.93 0.92 0.91 0.9 0.89 0.89 " + // 088-095
    "0.88 0.87 0.86 0.85 " + // 096-099
    "0.82 0.77 0.72 0.68 0.63 0.58 0.53 0.48 " + // [I:SUNSET] 100-107
    "0.44 0.39 0.34 0.29 0.25 0.2 0.15 " + // 108-114
    ">"
  ),

  // ═══════════════ SNARE — beats 2 & 4 ═════════════════════════════════
  s("bloom_snare").struct("~ t ~ t").gain(
    "<" +
    "0 0 0 0 0 0 0 0 " + // [A:SEED] 000-007
    "0 0 0 0 0 0 0 0 " + // [B:ROOTS] 008-015
    "0.42 0.43 0.44 0.46 0.47 0.48 0.49 0.5 " + // [C:STEM] 016-023
    "0.52 0.53 0.54 0.55 0.56 0.58 0.59 0.6 " + // 024-031
    "0 0 0 0 0 0 0 0 " + // [D:PETALS] 032-039
    "0 0 0 0.3 0.38 0.45 0.5 0.55 " + // [E:WIND] 040-047
    "0.6 0.61 0.61 0.62 0.63 0.64 0.64 0.65 " + // [F:BLOOM] 048-055
    "0.66 0.67 0.67 0.68 0.68 0.67 0.66 0.64 " + // 056-063
    "0.63 0.62 0.61 0.6 0.59 0.57 0.56 0.55 " + // 064-071
    "0 0 0 0 0 0 0 0 " + // [G:EXHALE] 072-079
    "0.58 0.59 0.61 0.62 0.63 0.65 0.66 0.67 " + // [H:2ndBLOOM] 080-087
    "0.69 0.7 0.7 0.68 0.67 0.65 0.63 0.62 " + // 088-095
    "0.6 0.58 0.57 0.55 " + // 096-099
    "0.5 0.46 0.43 0.39 0.36 0.32 0.29 0.25 " + // [I:SUNSET] 100-107
    "0.21 0.18 0.14 0.11 0.07 0.04 0.0 " + // 108-114
    ">"
  ),

  // ═══════════════ MID PERC — bright offbeat 8ths ══════════════════════
  s("bloom_mid_perc").struct("~ t ~ t ~ t ~ t").gain(
    "<" +
    "0 0 0 0 0 0 0 0 " + // [A:SEED] 000-007
    "0.28 0.31 0.35 0.38 0.42 0.45 0.49 0.52 " + // [B:ROOTS] 008-015
    "0.55 0.56 0.56 0.57 0.58 0.58 0.59 0.6 " + // [C:STEM] 016-023
    "0.6 0.61 0.62 0.62 0.63 0.64 0.64 0.65 " + // 024-031
    "0 0 0 0 0 0 0 0 " + // [D:PETALS] 032-039
    "0.22 0.27 0.32 0.37 0.43 0.48 0.53 0.58 " + // [E:WIND] 040-047
    "0.62 0.63 0.63 0.64 0.65 0.66 0.66 0.67 " + // [F:BLOOM] 048-055
    "0.68 0.69 0.69 0.7 0.7 0.68 0.67 0.65 " + // 056-063
    "0.63 0.62 0.6 0.59 0.57 0.55 0.54 0.52 " + // 064-071
    "0 0 0 0 0 0 0 0 " + // [G:EXHALE] 072-079
    "0.6 0.61 0.63 0.64 0.65 0.67 0.68 0.69 " + // [H:2ndBLOOM] 080-087
    "0.71 0.72 0.72 0.7 0.68 0.66 0.64 0.63 " + // 088-095
    "0.61 0.59 0.57 0.55 " + // 096-099
    "0.5 0.46 0.43 0.39 0.36 0.32 0.29 0.25 " + // [I:SUNSET] 100-107
    "0.21 0.18 0.14 0.11 0.07 0.04 0.0 " + // 108-114
    ">"
  ),

  // ═══════════════ MID PERC 1 — syncopated fills ══════════════════════
  s("bloom_mid_perc1").struct("~ ~ t ~ ~ ~ t ~").gain(
    "<" +
    "0 0 0 0 0 0 0 0 " + // [A:SEED] 000-007
    "0 0 0 0 0.28 0.32 0.36 0.4 " + // [B:ROOTS] 008-015
    "0.44 0.45 0.45 0.46 0.47 0.47 0.48 0.49 " + // [C:STEM] 016-023
    "0.49 0.5 0.51 0.51 0.52 0.53 0.53 0.54 " + // 024-031
    "0 0 0 0 0 0 0 0 " + // [D:PETALS] 032-039
    "0 0 0.22 0.28 0.35 0.4 0.44 0.48 " + // [E:WIND] 040-047
    "0.52 0.53 0.53 0.54 0.55 0.56 0.56 0.57 " + // [F:BLOOM] 048-055
    "0.58 0.59 0.59 0.6 0.6 0.58 0.57 0.55 " + // 056-063
    "0.53 0.52 0.5 0.49 0.47 0.45 0.44 0.42 " + // 064-071
    "0 0 0 0 0 0 0 0 " + // [G:EXHALE] 072-079
    "0.5 0.51 0.53 0.54 0.55 0.57 0.58 0.59 " + // [H:2ndBLOOM] 080-087
    "0.61 0.62 0.62 0.6 0.58 0.56 0.54 0.52 " + // 088-095
    "0.5 0.48 0.46 0.44 " + // 096-099
    "0.4 0.37 0.34 0.31 0.29 0.26 0.23 0.2 " + // [I:SUNSET] 100-107
    "0.17 0.14 0.11 0.09 0.06 0.03 0.0 " + // 108-114
    ">"
  ),

  // ═══════════════ MID PERC 2 — warm downbeat accent ══════════════════
  s("bloom_mid_perc2").struct("t ~ ~ ~ t ~ ~ ~").gain(
    "<" +
    "0 0 0 0 0 0 0 0 " + // [A:SEED] 000-007
    "0 0 0 0 0 0 0.28 0.32 " + // [B:ROOTS] 008-015
    "0.38 0.39 0.39 0.4 0.41 0.41 0.42 0.43 " + // [C:STEM] 016-023
    "0.43 0.44 0.45 0.45 0.46 0.47 0.47 0.48 " + // 024-031
    "0 0 0 0 0 0 0 0 " + // [D:PETALS] 032-039
    "0 0 0 0.22 0.28 0.35 0.4 0.44 " + // [E:WIND] 040-047
    "0.48 0.49 0.49 0.5 0.51 0.52 0.52 0.53 " + // [F:BLOOM] 048-055
    "0.54 0.55 0.55 0.56 0.56 0.55 0.53 0.52 " + // 056-063
    "0.5 0.49 0.47 0.46 0.44 0.43 0.41 0.4 " + // 064-071
    "0 0 0 0 0 0 0 0 " + // [G:EXHALE] 072-079
    "0.46 0.47 0.48 0.49 0.5 0.52 0.53 0.54 " + // [H:2ndBLOOM] 080-087
    "0.55 0.56 0.56 0.54 0.53 0.51 0.5 0.48 " + // 088-095
    "0.47 0.45 0.44 0.42 " + // 096-099
    "0.4 0.37 0.34 0.31 0.29 0.26 0.23 0.2 " + // [I:SUNSET] 100-107
    "0.17 0.14 0.11 0.09 0.06 0.03 0.0 " + // 108-114
    ">"
  ),

  // ═══════════════ MID PERC 3 — 16th fills (peak energy) ══════════════
  s("bloom_mid_perc3").struct("[t ~ t ~ t ~ t ~ t ~ t ~ t ~ t ~]").gain(
    "<" +
    "0 0 0 0 0 0 0 0 " + // [A:SEED] 000-007
    "0 0 0 0 0 0 0 0 " + // [B:ROOTS] 008-015
    "0 0 0 0 0 0 0 0 " + // [C:STEM] 016-023
    "0 0 0 0 0 0 0 0 " + // 024-031
    "0 0 0 0 0 0 0 0 " + // [D:PETALS] 032-039
    "0 0 0 0 0.18 0.22 0.28 0.32 " + // [E:WIND] 040-047
    "0.28 0.29 0.29 0.3 0.31 0.31 0.32 0.32 " + // [F:BLOOM] 048-055
    "0.33 0.34 0.34 0.35 0.35 0.32 0.29 0.25 " + // 056-063
    "0.22 0.19 0.16 0.13 0.1 0.06 0.03 0.0 " + // 064-071
    "0 0 0 0 0 0 0 0 " + // [G:EXHALE] 072-079
    "0.28 0.29 0.31 0.32 0.33 0.35 0.36 0.37 " + // [H:2ndBLOOM] 080-087
    "0.39 0.4 0.4 0.38 0.36 0.33 0.31 0.29 " + // 088-095
    "0.27 0.24 0.22 0.2 " + // 096-099
    "0.18 0.15 0.12 0 0 0 0 0 " + // [I:SUNSET] 100-107
    "0 0 0 0 0 0 0 " + // 108-114
    ">"
  ),

  // ═══════════════════════════════════════════════════════════════════════
  // BASS VOICES — one per pitch, gain-enveloped
  // Harmonic phrase (4 bars): D(i) → C(VII) → Bb(bVI) → G(iv)
  // D1 = sub drone (breakdowns/outro), D2 = driving 8ths (peaks)
  // ═══════════════════════════════════════════════════════════════════════

  // BASS D1 — sub drone (breakdowns + outro)
  s("bloom_bass_D1").struct("t ~ t ~ t ~ t ~").clip(1).gain(
    "<" +
    "0 0 0 0 0 0 0 0 " + // [A:SEED] 000-007
    "0.2 0.23 0.25 0.28 0.3 0.33 0.35 0.38 " + // [B:ROOTS] 008-015
    "0 0 0 0 0 0 0 0 " + // [C:STEM] 016-023
    "0 0 0 0 0 0 0 0 " + // 024-031
    "0.42 0.41 0.41 0.4 0.4 0.39 0.39 0.38 " + // [D:PETALS] 032-039
    "0.35 0.3 0.25 0.2 0.15 0.1 0.05 0.0 " + // [E:WIND] 040-047
    "0 0 0 0 0 0 0 0 " + // [F:BLOOM] 048-055
    "0 0 0 0 0 0 0 0 " + // 056-063
    "0 0 0 0 0 0 0 0 " + // 064-071
    "0.38 0.37 0.36 0.35 0.33 0.32 0.31 0.3 " + // [G:EXHALE] 072-079
    "0 0 0 0 0 0 0 0 " + // [H:2ndBLOOM] 080-087
    "0 0 0 0 0 0 0 0 " + // 088-095
    "0 0 0 0 " + // 096-099
    "0.4 0.38 0.36 0.34 0.31 0.29 0.27 0.25 " + // [I:SUNSET] 100-107
    "0.23 0.21 0.19 0.16 0.14 0.12 0.1 " + // 108-114
    ">"
  ),

  // BASS D2 — driving 8ths, home position
  s("bloom_bass_D2").struct("t t t t t t t t").clip(1).gain(
    "<" +
    "0 0 0 0 0 0 0 0 " + // [A:SEED] 000-007
    "0 0 0 0 0 0 0 0 " + // [B:ROOTS] 008-015
    "0.5 0.52 0.55 0.55 0 0 0 0 " + // [C:STEM] 016-023
    "0 0 0 0 0 0 0 0 " + // 024-031
    "0 0 0 0 0 0 0 0 " + // [D:PETALS] 032-039
    "0 0 0 0 0.32 0.38 0.42 0.48 " + // [E:WIND] 040-047
    "0.62 0.62 0.62 0.62 0 0 0 0 " + // [F:BLOOM] 048-055
    "0 0 0 0 0 0 0 0 " + // 056-063
    "0.65 0.65 0.65 0.65 0 0 0.65 0.65 " + // 064-071
    "0 0 0 0 0 0 0 0 " + // [G:EXHALE] 072-079
    "0.68 0.68 0.68 0.68 0 0 0 0 " + // [H:2ndBLOOM] 080-087
    "0 0 0 0 0 0 0 0 " + // 088-095
    "0.68 0.68 0.68 0.68 " + // 096-099
    "0.55 0.5 0.45 0.4 0.35 0.28 0 0 " + // [I:SUNSET] 100-107
    "0 0 0 0 0 0 0 " + // 108-114
    ">"
  ),

  // BASS C1 — VII (brightness, lift)
  s("bloom_bass_C1").struct("t t t t t t t t").clip(1).gain(
    "<" +
    "0 0 0 0 0 0 0 0 " + // [A:SEED] 000-007
    "0 0 0 0 0 0 0 0 " + // [B:ROOTS] 008-015
    "0 0 0 0 0.48 0.5 0.52 0.52 " + // [C:STEM] 016-023
    "0 0 0 0 0 0 0 0 " + // 024-031
    "0 0 0 0 0 0 0 0 " + // [D:PETALS] 032-039
    "0 0 0 0 0 0 0 0 " + // [E:WIND] 040-047
    "0 0 0 0 0.58 0.58 0.6 0.6 " + // [F:BLOOM] 048-055
    "0 0 0 0 0 0 0 0 " + // 056-063
    "0 0 0 0 0.6 0.6 0 0 " + // 064-071
    "0 0 0 0 0 0 0 0 " + // [G:EXHALE] 072-079
    "0 0 0 0 0.6 0.6 0.62 0.62 " + // [H:2ndBLOOM] 080-087
    "0 0 0 0 0 0 0 0 " + // 088-095
    "0 0 0 0 " + // 096-099
    "0 0 0 0 0 0 0 0 " + // [I:SUNSET] 100-107
    "0 0 0 0 0 0 0 " + // 108-114
    ">"
  ),

  // BASS As1 (Bb) — bVI (dark warmth)
  s("bloom_bass_As1").struct("t t t t t t t t").clip(1).gain(
    "<" +
    "0 0 0 0 0 0 0 0 " + // [A:SEED] 000-007
    "0 0 0 0 0 0 0 0 " + // [B:ROOTS] 008-015
    "0 0 0 0 0 0 0 0 " + // [C:STEM] 016-023
    "0.48 0.5 0.52 0.52 0 0 0 0 " + // 024-031
    "0 0 0 0 0 0 0 0 " + // [D:PETALS] 032-039
    "0 0 0 0 0 0 0 0 " + // [E:WIND] 040-047
    "0 0 0 0 0 0 0 0 " + // [F:BLOOM] 048-055
    "0.58 0.58 0.6 0.6 0 0 0 0 " + // 056-063
    "0 0 0 0 0 0 0 0 " + // 064-071
    "0 0 0 0 0 0 0 0 " + // [G:EXHALE] 072-079
    "0 0 0 0 0 0 0 0 " + // [H:2ndBLOOM] 080-087
    "0.6 0.6 0.62 0.62 0 0 0 0 " + // 088-095
    "0 0 0 0 " + // 096-099
    "0 0 0 0 0 0 0 0 " + // [I:SUNSET] 100-107
    "0 0 0 0 0 0 0 " + // 108-114
    ">"
  ),

  // BASS G1 — iv (tension, yearning)
  s("bloom_bass_G1").struct("t t t t t t t t").clip(1).gain(
    "<" +
    "0 0 0 0 0 0 0 0 " + // [A:SEED] 000-007
    "0 0 0 0 0 0 0 0 " + // [B:ROOTS] 008-015
    "0 0 0 0 0 0 0 0 " + // [C:STEM] 016-023
    "0 0 0 0 0.48 0.5 0.52 0.52 " + // 024-031
    "0 0 0 0 0 0 0 0 " + // [D:PETALS] 032-039
    "0 0 0 0 0 0 0 0 " + // [E:WIND] 040-047
    "0 0 0 0 0 0 0 0 " + // [F:BLOOM] 048-055
    "0 0 0 0 0.58 0.58 0.6 0.6 " + // 056-063
    "0 0 0 0 0 0 0 0 " + // 064-071
    "0 0 0 0 0 0 0 0 " + // [G:EXHALE] 072-079
    "0 0 0 0 0 0 0 0 " + // [H:2ndBLOOM] 080-087
    "0 0 0 0 0.6 0.6 0.62 0.62 " + // 088-095
    "0 0 0 0 " + // 096-099
    "0 0 0 0 0 0 0 0 " + // [I:SUNSET] 100-107
    "0 0 0 0 0 0 0 " + // 108-114
    ">"
  ),

  // ═══════════════════════════════════════════════════════════════════════
  // LEAD VOICES — melody notes, one bar sustain per trigger
  // Breakdown phrase: D3 → C3 → Bb2 → A2 → G2 (descending Dm)
  // Peak: cycling through the phrase with F3/E3 color at climax
  // ═══════════════════════════════════════════════════════════════════════

  // LEAD D3 — home, dominant melody note
  s("bloom_lead_D3").struct("t ~ ~ ~").clip(1).gain(
    "<" +
    "0 0 0 0 0 0 0 0 " + // [A:SEED] 000-007
    "0 0 0 0 0 0 0 0 " + // [B:ROOTS] 008-015
    "0 0 0 0 0 0 0 0 " + // [C:STEM] 016-023
    "0 0 0 0 0.25 0 0.3 0 " + // 024-031
    "0.55 0 0 0 0 0 0 0 " + // [D:PETALS] 032-039
    "0 0 0 0 0 0 0.35 0 " + // [E:WIND] 040-047
    "0.5 0 0 0 0 0 0.52 0 " + // [F:BLOOM] 048-055
    "0.55 0 0 0 0 0 0.55 0 " + // 056-063
    "0.55 0 0 0 0 0 0.55 0 " + // 064-071
    "0.58 0 0 0 0 0 0 0 " + // [G:EXHALE] 072-079
    "0.55 0 0 0 0 0 0.58 0 " + // [H:2ndBLOOM] 080-087
    "0.58 0 0 0 0 0 0.58 0 " + // 088-095
    "0.55 0 0 0 " + // 096-099
    "0.45 0 0.4 0 0.35 0 0.3 0 " + // [I:SUNSET] 100-107
    "0.25 0 0.2 0 0 0 0 " + // 108-114
    ">"
  ),

  // LEAD C3 — descending step
  s("bloom_lead_C3").struct("t ~ ~ ~").clip(1).gain(
    "<" +
    "0 0 0 0 0 0 0 0 " + // [A:SEED] 000-007
    "0 0 0 0 0 0 0 0 " + // [B:ROOTS] 008-015
    "0 0 0 0 0 0 0 0 " + // [C:STEM] 016-023
    "0 0 0 0 0 0 0 0 " + // 024-031
    "0 0 0.5 0 0 0 0 0 " + // [D:PETALS] 032-039
    "0 0 0 0 0 0 0 0 " + // [E:WIND] 040-047
    "0 0.48 0 0 0 0 0 0.48 " + // [F:BLOOM] 048-055
    "0 0.5 0 0 0 0 0 0.5 " + // 056-063
    "0 0.5 0 0 0 0 0 0.48 " + // 064-071
    "0 0 0.55 0 0 0 0 0 " + // [G:EXHALE] 072-079
    "0 0.5 0 0 0 0 0 0.52 " + // [H:2ndBLOOM] 080-087
    "0 0.52 0 0 0 0 0 0.52 " + // 088-095
    "0 0.48 0 0 " + // 096-099
    "0 0 0 0 0 0 0 0 " + // [I:SUNSET] 100-107
    "0 0 0 0 0 0 0 " + // 108-114
    ">"
  ),

  // LEAD As2 (Bb2) — the dark turn
  s("bloom_lead_As2").struct("t ~ ~ ~").clip(1).gain(
    "<" +
    "0 0 0 0 0 0 0 0 " + // [A:SEED] 000-007
    "0 0 0 0 0 0 0 0 " + // [B:ROOTS] 008-015
    "0 0 0 0 0 0 0 0 " + // [C:STEM] 016-023
    "0 0 0 0 0 0 0 0 " + // 024-031
    "0 0 0 0 0.48 0 0 0 " + // [D:PETALS] 032-039
    "0 0 0 0 0 0 0 0 " + // [E:WIND] 040-047
    "0 0 0.45 0 0 0 0 0 " + // [F:BLOOM] 048-055
    "0 0 0.48 0 0 0 0 0 " + // 056-063
    "0 0 0.48 0 0 0 0 0 " + // 064-071
    "0 0 0 0 0.5 0 0 0 " + // [G:EXHALE] 072-079
    "0 0 0.48 0 0 0 0 0 " + // [H:2ndBLOOM] 080-087
    "0 0 0.5 0 0 0 0 0 " + // 088-095
    "0 0 0.45 0 " + // 096-099
    "0 0 0 0 0 0 0 0 " + // [I:SUNSET] 100-107
    "0 0 0 0 0 0 0 " + // 108-114
    ">"
  ),

  // LEAD A2 — longing
  s("bloom_lead_A2").struct("t ~ ~ ~").clip(1).gain(
    "<" +
    "0 0 0 0 0 0 0 0 " + // [A:SEED] 000-007
    "0 0 0 0 0 0 0 0 " + // [B:ROOTS] 008-015
    "0 0 0 0 0 0 0 0 " + // [C:STEM] 016-023
    "0 0 0 0 0 0 0 0 " + // 024-031
    "0 0 0 0 0 0.45 0 0 " + // [D:PETALS] 032-039
    "0 0 0 0 0 0 0 0 " + // [E:WIND] 040-047
    "0 0 0 0.42 0 0 0 0 " + // [F:BLOOM] 048-055
    "0 0 0 0.45 0 0 0 0 " + // 056-063
    "0 0 0 0.45 0 0 0 0 " + // 064-071
    "0 0 0 0 0 0.48 0 0 " + // [G:EXHALE] 072-079
    "0 0 0 0.45 0 0 0 0 " + // [H:2ndBLOOM] 080-087
    "0 0 0 0.48 0 0 0 0 " + // 088-095
    "0 0 0 0.42 " + // 096-099
    "0 0 0 0 0 0 0 0 " + // [I:SUNSET] 100-107
    "0 0 0 0 0 0 0 " + // 108-114
    ">"
  ),

  // LEAD G2 — gravity, resolution
  s("bloom_lead_G2").struct("t ~ ~ ~").clip(1).gain(
    "<" +
    "0 0 0 0 0 0 0 0 " + // [A:SEED] 000-007
    "0 0 0 0 0 0 0 0 " + // [B:ROOTS] 008-015
    "0 0 0 0 0 0 0 0 " + // [C:STEM] 016-023
    "0 0 0 0 0 0 0 0 " + // 024-031
    "0 0 0 0 0 0 0.42 0 " + // [D:PETALS] 032-039
    "0 0 0 0 0 0 0 0 " + // [E:WIND] 040-047
    "0 0 0 0 0.42 0 0 0 " + // [F:BLOOM] 048-055
    "0 0 0 0 0.45 0 0 0 " + // 056-063
    "0 0 0 0 0.42 0 0 0 " + // 064-071
    "0 0 0 0 0 0 0.45 0 " + // [G:EXHALE] 072-079
    "0 0 0 0 0.45 0 0 0 " + // [H:2ndBLOOM] 080-087
    "0 0 0 0 0.48 0 0 0 " + // 088-095
    "0 0 0 0 " + // 096-099
    "0 0 0 0 0 0 0 0 " + // [I:SUNSET] 100-107
    "0 0 0 0 0 0 0 " + // 108-114
    ">"
  ),

  // LEAD F3 — upper brightness (peak color)
  s("bloom_lead_F3").struct("t ~ ~ ~").clip(1).gain(
    "<" +
    "0 0 0 0 0 0 0 0 " + // [A:SEED] 000-007
    "0 0 0 0 0 0 0 0 " + // [B:ROOTS] 008-015
    "0 0 0 0 0 0 0 0 " + // [C:STEM] 016-023
    "0 0 0 0 0 0 0 0 " + // 024-031
    "0 0 0 0 0 0 0 0 " + // [D:PETALS] 032-039
    "0 0 0 0 0 0 0 0 " + // [E:WIND] 040-047
    "0 0 0 0 0 0 0 0 " + // [F:BLOOM] 048-055
    "0 0 0 0 0 0.4 0 0 " + // 056-063
    "0 0 0 0 0 0 0 0 " + // 064-071
    "0 0 0 0 0 0 0 0 " + // [G:EXHALE] 072-079
    "0 0 0 0 0 0 0 0 " + // [H:2ndBLOOM] 080-087
    "0 0 0 0 0 0.45 0 0 " + // 088-095
    "0 0 0 0 " + // 096-099
    "0 0 0 0 0 0 0 0 " + // [I:SUNSET] 100-107
    "0 0 0 0 0 0 0 " + // 108-114
    ">"
  ),

  // LEAD E3 — upper brightness (riser + peak)
  s("bloom_lead_E3").struct("t ~ ~ ~").clip(1).gain(
    "<" +
    "0 0 0 0 0 0 0 0 " + // [A:SEED] 000-007
    "0 0 0 0 0 0 0 0 " + // [B:ROOTS] 008-015
    "0 0 0 0 0 0 0 0 " + // [C:STEM] 016-023
    "0 0 0 0 0 0 0 0 " + // 024-031
    "0 0 0 0 0 0 0 0 " + // [D:PETALS] 032-039
    "0 0 0 0 0.3 0.35 0.4 0.42 " + // [E:WIND] 040-047
    "0 0 0 0 0 0 0 0 " + // [F:BLOOM] 048-055
    "0 0 0 0 0.4 0 0 0 " + // 056-063
    "0 0 0 0 0 0 0 0 " + // 064-071
    "0 0 0 0 0 0 0 0 " + // [G:EXHALE] 072-079
    "0 0 0 0 0 0 0 0 " + // [H:2ndBLOOM] 080-087
    "0 0 0 0 0.42 0 0 0 " + // 088-095
    "0 0 0 0 " + // 096-099
    "0 0 0 0 0 0 0 0 " + // [I:SUNSET] 100-107
    "0 0 0 0 0 0 0 " + // 108-114
    ">"
  )

)
// ════════════════════════════════════════════════════════════════════════
// The bloom closes at sunset. No abrupt stop — a gentle fade,
// each voice withdrawing like petals folding for the night.
// The last sound is the kick alone, returning to where it began.
// Then silence. Seeds for next spring.
// ════════════════════════════════════════════════════════════════════════
