# Systems Dynamics Core

## System Definition
A system has three parts:
- Elements: the parts you can count or name.
- Interconnections: the relationships and feedback between parts.
- Purpose: the behavior the system keeps producing.

Focus on behavior over time. The structure of the system drives its behavior.

## Stocks, Flows, and Feedback
- Stock: a quantity that accumulates (inventory, backlog, cash, trust).
- Flow: a rate that increases or decreases a stock.
- Feedback loop: a circular causal chain that changes stocks or flows.

Loop types:
- Reinforcing: amplifies change (growth or collapse).
- Balancing: resists change and seeks stability.

## Delays and Nonlinearity
Delays are time lags between action and effect. Delays create oscillations and resistance to change. Nonlinearity means small changes can cause big effects or vice versa.

## Common Behavior Patterns
- Limits to growth: reinforcing growth hits a constraint and slows.
- Overshoot and collapse: growth outpaces buffers and reverses sharply.
- Oscillation: balancing loops with delays create cycles.
- Shifting the burden: short-term fixes weaken long-term capability.
- Success to the successful: resources flow to winners, reinforcing advantage.
- Tragedy of the commons: shared resource overuse harms all.

## Leverage Points (Ordered)
List below is ordered from lower leverage (12) to higher leverage (1).

12. Constants, parameters, numbers (taxes, standards, thresholds)
11. Buffer sizes relative to flows
10. Structure of material stocks and flows
9. Length of delays relative to the rate of change
8. Strength of balancing feedback loops
7. Gain around reinforcing feedback loops
6. Structure of information flows (who sees what and when)
5. Rules of the system (incentives, punishments, constraints)
4. Power to add, change, evolve, or self-organize structure
3. Goals of the system
2. Mindset or paradigm out of which the system arises
1. Power to transcend paradigms

## Practice Rules
- Observe the system before intervening; learn its history and rhythm.
- Protect self-maintenance capacities; avoid undermining what already works.
- Expose mental models; invite challenges and alternative hypotheses.
- Stay humble and keep learning; expect surprise.
- Honor information; prioritize accuracy and timeliness.
- Place responsibility within the system; close feedback loops.
- Design feedback policies that adapt with system state.
- Attend to important qualities, not only what is easy to measure.
- Optimize for the whole, not for a local maximum.
- Expand time horizons; consider long-term effects.
- Expand thought horizons; cross disciplinary boundaries.
- Expand the boundary of caring; recognize interdependence.
- Celebrate complexity; avoid forcing false simplicity.
- Hold fast to goodness; keep standards from eroding.

## Mapping Toolkit
- Causal loop diagram: show reinforcing and balancing loops.
- Stock and flow diagram: show accumulations and rates.
- Iceberg model: events, patterns, structure, mental models.

## Diagnostic Questions
- What is the system boundary and why?
- Which stocks matter most and how do they change?
- What are the key reinforcing and balancing loops?
- Where are the delays and information gaps?
- Which leverage points are feasible and safe to change?
- What unintended consequences are likely?
