# Structured Communication Core

## Purpose and Core Idea
Make the answer obvious and the logic easy to follow. State the conclusion first, then support it with grouped reasons and evidence. Aim for clarity, not completeness.

## Hierarchical Structure Basics
- Start with the answer (the governing thought) at the top.
- Support with 2-5 grouped points that directly justify the answer.
- Under each point, add evidence and examples.
- Keep each level a clean layer of logic with no cross-mixing.

## SCQA Framing
Use SCQA to set up the governing question.
- Situation: shared context and facts.
- Complication: tension, change, or problem.
- Question: the decision or issue to resolve.
- Answer: your top-line conclusion.

Prompting checklist:
- What changed or is now at risk?
- What decision is blocked by uncertainty?
- What would a decisive answer sound like in one sentence?

## Logic Types and Grouping
Use two logic patterns, but do not mix them in a single layer.

Deductive (top-down):
- A implies B, B implies C, therefore C.
- Use when the argument is a chain of reasoning.

Inductive (bottom-up):
- Evidence set A, B, C implies conclusion X.
- Use when the argument is a grouped set of examples or facts.

Grouping rules:
- Make buckets mutually exclusive and collectively exhaustive (MECE).
- Group by a single principle (time, process stage, customer segment, cost type).
- Label groups as assertions, not topics.

## Building the Structure (Process)
1. Define the governing question and decision.
2. Draft a provisional answer in one sentence.
3. Create an issue tree to expand causes or options.
4. Prioritize issues by impact and evidence availability.
5. Group issues into MECE buckets; label each as an assertion.
6. Add evidence under each bucket.
7. Sequence the buckets for maximum clarity.
8. Refine the top-line to align with the structure below.

## Quality Checks
- Test the top-line: can a senior reader act on it in 30 seconds?
- Check MECE: no overlaps, no gaps.
- Verify logic: each support point must be necessary for the answer.
- Enforce parallelism: same grammar and level of abstraction in a layer.
- Remove noise: cut facts that do not change the conclusion.

## Common Failure Modes
- Topic headings instead of assertions.
- Mixing causes, solutions, and evidence in one layer.
- Too many points at one level (more than 5).
- Vague claims with no testable evidence.
- Repeating the same point under different labels.

## Output Templates

One-page memo:
- Answer (1 sentence)
- Key supports (2-5 bullets)
- Evidence per support (2-4 bullets each)
- Recommendation and next steps

Slide outline:
- Slide 1: Answer + why now
- Slide 2-4: Key supports (one per slide)
- Slide 5: Risks and mitigations
- Slide 6: Decision or ask

SCQA stub:
- Situation:
- Complication:
- Question:
- Answer:
