---
name: stringclaw
description: "Make real phone calls to your users via Stringclaw voice AI"
version: 0.0.5
metadata:
  openclaw:
    emoji: "📞"
    primaryEnv: "STRINGCLAW_API_KEY"
    requires:
      env: ["STRINGCLAW_API_KEY"]
      bins: ["stringclaw-bridge"]
    install:
      - kind: node
        package: "@stringclaw/bridge"
        bins: ["stringclaw-bridge"]
---

## stringclaw

Make real phone calls to your users via Stringclaw.

When a user asks you to call them (e.g. "give me a call", "call me", "phone me"),
use this skill to initiate an outbound voice call. The call connects them to a
live voice session with you — your full tools and memory are available during the call.

### Model requirements

Voice calls require a fast model for natural conversation. You **must** be running
one of these (or equivalent) to avoid awkward pauses and timeouts:

- `gemini-3-flash` (recommended)
- `claude-haiku`
- `gpt-4o-mini`

If your current model is too slow, tell the user to switch before calling.

### Before making a call

The Stringclaw bridge must be running. Check and start if needed:

```
pgrep -f "stringclaw-bridge serve" || stringclaw-bridge serve &
```

### Making a call

Use the bridge CLI. The call goes to the phone number configured in the user's Stringclaw dashboard.

```
stringclaw-bridge call
```

### Output

**Success:** `{"success":true,"callId":"..."}`

**Errors (JSON on stderr, exit code 1):**
- `{"error":"Invalid API key"}` — bad or missing API key
- `{"error":"No minutes remaining. Top up at stringclaw.com"}` — out of minutes
- `{"error":"No phone number configured. Set one at stringclaw.com/dashboard/settings"}` — no phone number set in dashboard

### Example

User: "Hey, can you give me a call?"

1. Ensure the bridge is running (`pgrep -f "stringclaw-bridge serve"`, start if needed).
2. Run `stringclaw-bridge call`.
3. If successful, reply: "Calling you now! Pick up in a moment."
4. If out of minutes, reply: "You're out of Stringclaw minutes. Top up at stringclaw.com."
5. If no phone number configured, reply: "You need to set your phone number at stringclaw.com/dashboard/settings first."
