# Streaming Services Reference

## Supported Services

| Service | ID | Available Regions |
|---------|-----|-------------------|
| Netflix | `netflix` | Global |
| Amazon Prime Video | `amazon-prime` | Global |
| Disney+ | `disney-plus` | Global |
| Apple TV+ | `apple-tv-plus` | Global |
| YouTube Premium | `youtube-premium` | Global |
| HBO Max / WOW | `wow` | DE, AT, US |
| Paramount+ | `paramount-plus` | Global |
| Crunchyroll | `crunchyroll` | Global |
| Sky | `sky` | DE, AT, UK |
| Joyn Plus+ | `joyn-plus` | DE |
| RTL+ | `rtl-plus` | DE |
| MagentaTV | `magenta-tv` | DE |
| ARD Mediathek | `ard` | DE (free) |
| ZDF Mediathek | `zdf` | DE (free) |
| ARTE | `arte` | DE, FR (free) |
| Freevee | `freevee` | US, UK, DE (free) |
| Pluto TV | `pluto-tv` | Global (free) |
| Tubi | `tubi` | US (free) |
| Peacock | `peacock` | US |
| Hulu | `hulu` | US |
| Stan | `stan` | AU |
| Crave | `crave` | CA |
| MUBI | `mubi` | Global (art house) |

## Service Tiers

### Active Services
Services user is currently subscribed to. Used for primary recommendations.

### Occasional Services
Services user subscribes to periodically (e.g., for specific shows). Used for "worth subscribing" recommendations.

## JustWatch Provider Mapping

TMDB returns provider names from JustWatch. Common mappings:

| TMDB Name | Internal ID |
|-----------|-------------|
| "Netflix" | `netflix` |
| "Amazon Prime Video" | `amazon-prime` |
| "Disney Plus" | `disney-plus` |
| "Apple TV Plus" | `apple-tv-plus` |
| "WOW" | `wow` |
| "Sky Go" | `sky` |
| "YouTube Premium" | `youtube-premium` |
| "Paramount Plus" | `paramount-plus` |
| "Crunchyroll" | `crunchyroll` |
| "Joyn Plus" | `joyn-plus` |
| "RTL+" | `rtl-plus` |
| "MagentaTV" | `magenta-tv` |
