# Strategic Thinking Techniques

## The 5 Core Techniques

### 1. First Principles Thinking

**What:** Decompose to fundamental truths, rebuild without inherited assumptions.

**When:** Existing solutions feel constrained, "that's how it's done" isn't working.

**How:**
1. Identify the assumption you're making
2. Ask "Is this fundamentally true, or just convention?"
3. What would you do if starting from scratch?

**Example:**
- Convention: "Batteries are expensive because materials cost X"
- First principles: What are the raw materials? What are market prices? What are the actual physics limits?
- Result: Tesla found batteries 80% cheaper than "industry standard" suggested

---

### 2. Second-Order Thinking

**What:** Think beyond immediate effects to consequences of consequences.

**When:** Any decision with systemic effects, competitive moves, policy changes.

**How:**
1. First-order: "If we do X, Y happens"
2. Second-order: "If Y happens, then Z happens"
3. Third-order: "If Z happens, then..."

**Example:**
- First-order: "Lower prices → more customers"
- Second-order: "More customers → competitor lowers prices"
- Third-order: "Price war → margin compression → need new differentiation"

---

### 3. Inversion (Munger)

**What:** Instead of how to succeed, ask how to fail — then avoid those things.

**When:** Complex problems where direct approach is unclear, risk assessment.

**How:**
1. Invert the question: "How would I guarantee failure?"
2. List all the ways to fail
3. Systematically avoid each failure mode

**Example:**
- Question: "How do I build a successful company?"
- Inverted: "How do I guarantee failure?"
- Answer: Ignore customers, burn cash, hire wrong people, ignore market changes
- Strategy: Obsess over customers, manage cash, hire carefully, stay alert

---

### 4. Pre-Mortem Analysis (Gary Klein)

**What:** Imagine the project already failed, then work backward to causes.

**When:** Before committing to any significant strategy or project.

**How:**
1. "It's 12 months from now. This strategy failed completely."
2. Each person writes: "It failed because..."
3. Aggregate and address the most likely failure modes NOW

**Why it works:** Easier to imagine failure than admit current flaws. Surfaces concerns people won't voice directly.

---

### 5. Probabilistic Thinking

**What:** Assign probabilities to outcomes instead of treating things as certain/impossible.

**When:** Decisions under uncertainty, forecasting, risk assessment.

**How:**
1. List possible outcomes
2. Assign probability to each (must sum to 100%)
3. Calculate expected value: Σ(probability × outcome)
4. Update probabilities as new information arrives

**Example:**
```
Launch new product:
- Success (50%): +$10M profit
- Moderate (30%): +$2M profit
- Failure (20%): -$3M loss

Expected value: (0.5 × 10) + (0.3 × 2) + (0.2 × -3) = $5M + $0.6M - $0.6M = $5M
```

---

## Complementary Techniques

### Opportunity Cost Thinking
"What am I giving up by doing this?" Every choice has an implicit rejection of alternatives.

### Regret Minimization (Bezos)
"At 80, which decision would I regret more — doing this or not doing it?"

### Circle of Competence
"Am I qualified to make this decision, or should I defer to someone who is?"

### Margin of Safety
"What buffer do I need so that being wrong doesn't destroy me?"

---

## Technique Selection Guide

| Situation | Use This |
|-----------|----------|
| Stuck in conventional thinking | First Principles |
| Evaluating competitive move | Second-Order |
| Identifying risks | Inversion |
| Pre-launch risk assessment | Pre-Mortem |
| Choosing under uncertainty | Probabilistic |
| Resource allocation | Opportunity Cost |
| Major life/career decisions | Regret Minimization |
| Outside expertise area | Circle of Competence |
| High-stakes irreversible decisions | Margin of Safety |
