# Strategy Design Process

## The 4-Phase Process

### Phase 0: Problem Clarification (NEVER SKIP)

**The client's stated problem is usually wrong.** Dig deeper.

Questions to ask:
- "Why is this important now?" (timing reveals urgency/politics)
- "What have you tried?" (avoid repeating failures)
- "What does success look like?" (often undefined)
- "Who needs to agree?" (stakeholder map)
- "What can't change?" (real constraints)

**Output:** Single-sentence problem statement that everyone agrees on.

---

### Phase 1: Structuring (Make It MECE)

**Break the problem into analyzable pieces.**

1. Write the central question as a single sentence
2. Build Issue Tree (mutually exclusive, collectively exhaustive)
3. Form initial hypotheses for each branch
4. Prioritize: Which 2-3 branches have most impact?

Example Issue Tree:
```
How can we grow revenue 30% in 12 months?
├── Increase customer acquisition
│   ├── New channels?
│   ├── Conversion improvement?
│   └── Pricing changes?
├── Increase customer retention
│   ├── Churn reduction?
│   └── Contract length?
└── Increase revenue per customer
    ├── Upsell existing?
    └── New products?
```

**Output:** Prioritized list of sub-questions to answer.

---

### Phase 2: Analysis (Test Hypotheses)

**Gather evidence to validate or refute each hypothesis.**

For each priority branch:
1. What data would prove/disprove the hypothesis?
2. Where can we get that data? (internal, research, interviews)
3. What's the "so what?" — implications of each finding

Analysis types:
- **Quantitative:** Benchmarks, metrics, financial modeling
- **Qualitative:** Customer interviews, expert input
- **Competitive:** What are others doing? What works?

**Output:** Validated/refuted hypotheses with evidence.

---

### Phase 3: Synthesis (Build the Story)

**Turn findings into a coherent narrative.**

Structure (Pyramid Principle):
1. **Situation:** Where we are (facts, no judgment)
2. **Complication:** Why it's a problem (tension, urgency)
3. **Resolution:** What to do about it (recommendation)

For each recommendation:
- Clear action ("Do X")
- Rationale ("Because Y evidence shows Z")
- Trade-off ("This means not doing W")
- Risk ("Could fail if A happens")

**Output:** 3 strategic options with trade-offs clearly stated.

---

### Phase 4: Recommendation (Commit and Plan)

**Pick one path and plan execution.**

Elements:
- **Primary recommendation:** "We should do X"
- **Confidence level:** High/Medium/Low with reasoning
- **Implementation roadmap:** 90-day milestones
- **Success metrics:** How we'll know it's working
- **Kill criteria:** When to abandon if failing
- **Week-1 actions:** 3 concrete next steps

**Output:** One-page strategy summary + action plan.

---

## Common Process Failures

| Failure | Symptom | Fix |
|---------|---------|-----|
| Skipping Phase 0 | Solving wrong problem | "Why?" x 5 before analysis |
| Boiling the ocean | Analysis paralysis | Prioritize 2-3 branches max |
| No "so what?" | Data without insight | Force implication statement for every finding |
| Too many options | Decision fatigue | Max 3 options, recommend 1 |
| Vague actions | No accountability | Specific owner + deadline for each action |

---

## Time Allocation Guide

| Phase | % of Total Time | For a 2-week project |
|-------|-----------------|----------------------|
| Problem Clarification | 15% | 1.5 days |
| Structuring | 10% | 1 day |
| Analysis | 50% | 5 days |
| Synthesis | 15% | 1.5 days |
| Recommendation | 10% | 1 day |

Most people spend too little time on Phase 0 (clarification) and too much on Phase 2 (analysis without direction).
