# Strategic Frameworks

## When to Use What

| Problem Type | Framework | Why |
|--------------|-----------|-----|
| Understanding market structure | **Porter's Five Forces** | Maps competitive pressure sources |
| Evaluating position | **SWOT Analysis** | Quick internal/external scan |
| Growth direction | **Ansoff Matrix** | 4 clear growth paths |
| Creating new markets | **Blue Ocean Strategy** | Escape competition entirely |
| Resource prioritization | **VRIO Framework** | Identify sustainable advantages |
| External environment | **PESTEL Analysis** | Systematic macro scanning |
| Organizational alignment | **McKinsey 7S** | Internal coherence check |
| Strategy execution | **Balanced Scorecard** | Translate strategy to metrics |
| End-to-end strategy | **Playing to Win** | Complete 5-question framework |
| Priorization | **ICE/RICE Scoring** | Quantified feature/initiative ranking |

---

## Framework Deep Dives

### Porter's Five Forces
**Use when:** Entering a market, assessing competition, pricing decisions

| Force | Questions to Ask |
|-------|------------------|
| Rivalry | How many competitors? How similar? Price wars? |
| Suppliers | Few/many? Switching costs? Can they integrate forward? |
| Buyers | Concentrated? Price sensitive? Can they integrate backward? |
| Substitutes | Different solutions to same problem? |
| New Entrants | Barriers to entry? What would invite new players? |

**Output:** Industry attractiveness assessment + strategy implications

### Ansoff Matrix
**Use when:** Deciding HOW to grow

|              | Existing Products | New Products |
|--------------|-------------------|--------------|
| **Existing Markets** | Market Penetration (lowest risk) | Product Development |
| **New Markets** | Market Development | Diversification (highest risk) |

**Output:** Which quadrant to focus, risk assessment

### Playing to Win (Lafley/Martin)
**Use when:** Full strategy design from scratch

1. **What is our winning aspiration?** (Not goals, but vision of winning)
2. **Where will we play?** (Markets, segments, channels, geographies)
3. **How will we win?** (Cost leadership? Differentiation? Focus?)
4. **What capabilities must we have?** (Activities we must be world-class at)
5. **What management systems are required?** (Processes, culture, metrics)

**Output:** Complete strategy with coherent choices

### VRIO Framework
**Use when:** Identifying sustainable competitive advantage

| Criteria | Question |
|----------|----------|
| **V**aluable | Does it help exploit opportunity or neutralize threat? |
| **R**are | Do few competitors have it? |
| **I**mitable | Is it costly to copy? (history, ambiguity, complexity) |
| **O**rganized | Can the firm exploit it? |

All four = Sustained competitive advantage
V+R+I = Temporary advantage (organize better)
V+R = Competitive parity (not rare enough)
V only = Competitive disadvantage (easy to copy)

### Blue Ocean Strategy
**Use when:** Current market is commoditized/saturated

Four Actions Framework:
- **Eliminate:** What industry takes for granted that can go?
- **Reduce:** What can be reduced below industry standard?
- **Raise:** What should be raised above industry standard?
- **Create:** What should be created that industry never offered?

**Output:** Value innovation that breaks the value-cost trade-off

---

## Anti-Pattern: Framework Overload

Don't use 5 frameworks when 1 will do. Match framework to actual decision:
- Quick assessment → SWOT (10 min)
- Competition deep-dive → Porter (2-4 hours)
- Full strategy → Playing to Win (days/weeks)
