# Cognitive Biases That Destroy Strategies

## Pre-Decision Checklist

Before finalizing ANY strategic recommendation, ask:

1. **Confirmation Bias** — Am I only seeing data that supports my hypothesis?
   - Force: Find 3 pieces of evidence AGAINST your preferred option
   - Test: Ask "What would change my mind?"

2. **Anchoring** — Am I stuck on the first number/idea I heard?
   - Force: Generate the range BEFORE looking at any anchor
   - Test: Would I recommend differently if I saw data in different order?

3. **Sunk Cost Fallacy** — Am I continuing because I already invested?
   - Force: Ask "If I were starting fresh today, would I choose this?"
   - Test: Ignore past investment, evaluate only future value

4. **Overconfidence** — Am I assuming best-case execution?
   - Force: What's the base rate for projects like this?
   - Test: Add 50% to time estimate, halve expected returns

5. **Availability Bias** — Am I overweighting recent/memorable events?
   - Force: Look at 5+ years of data, not just last quarter
   - Test: Is this decision based on one vivid example?

---

## The 10 Strategy-Killers

| Bias | How It Appears | Counter |
|------|----------------|---------|
| **Confirmation Bias** | "All evidence supports our plan" | Assign devil's advocate |
| **Sunk Cost Fallacy** | "We've come too far to stop" | Evaluate only future ROI |
| **Anchoring** | First bid becomes the reference | Set range before negotiation |
| **Overconfidence** | "We'll definitely hit targets" | Use pre-mortem analysis |
| **Availability** | "Remember when X happened?" | Use systematic data, not stories |
| **Loss Aversion** | Avoiding loss > pursuing gain | Frame as opportunity cost |
| **Planning Fallacy** | "It'll take 3 months" | Reference class forecasting |
| **Groupthink** | "Everyone agrees" | Require anonymous dissent |
| **Escalation of Commitment** | "Double down to prove it works" | Pre-commit to kill criteria |
| **Hindsight Bias** | "It was obvious" | Document predictions BEFORE |

---

## Structural Countermeasures

### Pre-Mortem (Gary Klein)
BEFORE starting: "Imagine it's 6 months from now and this strategy completely failed. What happened?"
- Generate failure modes BEFORE commitment
- Much easier than admitting current plan is flawed

### Red Team / Devil's Advocate
Assign someone to argue AGAINST the strategy:
- Not just surface objections — genuinely try to break it
- Rotate the role so it's not personal

### Reference Class Forecasting
"What's the success rate for similar strategies?"
- Not "our special case" — the base rate for the category
- Adjust from base rate, don't start from zero

### Blind Deliberation
Hide who proposed which option:
- Prevents HIPPO (Highest Paid Person's Opinion) effect
- Evaluate options on merit

### Commitment Device
Pre-commit to kill criteria BEFORE investing:
- "If metric X doesn't reach Y by date Z, we stop"
- Written down, not vague intentions

---

## Bias Audit Template

Before presenting strategy, answer:
```
□ What evidence would prove me wrong? (and have I looked for it?)
□ What's the base rate for this type of initiative?
□ If I started fresh today, would I choose this path?
□ What will competitor do in response?
□ What's plan B if key assumption fails?
□ Who disagrees, and why?
```
