# Evvo Labs — Strategy Frameworks 2026
**Applied:** VRIO · Value Stick · Blue Ocean · McKinsey Horizons · Strategy Diamond
**Last updated:** 2026-02-26
**Owner:** Vince Chew (COO + CISO)

---

## 1. VRIO Analysis — Evvo Labs

| Resource / Capability | Valuable? | Rare? | Inimitable? | Organized? | Result |
|---|---|---|---|---|---|
| **PromptDome Shield Engine** (32 categories, 18 languages, agentic chain detection) | ✅ | ✅ | ✅ (months to replicate) | ✅ | **Sustained Competitive Advantage** |
| **CREST-approved VAPT delivery** | ✅ | ✅ (few in SG) | Moderate | ✅ | **Sustained Competitive Advantage** |
| **ISO27001 + CTM consulting depth** (93 controls × 16 frameworks mapped) | ✅ | Moderate | Low (others can map too) | ✅ | **Temporary Competitive Advantage** |
| **Vietnam ops (cost arbitrage + talent)** | ✅ | ✅ | Moderate | ✅ | **Sustained Competitive Advantage** |
| **AI + Cybersecurity combined BU** | ✅ | ✅ (rare in SG SME space) | Moderate | In progress | **Temporary → Sustained (if organised fast)** |
| **Government cybersecurity track record (2014+)** | ✅ | ✅ | ✅ (earned, not bought) | ✅ | **Sustained Competitive Advantage** |
| **Generalist ICT delivery** | ✅ | ❌ | ❌ | ✅ | **Competitive Equality** |

**Pro Tip (applied):** Re-evaluate quarterly. PromptDome engine is the most inimitable asset — invest to keep it ahead. Government track record is the moat for public sector deals.

---

## 2. Value Stick — PromptDome

```
 ─────────────────────────────────────────
  WTP  |  Customer Delight Zone
       |  Savings from breach prevention
       |  Compliance peace of mind
       |  Developer hours saved (no manual scanning)
 ─────────────────────────────────────────
 Price |  $49–$499/mo SaaS (Starter → Enterprise)
       |  Firm Margin (engine = ~zero marginal cost)
 ─────────────────────────────────────────
  Cost |  Hosting (VPS) + support + R&D
       |  Supplier Surplus (minimal — self-built engine)
  WTS  |
 ─────────────────────────────────────────
```

**Raise WTP (make customers willing to pay more):**
- Add compliance reporting (SOC2, ISO27001 audit-ready exports) → enterprise buyers pay premium
- Show breach cost comparison in onboarding ("average AI prompt injection breach: $4.2M")
- SDK depth (Python, Node, OpenAI adapter) → stickier, higher switching cost

**Lower WTS (reduce our cost to serve):**
- Engine is already self-built = near-zero COGS at scale
- Vietnam team handles support + monitoring at cost arbitrage
- Auto-scaling on existing VPS = no per-customer infra spend until significant scale

**Increase Margin:** Both levers above = high-margin SaaS business.

---

## 3. Blue Ocean Strategy — PromptDome + AI Security

**The Red Ocean:** Azure Prompt Shields, Lakera Guard, LLM Guard, Rebuff — all competing on enterprise AI security with high price points ($1,000+/mo) targeting large US/EU companies.

**Our Blue Ocean:** **AI security for the builder economy** — startups, SMEs, solo developers, OpenClaw users, ASEAN companies — who need enterprise-grade protection at developer-friendly prices.

| Factor | Industry Standard (Red Ocean) | Evvo / PromptDome (Blue Ocean) |
|---|---|---|
| **Price** | $500–$5,000/mo | $49–$499/mo |
| **Integration** | Complex SDK + dedicated onboarding | One `pip install` / one-command OpenClaw skill |
| **Target** | US/EU enterprise | ASEAN + global builders, SMEs |
| **Compliance focus** | SOC2, GDPR | ISO27001, MAS TRM, CTM (SG-specific) |
| **AI agent support** | Basic | Deep (AgentSessionContext, chain scoring) |

**ERRC Grid:**
| Eliminate | Reduce | Raise | Create |
|---|---|---|---|
| Complex enterprise onboarding | Sales-led motion | Detection accuracy (32 categories) | OpenClaw native skill (zero-friction install) |
| Minimum 12-month contracts | Time-to-first-scan | Multilingual coverage (18 languages) | AI agent chain-level analysis |
| Per-seat pricing confusion | Support overhead (Vietnam team) | API response speed | SG compliance-native profiles |

---

## 4. McKinsey's Strategic Horizons — Evvo Labs

### Horizon 1 — Maintain & Defend Core (Now → 2026)
**Revenue engines to protect:**
- VAPT delivery (CREST-approved, government + enterprise)
- ISO27001 / Cyber Trust Mark consulting (SGD 1.265M ACV model)
- ICT managed services (recurring base)

**Actions:**
- CRM discipline — every lead logged (Rodney owns)
- Sales enablement twice-weekly (consulting catalog ready)
- Vietnam SecOps expansion (Finn + Vincent onboarded)

### Horizon 2 — Nurture Emerging Business (2026 → 2027)
**Bets to build:**
- **PromptDome SaaS** — growing ARR, first 100 paying customers
- **AI Security consulting** — AI Governance gap (73% enterprises unprepared) = new service line
- **cyberforge.one platform** — multi-product distribution under one domain

**Actions:**
- PromptDome: Get first 10 paying customers in Q2 2026
- Package AI Governance assessment as a consulting service (CK leads)
- Build case studies from VAPT + AI advisory engagements

### Horizon 3 — Create Genuinely New Business (2027+)
**Long-horizon bets:**
- PromptDome as ASEAN's standard AI security layer (like what Cloudflare is for web)
- Evvo AI as a regional AI safety certification body
- Platform play: `cyberforge.one` hosts 5+ AI security tools under one brand

**Actions:**
- File for Singapore AI safety certification partnerships (IMDA, CSA)
- Explore white-labelling PromptDome engine to telcos / MSSPs in SEA

---

## 5. Strategy Diamond — Evvo Labs

### Arenas — Where will we compete?
- **Product categories:** AI security (PromptDome), VAPT, compliance consulting (ISO27001, CTM, MAS TRM)
- **Channels:** Direct (inbound/outbound sales), SaaS self-serve (PromptDome), tender/government procurement
- **Market segments:** SG government + enterprise (H1), ASEAN SME / developer (H2), global AI builders (H3)

### Vehicles — How will we get there?
- **Internal dev:** Shield Engine, PromptDome (self-built, owned)
- **Partnerships:** MAS-regulated FIs (compliance advisory), CREST network (VAPT referrals)
- **Licensing:** PromptDome API (SaaS), OpenClaw skill distribution (ClawHub)
- **Acquisitions:** Not current priority — build > buy at this stage

### Differentiators — How will we win?
- **Price:** PromptDome at 10× lower cost than US competitors
- **Reliability:** 99.9% uptime, fail-open architecture (never blocks legitimate traffic)
- **Compliance-native:** SG/ASEAN regulatory profiles built-in (not bolted on)
- **Depth:** Only engine with AI agent chain analysis + 18-language evasion detection

### Staging & Pacing — What's our speed & sequence?
1. **Q1 2026:** Ship PromptDome v1, first paying customers, lock cyberforge.one platform
2. **Q2 2026:** 10 paying customers, AI Governance consulting service live, Vietnam team contributing to PromptDome support
3. **Q3 2026:** 50 customers, first MSSP white-label conversation, ClawHub skill in top 10
4. **Q4 2026:** $100K ARR PromptDome, H1 consulting at plan, begin H3 platform conversations

### Economic Logic — How will we get returns?
- **Lowest cost:** Vietnam cost arbitrage on delivery + self-built engine = industry-leading margin
- **Premium price:** For compliance-native, enterprise-ready tier (SOC2 reports, SLA, audit exports)
- **Hybrid model:** Consulting revenue (H1) funds product R&D (H2/H3) — profitable from day one

---

## Summary — One-Page Strategy

| Dimension | Decision |
|---|---|
| **Core moat** | Shield Engine (inimitable) + government track record |
| **Blue ocean** | AI security for ASEAN builders at developer price points |
| **Current horizon** | H1 (defend VAPT/consulting) + H2 (grow PromptDome) simultaneously |
| **Win strategy** | Price + compliance-native + ease of integration |
| **Growth sequence** | Consulting funds product → product scales without headcount |
| **Platform bet** | cyberforge.one = multi-product AI security distribution |

---
*Update this document quarterly or when strategy shifts. Reference during sales, fundraising, and product prioritization decisions.*

---

## Applied: Every Business Decision — Quick Lens

### Before Any New Initiative, Answer These:

**VRIO Check**
- Does this give us Value? Rarity? Is it Inimitable? Are we Organised to exploit it?
- If no to 2+ → don't invest heavily. Partner or buy instead.

**Value Stick Check**
- Does this raise customer WTP (they'll pay more)?
- Does this lower our WTS (costs less to deliver)?
- If neither → skip it.

**Blue Ocean Check**
- Are we competing in a red ocean (saturated, price wars)?
- What can we Eliminate / Reduce / Raise / Create to make competition irrelevant?

**Horizons Check**
- Is this H1 (protect cash)? H2 (grow)? H3 (create future)?
- Are we over-investing in H3 while H1 is at risk? Or stagnating in H1?

**Strategy Diamond Check**
- Arenas: exactly WHERE will we compete?
- Vehicles: HOW do we enter (build / partner / license)?
- Differentiators: WHY will we win?
- Staging: WHEN and in what sequence?
- Economic Logic: HOW do we make money?

---

## Applied: All Evvo Business Lines

### VAPT (Penetration Testing)
- **VRIO:** CREST approval = rare + inimitable in SG SME space → sustained advantage
- **Value Stick:** WTP raised by government track record + CREST badge; WTS lowered by Vietnam team doing report writing
- **Blue Ocean:** Red ocean = big firms (KPMG, Deloitte). Our ocean = SMEs + scale-ups that need CREST quality without Big4 price
- **Horizon:** H1 — defend and grow. Cash engine.
- **Diamond:** Arena = SG + SEA SME/enterprise | Win = price + speed + CREST credibility

### ISO27001 / Cyber Trust Mark Consulting
- **VRIO:** 93 controls × 16 frameworks mapped = knowledge asset; hard to replicate fast
- **Value Stick:** Raise WTP by bundling CTM + ISO27001 (one engagement, two certs) → clients pay more for efficiency
- **Blue Ocean:** Red ocean = generic ISO consultants. Our ocean = AI-era ISO27001 (adds AI Governance controls, MAS TRM, CTM 2025)
- **Horizon:** H1 core + H2 expansion (AI Governance as new service line)
- **Diamond:** Win = compliance-native for SG regulatory landscape (MAS TRM, CSA, PDPA, CTM)

### PromptDome (AI Security SaaS)
- **VRIO:** Shield Engine = inimitable → sustained advantage
- **Value Stick:** Near-zero COGS → massive margin potential; raise WTP via compliance reporting
- **Blue Ocean:** ASEAN builders at $49–$499/mo — no one else is here
- **Horizon:** H2 — nurture and grow to $100K ARR by end 2026
- **Diamond:** Win = price + SG compliance-native + one-command install

### Vietnam Operations
- **VRIO:** Cost arbitrage + talent depth = rare for a SG-headquartered firm → competitive advantage
- **Value Stick:** Lowers WTS significantly across all delivery lines
- **Blue Ocean:** Enables us to price competitively in red oceans where big firms can't follow
- **Horizon:** H1 enabler — makes H1 more profitable, funds H2

### AI Business Unit (CK's team)
- **VRIO:** Combined AI + cybersecurity expertise = very rare in SG → build fast, organize now
- **Blue Ocean:** AI Security as a service (not just tools) — enterprise AI audits, AI red-teaming
- **Horizon:** H2 → H3 — AI commercialization in progress
- **Diamond:** Arenas = SG enterprise AI adopters needing AI governance | Win = technical depth + regulatory fluency

---

## Decision Log (Running)
*Record major decisions made using these frameworks here.*

| Date | Decision | Framework Used | Outcome |
|---|---|---|---|
| 2026-02-26 | Renamed IngestShield → PromptDome | Blue Ocean (clearer positioning) | Done ✅ |
| 2026-02-26 | Chose cyberforge.one as platform domain | Strategy Diamond (Arenas — multi-product) | Done ✅ |
| 2026-02-26 | Priced PromptDome at $49–$499/mo | Value Stick (maximize WTP–WTS gap) | Live ✅ |
| 2026-02-26 | Self-built shield engine vs licensing Azure | VRIO (inimitable > licensing) | Done ✅ |

