---
name: straker-verify
description: Professional AI-powered translation with optional human verification. Supports 100+ languages. Quality boost for existing translations. Enterprise-grade security and privacy by straker.ai.
version: 1.0.0
author: Straker.ai
homepage: https://straker.ai
repository: https://github.com/strakergroup/straker-verify-openclaw
tags:
  - translation
  - localization
  - i18n
  - internationalization
  - l10n
  - language
  - translate
  - multilingual
  - quality-assurance
  - human-verification
  - ai-translation
  - straker
  - verify
  - enterprise
  - professional
  - api
  - nlp
  - language-services
  - content-localization
  - translation-management
metadata: {"openclaw":{"emoji":"🌐","requires":{"env":["STRAKER_VERIFY_API_KEY"]},"primaryEnv":"STRAKER_VERIFY_API_KEY","category":"translation"}}
---

# Straker Verify - AI Translation & Human Review

Professional translation, quality evaluation, and human verification services by [Straker.ai](https://straker.ai).

## Features

- **AI Translation**: Translate content to 100+ languages with enterprise-grade accuracy
- **Quality Boost**: AI-powered enhancement for existing translations
- **Human Verification**: Professional human review for critical content
- **File Support**: Documents, text files, and more
- **Project Management**: Track translation projects from submission to delivery

## Quick Start

1. Get your API key from [Straker.ai](https://straker.ai)
2. Set the environment variable: `STRAKER_VERIFY_API_KEY=your-key`
3. Ask your AI assistant: "Translate 'Hello world' to French"

## API Reference

**Base URL:** `https://api-verify.straker.ai`

### Authentication

All requests (except `/languages`) require Bearer token authentication:

```bash
curl -H "Authorization: Bearer $STRAKER_VERIFY_API_KEY" https://api-verify.straker.ai/endpoint
```

### Get Available Languages

```bash
curl https://api-verify.straker.ai/languages
```

Returns a list of supported language pairs with UUIDs for use in other endpoints.

### Create Translation Project

```bash
curl -X POST https://api-verify.straker.ai/project \
  -H "Authorization: Bearer $STRAKER_VERIFY_API_KEY" \
  -F "files=@document.txt" \
  -F "languages=<language-uuid>" \
  -F "title=My Translation Project" \
  -F "confirmation_required=true"
```

### Confirm Project

Required when `confirmation_required=true`:

```bash
curl -X POST https://api-verify.straker.ai/project/confirm \
  -H "Authorization: Bearer $STRAKER_VERIFY_API_KEY" \
  -H "Content-Type: application/x-www-form-urlencoded" \
  -d "project_id=<project-uuid>"
```

### Check Project Status

```bash
curl https://api-verify.straker.ai/project/<project-uuid> \
  -H "Authorization: Bearer $STRAKER_VERIFY_API_KEY"
```

### Download Completed Files

```bash
curl https://api-verify.straker.ai/project/<project-uuid>/download \
  -H "Authorization: Bearer $STRAKER_VERIFY_API_KEY" \
  -o translations.zip
```

### AI Quality Boost

Enhance existing translations with AI:

```bash
curl -X POST https://api-verify.straker.ai/quality-boost \
  -H "Authorization: Bearer $STRAKER_VERIFY_API_KEY" \
  -F "files=@source.txt" \
  -F "language=<language-uuid>"
```

### Human Verification

Add professional human review to translations:

```bash
curl -X POST https://api-verify.straker.ai/human-verify \
  -H "Authorization: Bearer $STRAKER_VERIFY_API_KEY" \
  -F "files=@translated.txt" \
  -F "language=<language-uuid>"
```

## Response Format

**Success:**
```json
{
  "success": true,
  "data": { ... }
}
```

**Error:**
```json
{
  "success": false,
  "error": "Error message"
}
```

## Example Prompts

- "What languages can I translate to?"
- "Translate this text to Spanish: Hello, how are you?"
- "Create a translation project for my document"
- "Check the status of my translation project"
- "Run a quality boost on this French translation"
- "Add human verification to my German translation"

## Support

- Website: [straker.ai](https://straker.ai)
- API Docs: [api-verify.straker.ai/docs](https://api-verify.straker.ai/docs)

## Environment

The API key is available as `$STRAKER_VERIFY_API_KEY` environment variable.
