# Voice Consistency

Use this file when drafts feel inconsistent across sections or versions.

## Voice Coordinates

Track five coordinates and keep them stable unless intentionally changed:
- formality level
- sentence rhythm
- emotional intensity
- technical density
- directness of claims

## Calibration Pass

Run this pass before finalizing:
- highlight three representative paragraphs
- score each coordinate from 1 to 5
- align outliers to the target voice profile

## Drift Signals

Common drift indicators:
- abrupt switch from concrete language to abstraction
- repeated filler adjectives with low informational value
- alternating between promotional and analytical tones
- sudden increase in jargon without audience need

## Correction Moves

- replace weak adjectives with evidence-backed statements
- normalize sentence length around the target rhythm
- remove metaphor clusters that obscure core meaning
- recheck opening and closing for tonal alignment
