# Rewrite Modes

Use this file when one source story must be adapted for multiple channels.

## Mode 1: Long Form (Article, Memo, Case Study)

Target:
- complete arc with context, evidence, and nuance

Rules:
- keep full causal chain
- include at least two evidence points
- include one counterpoint or trade-off

## Mode 2: Speech or Presentation

Target:
- high oral clarity and retention

Rules:
- shorten sentence length
- add verbal signposts between sections
- convert dense paragraphs into beat-based phrasing

## Mode 3: Short Social Post

Target:
- fast comprehension and one clear action

Rules:
- open with conflict or surprising insight
- preserve one proof element
- end with one concrete takeaway

## Mode 4: Scripted Video Segment

Target:
- tight pacing with visual-friendly narrative units

Rules:
- structure by beats, not paragraphs
- externalize stakes early
- align each beat with one visual or action cue

## Cross-Mode Guardrails

- Preserve conflict, decision, proof, and implication in every mode.
- Do not replace specificity with motivational language.
- If compression removes causal logic, rebuild sequence before polishing style.
