import base64
import json

# Function to encode an image to base64
def encode_image_to_base64(image_path):
    with open(image_path, "rb") as image_file:
        return base64.b64encode(image_file.read()).decode('utf-8')

# Image file path (relative path since the script and image are in the same directory)
image_path = "testpicf.png"  # Change this to the actual image filename

# Encode image to base64
encoded_base64 = encode_image_to_base64(image_path)

# Save the base64 data to a text file
with open("file_base64.txt", "w") as base64_file:
    base64_file.write(encoded_base64)

print("Base64 encoded data has been written to 'file_base64.txt'")



#signature: 3ycMLwt6w1Wu5qa9XqJ69cR2X1SngWikfKUeZQFHnz7ts3RoUkbxAjqrxw4B2gC1i9QD6Jt2x4m4NCUHvkVyp82y
#filename: karlmark31.jpg
#data_base64:iVBORw0KGgoAAAANSUhEUgAAAoIAAAFhCAYAAADkyMukAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAAEnQAABJ0Ad5mH3gAACfsSURBVHhe7d1bjiW5laxhPWgAOSNp/pPqBitFpKcF71xcdCf/DzBUxfY7ye1hFWqc86//AwAAwJX+pR8AAADgDhRBAACAS1EEAQAALkURBAAAuBRFEAAA4FIUQQAAgEtRBAEAAC5FEQQAALgURRAAAOBSFEEAAIBLUQQBAAAuRREEAAC4FEUQAADgUhRBAACAS1EEAQAALkURBAAAuBRFEAAA4FIUQQAAgEtRBAEAAC5FEQQAALgURRAAAOBSFEEAAIBLUQQBAAAuRREEAAC4FEUQAADgUhRBAACAS1EEAQAALkURBAAAuBRFEAAA4FIUQQAAgEtRBAEAAC5FEQQAALgURRAAAOBSFEEAAIBLUQQBAAAuRREEAAC4FEUQAADgUhRBAACAS1EEAQAALkURBAAAuBRFEAAA4FIUQQAAgEtRBAEAAC5FEQQAALgURRAAAOBSFEEAAIBLUQQBAAAuRREEAAC4FEUQAADgUhRBAACAS1EEAQAALkURBAAAuBRFEAAA4FIUQQAAgEtRBAEAAC5FEQQAALgURRAAAOBSFEEAAIBLUQQBAAAuRREEAAC4FEUQAADgUhRBAACAS1EEAQAALkURBAAAuBRFEAAA4FIUQQAAgEtRBAEAAC5FEQQAALgURRAAAOBSFEEAAIBLUQQBAAAuRREEAAC4FEUQAADgUhRBAACAS1EEAQAALkURBAAAuBRFEAAA4FIUQQAAgEtRBAEAAC5FEQQAALgURRAAAOBSFEEAAIBLUQQBAAAuRREEAAC4FEUQAADgUhRBAACAS1EEAQAALkURBAAAuBRFEAAA4FIUQQAAgEtRBAEAAC5FEQQAALgURRAAAOBSFEEAAIBLUQQBAAAuRREEAAC4FEUQAADgUhRBAACAS1EEAQAALkURBAAAuBRFEAAA4FIUQQAAgEtRBAEAAC5FEQQAALgURRAAAOBSFEEAAIBLUQQBAAAuRREEAAC4FEUQ//jPf/5jEgAA8B0UwQNpOUvlv//974/PVuV5LQAA8B4UwQNo8dICNlv6Zo/XhPMBAID9KIIfpMXqWbD0s5lYn++ZZ0kFAAB7UAQ/IFWiekta7/6plM6h2/TnlgAAAF8UwZfTstSTkTJmcexsAACAD4rgS8VSlCpkz89S278YfQ4AALAeRfBltCBZRwvXaKzOkwvmMZ4AgBqK4ItoGbohqUIJGzqujC0AQFEEX0B/Wd8ezEsVbMYXAKAogpvpL+nWlH7Rr8yK6z7PCRs6xjrOjDUAIKAIbqS/mL+ckWdJHYN5OqapcWbMAQABRXAj/YXc8kv75GCejmlrAAB3oghuor+IPQpg6zVq+9W2j+6LeTqmtej8AIC+J0rB91EEN9Bfvvpz7rOe7W+P3j9s6DhrdNxzAXCv1ndGaRu+gyLoTL8spZS+ZG/L7L1ino5pSO+8PPcHcCd9L7Sm9r7BO1EEndW+KDcGNnRcn5lZdwDuou+AVcE7UAQd6ZegNzO/zFfF4p4wL4yjxVyUAuAO+t33CvagCDrSRU/44luJ40kZBDBLv/ceaXl3YQ2KoCNd1D1JfUlSnz23pbanPqtl5JjWYF4Yx5VzlAqAc8Xv+fO9suodkztv6tq5fVuiz2aRU1AEnegCGsnMl2BVZu4JNnRcrVN6CQM4j37PLZJ6f3jF+9pfQxF04r0Q354wHpin47ojAM6i3/Gb0/O7O+yr+38BRdCBLpYvJbWwU9F99GcNbOi4to7/TPTcAM6i3/mR6HtCU9s+mtx5c5/Xto1Gz/lmFEEHukBaootIU9v+9txCn9v62fXcrWkt+C0BcBb9jq+K1TvIKqn7SX1WSm3/N6IIOtCFcENKX4ab6LPnMkLPURrzUkaPCwFwHv2eh8y8J2az89q19N7br1+/fnwWkxv7uG0ViuBiOpm9aV1kpcX1ttxEn70lYc5b6HGWaV13AM7T8i7Iff7GvOlew+/qGN0Wt+tnIStRBBfTycyldaGW9sstoDflJvrsPXnOc05u/5G0Ht9yXwC+Tb/3Fml9x3wlo8/TWgT1/CtRBBfTSR6NLopUSovrLbnJc87iv+s/e/Kk5/UOgHPp9/3N0Xeg/vy21H5P57atRBFcTCdzdWqLzCPhixjuQb+Qt9FxeWt0nloC4Fz6fb8pI+/DUvR8o7+jV6IILqaTORJdSKVto4vMOql7uI0+v2XiPKfGOUbXhlUAnE2/81+I9ftOz6c/j6b0zi5lJYrgYjqZq1MqB8+FvEruHm6k4z+S55zFf3+WwJZCaBGPtQPgHfT7f0qsylxPntdseU/n7nEliuBiOpkeeS62XfSebhSeO/elTqV1Xy2AGt3fMgDOp9/7lndTyz6l6PH6s6a2/W0J9zvzfl6JIriQTqRX3uRt9+NF58QyWvxy0eNCZl+eAM6n3/tcUv+Lxc6k7iH1WSql9+YbshJFcCGdSK9gP52T1pdRS7Tw1aLHzwTA+fR7/4Xk3rG5z2Os3pe168xmJYrgQjqRXsF+Oiea0ZeGvrRaM3PN53EAzqfvgC+k9/2m70h9X9bSe73ZrEQRXEgn0ivYT+eklJ4Xir6weqPn6wmAO+h33zI977vZpK6l78RU9Jg3ZCWK4EI6kV7BfjonFtGX1Wj0vK0BcAf97p8SfReWosfuzkoUwcV0MktJ/dfLSLCfzklvUmtBX1Sz0fPXAuAO+t2PSb2XcunZd3X03dcSPcdMdCziz+Gfui2XlSiCi+lk5tK6GFqCvXQ+LKIvKavodXIBcA/9/n81+r7rjZ4vxvL3dWtWogguppPpEeyl85GKvkj0Z42+oCxTu3bYDuAe+g6Yib5faj9bRN9xo9HztmbFM61EEVxMJ9Mj2EvnYyTP/+lAX06rovfwDIB76Pe/NSsKUE/0nWYRvYZFSuOU27YSRXAxnUyvYB+di5noS2l19PohAO6i74AvRN9lVtHrWCZX+lJZiSK4mE6mV7CPzsVM9KXkEb0HAHd5fv9TZSV8lvp8R/T9ZR293q6sRBFcTCdzNL1fOuyjc6FpnUt9IXkn3gcA5Oh7yyv6vloZvfaOrEQRXEwncyatBSIEe+Tm6vl/86dzlYu+jHYEAHroe8w6+o7yiN7D6qR+T6xEEVxMJ9Mr2EPnYTT6ItqVcC8AMELfa7PR95NX9D48E0vhShTBxXRSZ5L6r4RcsIfOw2j0RbQjek8AMEPfKa3Rd9OO6D31puf3dyorUQQX08mMmV0UtWAPnYeR6AtoV+L9PP9nbQCwpu9Affe84b2o9+adlSiCDnRCPYI9dB5yKf2HgL6AdkXvKwYAvOm7M/UO1XeYZXLXnE3rOVeiCDrQCfUK/Okc9EZfPruSeznx10EAu+j7yDsqvCt1n1VZiSLoQCc0l9wv39HA13PsR+ZSy9jO6L2lEp8RWCGuMSDKvYO8onR7KbP3uhJF0MHsAhgNfOn490bL2K7ofeXyXNeANV1jrDUEuh5mk1pjuZTovtZZiSLoIEzic7H1LLye6HnhT+ekNVrGdkbvrRYKIazpGkuFv0jfS9eCroncz7NppcfFzNzPShRBBzqhz8wsjFrwHjo3Gi1ju6L3NRJglq6pXOL7k/8YuYuuA69Y0fO2ZCWKoAOd0FRWFEK813OetIztjK6hVEprlV/ImJVaS7m07IPz6Bz3ronRnIoi6EQXVCrWCxjfoGVsV3T9PDO6NoFeuoZak/rroCZsw/fpvK5OXFOnogg60YXlFbzbc660mHlG141lgFa6dixSKoYh+B6dQ6+ciiLoRBeUV/BeOlfPaFFbHb1+T1K/aFOfATW6ZryDb9B5603q/RQ+q31+Koqgk9zis45eA++Vmi+NFrYV0WuuDJCja2Umte9VLvgGnTfLlNbOqSiCTnRBrUhqAeOdUnNVipY3y+i1VgdI0XXiHXyHzp1XTkURdKILyiPhlzzeSeeqNVriZqPnt06p8AKRrg3vhHWK79D588qpKIJOdEF5Be+jc9QbLXMz0XN7h1/ACHRd7Ai+Q+fOK6eiCDrRBWWZ0l9dQvAuOj+a2nyGaKEbiZ5zJC332hrcKc5/ai3Fz1LbLINv0fnLJbVuUp+15lQUQSe6oDyD99C5eab3l54Wu97o+Xbm+cy4i66FHcG3xHkrvStL20ZzKoqgE11QnsF7xDlpfUm17KcFryV6jjcG59M53xV8i86fRVretaeiCDrSRZVbhC0LsjfYT+ckxGquteiVoseuiNVzheBcz3lOrZnUZ9bB9+gceuVUFEFHuqg8g/10TnIZ/eWnhS8XPe4LwZl0nmsZ/W6Ugu/ROfTKqSiCjnRRWaT1xYi9dD5a520kWvxKJXDVfcTzjp4/dxzOoXO7I/gmncee5N4ttW0hp6IIOmpZaCuDfXQuVkcLYK4I5mK5TmfPlToe36dzuiP4Jp3HkNR7wjqnogg604XlGeyh8+CVVAmsvSx1u/78pryZ3msqN4tjYLm+es+F79K59MqpKILOdGGF9L7ARhKugT10LqxTWz+9fw38WjzoNWtjnkvuuPj5LfT5dwTfpXPplVNRBJ3pwmpJ7pdHLanj4EvHfzSpueyNxTl2pnb/VvS8tetqWvYv7fPcdiJ93lpKYzUafJvOp0Va1tmpKILOdGH1pLZQa9tD4Ktnblr26Unqr0y6z3O/EzJDz/WWhPk5SXie3WsO36bz6ZHTvodPFMENdIGtSO5FCz+leUilZ9+eKN3+9vSOS694Db1O/Fk/n0nLuXL7nEKfyzs4g86rR05FEdxAF5dn4ONZLPSfudS2a1r2z9H9cmm5xmxy18h9nspz3/jvNXrcTKzOk0vrM72dPpc+n0dwBp1Xj5yKIriJLjDPYD0d89m0lklNje5fSu+1c6mdp7a9Z1+l21vPoyntnyqlrWnd/6v0OUbTOk66H86hc+2RU1EEN9EF5hmsFcZ4pgxYpZUe15va89W2l5I7NvV56rOQlufMHfvmfI3e/zOW4186F86hc1ua99K2npyKIriJLjDPYB0d655YvaxiesXjWu6jZZ83RJ8tpHTvpW1vS7jXL9H7H81zjnrmC2fR+e1dDyM5FUVwE11gtVgucKwTxrd1rkZ/oeXO8cwoPc/X0/tMufH0Ts99fIHes1Vaxinug7Po/HrkVBTBjXSR1WK14LGGjnOI1Zw903LOWXo+r5SerbStlpljLc8xktR19bO30/vdEZxF59cjp6IIbqSLzCuwp2O8M1b0vCuyuiCsPv+b8lZ6n7noXOnPM8F5dI49ciqK4EbPF53lS68W2Apj2jN/PfuOxJqevyWWz9h7rtb/7/T0vPpzLqn94mepbZ55I71Hq5TGWrfhPKX5Hk3tPKeiCG6ki8wrsBXHtfYS8cgqep3WzIxJ77G7/v9U7r3PFYn38DZ6nx7R+cB5dM69ciqK4Ea6yLwCO89x1V9AtfTu35KV9Fqp1J6ptr038XyxBO4ogtaZGaNw7JvMPk8tqXPrZziPzvlz7nX+R5I6x9u+W5YoghvpQvMKbDzHVF8c+rNHvOh1U/F8/lQJXHH9Fee0TLy/N9F79Egch5N/cd9O5zwX6+/sqSiCG+ki8wps6Lhq9CWkP1vHm15/9fOl8iyBJ/w10CpvoPcU47lOcCadZ6+ciiK4kS6yWqxeoJinY/rM8y8Sum1VdtH78EytBHqO/zO7rhvypr8K6r1pUuOU+mwmOFNtndS29+4XcyqK4Ea6yLyCOTqeu/J8ie0W76f3xTqTWhHUWNxb7zl697fMTnovO4Jz6Vxrct87/Vx/ruVUFMGNdJF5BXN6Xx6r8ybxnqzHSM/XWwJvzE56LzuCc4X51XdCb0aOPxVFcCNdkCMLcyQYp2P5hrxRuK/aeq5tz0VL4M4iOPoMHtlF72NFauOOs+l896S2dko5FUVwI11k1skteIwrjatn4j28nd73TOIzW5XA1DymPvtydtB72BGcTefbK6eiCG4UFtaOXzwYo+O4I8/18iUz6zxXAGeLYG9mnmFlwn3pve36DwW9tx3B+XTOvXIqiuBGusi8gn46hvqL1yIt59z1C96CPos+k/67RgtgqQSWzpNL6ZjWexxJ7Vlm4k2vvyM433O+a9/H2vaenIoiuJEuspn0LHb00zHcnS/TZ2mJFkCL8pT6S5p3LJ6jFi96XY/o/OF8OueeORVFcKO4uOLC9lrg6BPGzGtuQmp/fTqFPld83tQzawFcXZ488nyW3HNbxEu4Vs+7rGWf3v1xPp3znsx+z05FEdxIF1nMzEJtCfro+I3GYl5Po8+XihZAyyLYOye9+6eiz/F8Fovzp7KaXs8yPeUS59M517Ssk5GcjCK4kS60UiwXN9rp2I3Eau5Ops/6jJYmqxK4I/ocPc8zs45W0+vtCO6g826Z1HcsfnYyiuBGuuBGUvtTd2ob2unYeeXGedPnDWOghamnOPUmNeZW0fvPPYvFPaTOsZpezzvhmXGH55zrOliZk1EEN9KF5hW00XGLqb2AattHcpPnc2tp0uIUYzXmVueJef6Hmj5H6XlWZBW9zo7gHjr3+p3Vn61yMorgRrrQSikt7tK2VFCnY7YzNwrPrYVppjT1fkdqed7n8+eSsN/zPmrPZHXP8TyrWN3nTHAPnXuvnIwiuJEuNK+gTsdsZ24Vnn2mCK4qKKPCsT331LNvS1bQa1ik97lxD537mbDO/qAIbqQLzSso0/GySO9LJ+Zmz3HoLYFW0Xmbpecfjd6X/pyLNT3/juAeOvc9af2OpHI6iuBGuthqKS3k1LbUZyEoaxnD1rQen9rvZjoWqfHxjBU9b29mx8GSntszcRxOcMpzeNB1kFoTK3I6iuBGuti8gjwdq525mY7FSFp/MdT2s6Tn7kntPltiSc/9TOu9tu6Xy5c9nx1t4nil1k3qM6ucjiK4kS62kLCYRxZ0zzHI07GaSW1OdDu/GP7QsVoVnQPNCnqN1tTutSVW9Lwai3ut5av0Ob7+PF50vFYkt25PRxHcSBdbaUHqz63bUkGajlNrese/JbfT8chlxdjHrKLXsUxtPKzoeXfka/T+NSirre2VOR1FcDNdcFYpfWnw03O8SmPXm5Fz4ef3omUcW/ZpiYd4Lat7bo0FPeeOfIneeynI07GaTc9373QUwc10wfWkZyE/g590jGppHfu4X+v++C01hh7xotctxfL5Leg5W2L5DCFfoPfcEqTpOFmntD5vQBHcqLT4SttKaTkOf2sdN49g/Us/F296fY/M0vPtyNvp/fYGP+18P9+AIriRLjjr5P4ahT9yY7Yj+E3HxSve9Pohq9ffLD3fjryZ3utI8JOOUU9mv1M3oAhuFBda70Lt3V+DP3RsLNI6P1rU8ZuOk1e86fVLaV1TtczQc61K7VnfSO9xNvhD14P+PJOWc92AIriRLrjeBTq6P37LjZ3+7BH8oWOTyoo58lZ7hrA9t0/u81pm6LlKab2/1v1i3kbvbzZxPPCHjpF3bkAR3ERfgPpzLaX9S9tC8JuOy8owJ+10bLziTa+/OmENjtJz6Xn1s1V5E7230XHIHYffdFw8cwuK4CZhkeVeADNpOSfsXi4t410L/qbj4xVPem2vjNLz7MhbhHux+N7Xgt90XHIJc2I9L7egCG4ysmBLCz33eSq30/HYGfykY+QVT3ptr4zQc/S8a0aj15j5a6YVvUeP3O65DnRNeOQWFMFNwiIrFbtVgf0LfWYO8ZOOkVc86bW9MkLP0ZLad6K2XbOL3odVWt/9t9Px8MxNKIKbxMXW8jKwzO10PDyjc400HTeveNJre6WXHr8r3vT68bur//TIzXQsPHMTiuAmuui8cjN9eevPK5O6FtJ0nLziSa/tlV7hmNa/XvWk53ye9NpvyK10HKzSuvZuQhHcQBecV24XxqD1JTCa1r8YoEzHa0V0jjzpvfRE77snPfRYy/Q8gwe9pnVqz1vbfiMdA4/EebgNRXATXYAzqb1EYm7WOka9GT0vynS8POLped3RNTSSHnrsjqyk1xqdh9HjenIjHYOV0Tm8DUVwE12Io9EFXPr8ZjoWrUmN42xQp2PmEU967dmEddqyVnvosbXUrl/bnsoKeg3vjIxDyG30+b1yI4rgJrr4PHKr8Oy1l+/s9lz0OLTRcVyZOEee9B5ao+upN630uB2x9DxvbQzj9liuW0v26txEn90irXN4I4rgBrrwvHIrHYedQRsdt9G0vvxDPOm1n+m559600uM0VvdYOo8FPefXcwt9bs/ciCK4gS680ZReoqncSMdgZ9Cud21bxJNee1V0HFvoOVoTr/Xr169/ott7MiueR5+/NaPHWUfv4xY6DjPRMcx9FnIriuAGpYW4MrfR598Z9AljtvI7kju3l9I9rEyLsN/MvcUiOFMGR+g5NDPP9KbcQJ/ZK7eiCG6gi88rt4nP3fsLoHf/lqCPjp9XvDyvGdbb7JprPb6FHtOTZwkcLYO99HhN69h4J3dfuc/jthvoc4+mNJap3IoiuIEuvpi4aHsXb2tuos9ukdF5QT8dw9bk5uj5eW6fEC963VJK99ubGt0/pPX6WgA1un8urfS4mJb7Dfu07qef1TJyTC65c51Mn7U2Fpa5FUVwg9aX0Gye17hNbhxSqW2fDfrpGK5KqiB6yN3D6tTo/q3R0peLHqdp5TlmKzL7O+BkcXz0mT1yK4rgBrr4PHKTXS+RVDBGxzGmZW5b9illNb3eSErPWNpWo/u3RMteLaXj9Nw9KT33W2J5j6fS50zFchyf57oVRdBZagFaLerS+W6iz26R1JjWgnGjY26RlfRaIaufs/UXnR7XGi1zpfz73//+J/p5rQSuHqOVWXHvJ9Nn9crNKILOdPG1ZvZlcgt97p3BOB3LXHq+F7V9WwvTDL1m6tpW0XOGn0tyx5WiZa6WWARTZVDP/fb0jJNVTqfP65mbUQQd6cJbkdzL6Qb6zKnx6P259nkumKdjOpra3KW2r6DXSOV5L6n7mkmJ7puK3psWuZZ4lUDrsQtZcc7W3EKf2ythbm9GEXQUF5wuQovUznsDfeZdgQ0d11V5FpH47yvodb1TovvG5N4rWuRakyqBIXr+k5Mb01Ruo8/vmZtRBJ3oovPO6fR5dwY2dFytor+IU4XEmt6DZ+LzluiYlKIlrifeRbDnuVYndy+pz2+UG4taRo5J5WYUQSdxsY0s2pFjNKfT501ldBx7joOdMO5x7GtzUNueS66MWNPrPjNy7yPH5Oh+tWiJm42ef1VSY5b6TGO1T0tupmPRm9q7Ivd5yO0ogg7iYiu9+EqLtLStNSfTZ7XKyLjDVutc1LbnUvpOWtHzPjN6370p0X1L0RLXk1V/DfQaw9G03t/tdDw8czuK4EK62EJ2vPhOps+6M7CnYxzSu/5LKX0frTzPaXnvPSnRfXPRAmcVvc7bU5vD2l+mNGhfg6tyO4rgAs8F1voyWJmT6bN65jm3WEPH3Dql76eFluusTkncp3Z/Wt6sotd5Y2pjMxr8oWPjGXywCOokhsQv6hvovb0hp4rPt+pF3ROso2Mds2LeLct96pwW6T1fie6bipY3y+i1dqR3PFtSOyf+0LFZHZ0bHFAE46Tq5MbPPOn19R5Lye2T+zyV1L6n0ufUpMYil559U8FaOt6rkloHo+LxubKTutaqlOi+qWh5s4peJ8RzXHYEP+kYWaZlPeGAItgby3N9IafS55xJy8uiFKz3nKfZ+erJiHh/pcITk3uW3Oe9+5TovqnzanmzTOp6pwZpOk615NZK7vNa8NtRRXB0MWiszhNiea6RnEif0SO5eYSP0hysTK9wTKrw7Lj3kJKwvXRf+hzWqV1/VTyuGa+BMh23FcnNd/gcv32yCKYmNn6W2pZKar/UZy3bdqTlfk7U8tyegR8d+5DV66GHFp1n4RlJ6dlK22JqdP9n9Bmso9frTcvz98T6fKjTMdsR/PapIhgmzvoLW0rLtUr7lLaVkjsu93kuJ9IxiD/r57X07p8KfD3H3mL+ctFz14R9tOhYFZ5a9F6fKSkdp8+wInrNryU1fuiTGkPP4I/PFUGPpBZo6rNUWvZr2Wc2J9Nn3RHsofNQSup7lvqslpLnflp2UoWndv3a9tbU6P7P6DOsiF7TMs8xjP9uNa6poF8Yt5Vz0hL88dkiuHsRhevvvodSTqbPuiPYQ+ehNTPf1RzdT8vO6sJTSo3uH6P3vyJ6zVRm5mvm+J7jME7HspSeOanl+R8G+OOzRdAyVgtt9jyzx8fcQJ/ZM9hL52N1UnSfmN7CY5n4/qjJvWe0sK2KXrcnuXv3CubpmLZmdO5Tx+FvFMHGPP9L4vlPz7Re82T6rKuTGnPslZoTi5TO+6TbnuktPKVrjqZG99docbOOXu8Nqc0D7OjY7gj+RhH8X2ovglJmjp1J6rqn0ue0TmosU8E76Lzk0jqvtbRec7TsWN5njR6TipY3q8TzWzyvxTlKwRo6zj2xmnP87fgi2LNwnvvm/r0no8fN5FT6nLuCd9B5qWX2u1g6Xrc9C8+K6PWeqdH9S9ESZ5F47tIz7A7W0bFuidVaiefBT8cXwZtysviMsy+FmePxLjo/q/IsMKXEtRX3n1lrMT3naKHH1KJFbjZ6/jcF6+mYW6b1u4Kfri6CrQsnlZ5jw749+4/kBiNjOHJMKngfnaMVGSkxVmuuNXEsWuixqej9a5kbjV4nda1UWvYZDXw9x37lvOaCtKuLYC4zC3Tm2JncQJ85lVXjj3daNd8hLUWmJ6vutdXM9XUsRqLnXJHnf3SXnhf+nnOk8+EVpH2mCOqEPtPyxdfU9tVzxhdM7bjWWJ0n5Bb63F7Bu+l8zUYLzEiRsfx+19JKj+tNeCYdk57o+XpiNZ7YR+cipnduW/ZP7YO8I4pgbQHottI+qf1TeW7L7Zf7fDSp891En72W1HjlktsX36FzV0puvrW8WBWZlWmlx41Gx6Uleo6Q3BzUMnIc9tM5sUjPWkDecUVwJD2LKZXZ42N6y+WNdDxWB9+i89eS+J3S8pKKHrsq8Z7CP3PvgpBWYV/rZ9CxKUWPDSk9l0XwHjo33kEZRbAxsy+tkeNrx9xIx2Bl8E06jy3R4pKLHpfLs8jptlRa93umR9i/9zla/sM0btNx6r2WZfA+OkfWKa3PEJRRBBsW0XO/1n1rmTnPzXQsnkmNaeqz1DbdD9+n852LFpdS9Nid6aHPsfJ5PK7xDN5P56wnvf9RpUHd54tgbnHkPv96bqfj0ZKRAo8z6LzmouUlFz0uta5Sn1mnhx4b43Gf4RqArgldJyuDus8XQe+0lgrdr+WYWvCbjoumNta57fFznEfnOjXvWvpy0eNLya213n2e6aHHegfQNdGbnu+H7os21xdBXTga6zJXSu78+JuOz2ye445z6bynoqUvFT3GM730eO8AuiY8gzafLYK50vTGzNwrftIxiukZ59S+uNdzPWjx0wKYWjutaT02t98IPUdvcvdSCxDouliV1DpFm08UQZ1cy8TFk1pEu4IyHa+Y1jlM7Qc86fpoia4r/XkmFvScqwPomvAM2l1fBEtJvchTn1kGbXTcZgKk6DqxSu87xJKee2UAXROz6fnuoN3ni2DPwsjF4hyzQR8dv5kAObpWcqm9Q2rbc1lh5n5aA+ia8A7afb4Iemf0BVo6Dv10DEcDtCh9f1dlpdXPAxtfHktdE95BO4rgxmCOjmdvgB66flrTW7o8zdyn5nk85j3H9WtKayP1s3XQ5xNFMNCJXpHVizMGNnRcc0nNKzBK15JldtB7mA3m6Zh+rQzq/XsHfT5TBEt0ETyTKgE7Ans6xq0BZumams1uej+tSb1fMUfH82tjW1obqc9WBH2OKIJPuiBa07pAdT/9+RmspePdEmC18E4ovRdC4vY30XscDcbpWGq+8JfB573q/c+k9Xzod1wRxF30JVAKgLrnL9zWX758z+bpOJbyVnqfoxlZdzHoRxHEp+lLIBcA7fT70xqM0XFM5VmO3krvOXXvq4N+FEF8mr4EUi8cAP30e1TLF/5nyzfScWzN2+j91ZJ6V88GYyiC+DR9EWgAzNHvVC7op2PYmzfRe2uNZSHEGIogPk9fBrwUAFv63UoFfXT8RvKWv8Lqfa1OrjxiDEUQn8fLAFhPv2d858bp+LXmrQVI72dHMI4iiM/jRQD4eP7ifeP/EzhfoAUmlVzhK2UXvQ/PxHF6y19Gv4oiCADoEn8Ro48WGevsEK47UlwtgzkUQQBAN34B99HyMpNS8fKk194VzKEIAgCwkBaXlfGk194RzKMIAgCwiBYXj3jQaz5T+ouldTCPIggAwAKxrIwUo5FjnllNr5fK7DPUAhsUQQAAjGlpGc2zTPUUq5X0Wqn03OtoYIMiCACAIS0sPbEsUKvE88/e68zxsEMRBADAiBaWVHIFaPSvf6VY0/PP3OfMsbBDEQQAwICWlbfEkp57R2CLIggAwCQtK7nM/BWsN/FaVlb8xfKZ1nPCFkUQAAADPaUmbq/t15vUecO/W9Br7QjsUQQBADCixeUtmaXna4l1yQ2BPYogAACGtLxYZ7RgzdBz7QjWoAgCAGBMS0zIaIFrif5Pwbo9ZpSeZ0ewBkUQAIAFniWmVM5S6d2/dKz+3w320vOtTup6WIciCADAIlpoUoUnVXxSn1nked5Weg7vhHvGOhRBAAAW0mLjmVqhrNH9VyV1n6N/wUQfiiAAAIulCo5lZs5ZovvOXGc0WIsiCADAYrHUeBSpcI3e66ToPvHc+pmmZZ9SRv7na4yjCAIA4EALT0tmS1VPVPis9fqt+/UG61EEAQBwokUnlVWlqiU997k68EERBADAkRaeUlaXwuf5V1+rN/BBEQQAwJmWnt15lsBfv3792O4d+KEIAgCwgZaf0bT8Ja+0j5bAmNJ+LSntX9oWAj8UQQAANmgtRb371ZI7z7ME5sqgR+CLIggAwCZagnZFC6B1GcyVz9Tn8EURBABgEy1BLUmVp1Ra9wvR8qfR/Z/puU5L4IsiCADARlqEvKOlLxc9rietZRH+KIIAAGymhcgqrQVMS18uPed8pvUY+KMIAgCwmRaiWlqLVU+09KWix1jeB/agCAIA8AJajCzSW9S0+Gl0/1R6rxmDPSiCAAC8hJajlmjx0p97o+XvWQJnz50L9qEIAgDwIlqSvKMFUP8SmCqDqc96gn0oggAAvMxssZpNrgTOJPdM2IsiCADAC2lh8sizrFkXwRAtg9iPIggAwEtpkapFi9bKWFwL+1EEAQB4MS1Pu9NaAGv74R0oggAAvJyWqFpqJewNwTtQBAEA+AAtUl8O3oMiCADAR2ihsoj3Xw/xLhRBAAA+JJQp7/LWktZ7wrtQBAEA+BgtV6kSlvpsd/A+FEEAAD5IS9bbg3eiCAIA8FFatnam9BdIvBdFEACAD9PSZZFSqWtJPD7+E+9FEQQA4ABaxryTK494N4ogAACH0BLWklSBS33Wsk2D96MIAgBwEC1jqfSUudHgGyiCAAAcRkuZJlUEU5+NBt9BEQQA4EBazlbmWSLxLRRBAAAOpYVtdfA9FEEAAA6mZW1V8E0UQQAALmD5fwMYg++jCAIAcBEtcyPBOSiCAABcrPUvhTgTRRAAAPyFAngPiiAAAMClKIIAAACXoggCAABciiIIAABwKYogAADApSiCAAAAl6IIAgAAXIoiCAAAcCmKIAAAwKUoggAAAJeiCAIAAFzq/wHlSO2HcDqtlAAAAABJRU5ErkJggg==