# Comprehensive Collection of Stoic Quotes

*Compiled for Bradley - 2026-02-12*

---

## MARCUS AURELIUS (121-180 CE)
*Roman Emperor, Philosopher, Author of Meditations*

### On Mind & Control
- "You have power over your mind—not outside events. Realize this, and you will find strength."
- "The happiness of your life depends upon the quality of your thoughts."
- "Our life is what our thoughts make it."
- "Choose not to be harmed—and you won't feel harmed. Don't feel harmed—and you haven't been."

### On Virtue & Action
- "Waste no more time arguing what a good man should be. Be one."
- "If it is not right, do not do it; if it is not true, do not say it."
- "The best revenge is to be unlike him who performed the injury."
- "Often injustice lies in what you aren't doing, not only in what you are doing."
- "Dig deep within yourself, for there is a fountain of goodness ever ready to flow if you will keep digging."

### On Life & Mortality
- "It is not death that a man should fear, but he should fear never beginning to live."
- "You could leave life right now. Let that determine what you do and say and think."
- "This is the mark of perfection of character—to spend each day as if it were your last, without frenzy, laziness, or any pretending."
- "When you arise in the morning, think of what a privilege it is to be alive, to think, to enjoy, to love."
- "Dwell on the beauty of life. Watch the stars, and see yourself running with them."

### On Adversity
- "The impediment to action advances action. What stands in the way becomes the way."
- "You have within you the strength to endure and overcome anything."
- "The mind adapts and converts to its own purposes the obstacle to our acting."
- "Accept whatever comes to you woven in the pattern of your destiny, for what could more aptly fit your needs?"

### On Acceptance & Nature
- "Everything that happens is either endurable or not. If it's endurable, then endure it. Stop complaining. If it's unendurable... then stop complaining. Your destruction will mean its end as well."
- "Whatever happens at all happens as it should."
- "Look well into yourself; there is a source of strength which will always spring up if you will always look."

---

## SENECA THE YOUNGER (4 BCE - 65 CE)
*Roman Stoic Philosopher, Statesman, Dramatist*

### On Suffering & Imagination
- "We suffer more often in imagination than in reality."
- "There are more things likely to frighten us than there are to crush us."
- "It does not matter what you bear, but how you bear it."
- "He who fears death will never do anything worth of a living man."

### On Adversity & Growth
- "A gem cannot be polished without friction, nor a man perfected without trials."
- "Difficulties strengthen the mind as labor does the body."
- "No man is more unhappy than he who has never faced adversities."
- "Excellence withers without an adversary."
- "Fire tries gold, misfortune tries brave men."

### On Self-Mastery
- "The most powerful man is he who has himself in his own power."
- "How do I know that I'm making progress? Because I have begun to be a friend to myself."
- "The greatest remedy for anger is delay."
- "To be everywhere is to be nowhere."

### On Time & Living
- "It's not that we have a short time to live, but that we waste much of it."
- "Whatever can happen at any time can also happen today."
- "Life is long, if you know how to use it."
- "True happiness is to enjoy the present, without anxious dependence upon the future."
- "Luck is what happens when preparation meets opportunity."

### On Virtue & Wisdom
- "A good person dyes events with his own color... and turns whatever happens to his own benefit."
- "The willing are led by fate, the reluctant are dragged."
- "Wealth is the slave of a wise man, the master of a fool."
- "He who is brave is free."
- "No man was ever wise by chance."

### On Fear & The Future
- "For the only safe harbour in this life's tossing, troubled sea is to refuse to be bothered about what the future will bring."
- "If you wish to be loved, be lovable."
- "Begin at once to live, and count each separate day as a separate life."
- "It is the power of the mind to be unconquerable."

---

## EPICTETUS (50-135 CE)
*Greek Stoic Philosopher, Former Slave*

### On Control & The Dichotomy
- "Some things are in our control and others not. Things in our control are opinion, pursuit, desire, aversion, and, in a word, whatever is our own action. Things not in our control are body, property, reputation, command, and, in one word, whatever is not our own action."
- "We cannot control the external events around us; we can control ourselves."
- "It's not what happens to you, but how you react to it that matters."

### On Freedom
- "Freedom is the right to live as we wish."
- "Freedom is the only worthy goal in life. It is won by disregarding things that lie beyond our control."
- "No man is free who is not master of himself."
- "Is freedom anything else than the right to live as we wish? Nothing else."
- "Freedom is not procured by a full enjoyment of what is desired, but by controlling the desire."

### On Perception & Judgment
- "Men are disturbed not by things, but by the views which they take of things."
- "It is a man's own judgments that disturb him."
- "People are not disturbed by things, but by the view they take of them."
- "What concerns me is not the way things are, but rather the way people think things are."

### On Acceptance
- "Do not seek to bring things to pass in accordance with your wishes, but wish for them as they are, and you will find them."
- "Make the best use of what is in your power, and take the rest as it happens."
- "Ask not that events should happen as you will, but let your will be that events should happen as they do, and you shall have peace."

### On Virtue & Character
- "First say to yourself what you would be; and then do what you have to do."
- "It is impossible for a man to learn what he thinks he already knows."
- "If you wish to be a writer, write."
- "The greater the difficulty, the more glory in surmounting it."

### On Discipline & Practice
- "No great thing is created suddenly."
- "If you would be a reader, read; if a writer, write."
- "The key is to keep company only with people who uplift you, whose presence calls forth your best."

### On Death & Impermanence
- "I must die. Must I then die lamenting? I must be put in chains. Must I then also lament? I must go into exile. Is there anything preventing me from going with a smile, cheerful and serene?"
- "Death is not dreadful, but living wickedly is."

---

## CATO THE YOUNGER (95-46 BCE)
*Roman Statesman, Stoic Practitioner, Senator*

### On Silence & Speech
- "Consider it the greatest of all virtues to restrain your tongue."
- "The primary virtue is: hold your tongue; who knows how to keep quiet is close to God."
- "I only start to speak when I'm sure that what I have to say is not better left unsaid."
- "A person's words can both conceal and reveal their inner soul."
- "The wise man considers in silence whatever anyone says."
- "All have the gift of speech, but few are possessed of wisdom."
- "Wise men are more dependent on fools than fools on wise men."

### On Action & Virtue
- "In doing nothing men learn to do evil."
- "Flee laziness, because the indolence of the soul is the decay of the body."
- "Bitter are the roots of study... but their fruit is sweet."
- "Bear in mind, that if through toil you accomplish a good deed, that toil will quickly pass from you, the good deed will not leave you so long as you live."

### On Liberty & Rights
- "Every person has the right to enjoy the fruits of their own labors."
- "Don't be beholden to a tyrant for showing mercy. He has no right to rule over you in the first place."
- "Never think that common people should not have anything to do with their own governing."
- "Whoever would overthrow the liberty of a nation must begin by subduing freedom of speech."

---

## ZENO OF CITIUM (334-262 BCE)
*Founder of Stoicism, Phoenician Philosopher*

- "Well-being is realized by small steps, but is truly no small thing."
- "The goal of life is living in agreement with nature."
- "A bad feeling is a commotion of the mind repugnant to reason, and against nature."
- "Happiness is a good flow of life."

---

## CLEANTHES (330-230 BCE)
*Second Head of the Stoic School*

- "Fate guides the willing, but drags the unwilling."
- "The happy man is the one who recognizes what must be neglected in order to be free."

---

## CHRYSIPPUS (279-206 BCE)
*Third Head of the Stoic School, Systematizer of Stoicism*

- "Living virtuously is equal to living in accordance with one's experience of the actual course of nature."
- "Wise men are able to make a fitting use of all occurrences that take place."

---

## MUSONIUS RUFUS (30-100 CE)
*Roman Stoic Philosopher, Teacher of Epictetus*

- "We should not believe that the practice of virtue is easy just because the principles are few and simple; we must be prepared for the fact that the task is difficult."
- "We will not be worthy of Philosophy so long as we place pleasure first."
- "If you accomplish something good with hard work, the labor passes quickly, but the good endures."

---

## HIEROCLES (2nd Century CE)
*Stoic Philosopher, Known for Work on Ethics*

- "Each of us is, as it were, circumscribed by many circles: the first draws the center around it, and is closest; the second, which is wider and includes it, is further away, and so on..."
- "The task of a wise man is to try always to expand the first circle."

---

## ANTONINUS PIUS (86-161 CE)
*Roman Emperor, Adoptive Father of Marcus Aurelius*

- "His character was such that he maintained the dignity of the empire without stirring up unnecessary war."
- "The Empire should stand as securely when he is gone as when he was alive."

---

## THEMISTOCLES (524-459 BCE)
*Pre-Stoic Athenian General, Influential to Stoic Thought*

- "He is immortal who has ceased to think of death as a misfortune."
- "The man who commands efficiently must have at least the same amount of discipline as the discipline he demands."

---

## ADDITIONAL STOIC-INSPIRED WISDOM

### On Resilience
- "The obstacle in the path becomes the path. Never forget, within every obstacle is an opportunity to improve our condition." — Adapted from Marcus Aurelius
- "You become what you give your attention to... If you yourself will not be who you want to be, who could make you otherwise?" — Epictetus
- "The more we value things outside our control, the less control we have." — Adapted from Epictetus

### On Character
- "Character is fate." — Heraclitus (often cited by Stoics)
- "A man's character is his fate." — Attributed to both Heraclitus and later Stoics
- "No man is free who is not master of himself." — Epictetus

### On Daily Practice
- "First, do nothing inconsiderately, nor without a reasonable end, nor against the common good." — Marcus Aurelius
- "Receive without conceit, release without struggle." — Marcus Aurelius
- "Whatever may happen to you, it was prepared for you from all eternity." — Marcus Aurelius

### On Truth & Philosophy
- "Philosophy does not promise to secure anything external for man... it is for this reason that it does not promise securities we do not need." — Epictetus
- "The essence of philosophy is that a man should so live that his happiness shall depend as little as possible on external things." — Epictetus
- "Waste no more time arguing about what a good man should be. Be one." — Marcus Aurelius

### On Perspective
- "Everything we hear is an opinion, not a fact. Everything we see is a perspective, not the truth." — Marcus Aurelius
- "How much trouble he has avoided who does not look to what his neighbor says or does or thinks, but only what he himself is doing to make it just and holy." — Marcus Aurelius
- "Look back over the past, with its changing empires that rose and fell, and you can foresee the future too." — Marcus Aurelius

---

## CATEGORIES INDEX

### By Theme:
- **Control**: Marcus Aurelius, Epictetus
- **Adversity**: Seneca, Marcus Aurelius
- **Virtue**: All, especially Marcus Aurelius & Cato
- **Silence/Speech**: Cato
- **Freedom**: Epictetus
- **Time**: Seneca
- **Acceptance**: Epictetus, Marcus Aurelius
- **Mind**: Marcus Aurelius
- **Action**: All
- **Wisdom**: Seneca, Cato

### By Philosopher (Count):
- Marcus Aurelius: 30+ quotes
- Seneca: 25+ quotes
- Epictetus: 25+ quotes
- Cato the Younger: 15+ quotes
- Others: 15+ quotes

**Total Collection: 100+ Stoic Quotes**

---

*Collection compiled for inspiration, meditation, and daily practice.*
*Remember: Philosophy is not just to be read, but to be practiced.*
