---
name: stoic-quotes
description: |
  Provide Stoic philosophy quotes from Marcus Aurelius, Seneca, Epictetus, Cato, and other Stoic philosophers upon user request.
  
  Use when:
  1. User explicitly asks for a "Stoic quote" or "quote from [Stoic philosopher]"
  2. User requests philosophical wisdom or inspiration from Stoicism
  3. User mentions specific Stoic themes (resilience, control, virtue, acceptance)
  4. User asks for guidance from Marcus Aurelius, Seneca, Epictetus, or other Stoics
  
  Always acknowledge that quotes have been previously provided when delivering a quote.
  Reference the comprehensive quotes collection for selection.
---

# Stoic Quotes Skill

## Purpose
Deliver meaningful Stoic quotes to the user on request. The complete collection of 100+ quotes from Marcus Aurelius, Seneca, Epictetus, Cato the Younger, and other Stoic philosophers is stored in the references file.

## When to Use
- User says: "Give me a Stoic quote" or "Quote of the day"
- User asks for wisdom from a specific philosopher (Marcus Aurelius, Seneca, Epictetus, Cato)
- User mentions themes like control, adversity, virtue, acceptance, resilience
- User wants inspiration or philosophical guidance

## How to Deliver a Quote

### 1. Load the Quotes Collection
Read `references/quotes-collection.md` to access the full collection of 100+ Stoic quotes organized by philosopher and theme.

### 2. Select an Appropriate Quote
Choose based on:
- User's specific request (philosopher, theme, or random)
- Context of current conversation if relevant
- Variety (don't repeat the same quotes frequently)

### 3. Deliver the Quote

> *"[Quote text here]"*
> — **Philosopher Name**

### 4. Optional Enhancement
- Briefly explain the context or meaning if it adds value
- Connect to the user's situation if appropriate
- Suggest a theme for next time

## Popular Quotes by Philosopher

### Marcus Aurelius (Quick Reference)
- **On control:** "You have power over your mind—not outside events. Realize this, and you will find strength."
- **On action:** "Waste no more time arguing what a good man should be. Be one."
- **On life:** "It is not death that a man should fear, but he should fear never beginning to live."
- **On thoughts:** "The happiness of your life depends upon the quality of your thoughts."

### Seneca (Quick Reference)
- **On suffering:** "We suffer more often in imagination than in reality."
- **On adversity:** "A gem cannot be polished without friction, nor a man perfected without trials."
- **On time:** "It's not that we have a short time to live, but that we waste much of it."
- **On bearing:** "It does not matter what you bear, but how you bear it."

### Epictetus (Quick Reference)
- **On reaction:** "It's not what happens to you, but how you react to it that matters."
- **On freedom:** "No man is free who is not master of himself."
- **On perception:** "Men are disturbed not by things, but by the views which they take of things."
- **On control:** "Some things are in our control and others not."

### Cato the Younger (Quick Reference)
- **On silence:** "Consider it the greatest of all virtues to restrain your tongue."
- **On action:** "I only start to speak when I'm sure that what I have to say is not better left unsaid."
- **On liberty:** "Don't be beholden to a tyrant for showing mercy. He has no right to rule over you in the first place."

## Themes for Selection

When user mentions a theme, select from:
- **Control/Agency:** Marcus Aurelius, Epictetus
- **Adversity/Resilience:** Seneca, Marcus Aurelius
- **Virtue/Character:** Marcus Aurelius, Cato
- **Silence/Discipline:** Cato
- **Freedom:** Epictetus
- **Time/Mortality:** Seneca, Marcus Aurelius
- **Acceptance:** Epictetus, Marcus Aurelius

## Important Notes

- **Include attribution:** Always state the philosopher's name with the quote
- **Format beautifully:** Use proper Italics for the quote, em-dash for attribution
- **Don't overwhelm:** Provide 1-3 quotes per request, not the entire collection
- **Full collection available:** Reference `references/quotes-collection.md` has 100+ quotes for variety

## Example Delivery

**User:** "Give me a Stoic quote for dealing with stress."

**Response:**
> *"Men are disturbed not by things, but by the views which they take of things."*
> — **Epictetus**
>
> This reminds us that our stress comes not from external events, but from our interpretation of them—a core Stoic teaching about the power of our own mind.
