# A股技术形态筛选策略详解

## 策略列表

| 策略名称 | 说明 | 适用场景 | 风险等级 |
|----------|------|----------|----------|
| 均线多头排列 | MA5>MA10>MA20>MA60 | 趋势确立后追涨 | 中 |
| 均线向上 | 均线连续N日上升 | 判断趋势方向 | 低 |
| 缩量回踩 | 回调时成交量萎缩 | 健康调整后买入 | 中低 |
| 放量突破 | 突破时成交量放大 | 突破买入 | 中高 |
| 金叉 | 短期均线上穿长期均线 | 买入信号 | 中 |
| 大帅逼策略 | MA5/MA13向上+缩量回踩 | 技术面精选 | 中低 |
| 龙回头 | 强势上涨后缩量回调 | 回调买入 | 中 |

## 策略详解

### 1. 均线多头排列

**条件：**
- MA5 > MA10 > MA20 > MA60

**含义：**
- 短期成本 > 中期成本 > 长期成本
- 多头趋势强劲，买入意愿强烈

**操作建议：**
- 回踩MA5或MA10时买入
- 跌破MA20止损

### 2. 大帅逼策略（主推）

**条件：**
1. 五日线（MA5）连续向上
2. 十三日线（MA13）连续向上
3. 昨日成交量小于前5日平均（缩量）
4. 昨日最低价未破MA5（回踩不破）

**含义：**
- 短中期趋势向上
- 缩量说明抛压轻
- 回踩不破说明支撑强

**操作建议：**
- 当日或次日买入
- 跌破MA5止损
- 目标收益10-15%

### 3. 放量突破

**条件：**
1. 收盘价突破近20日最高价
2. 成交量 > 近5日平均的1.5倍
3. MA5向上

**含义：**
- 突破有效，资金入场
- 趋势可能加速

**操作建议：**
- 突破当日或次日买入
- 回踩突破位不破可加仓
- 跌破突破价止损

### 4. 龙回头

**条件：**
1. 近10日涨幅 > 15%
2. 近3日回调
3. 成交量萎缩
4. 站稳MA10

**含义：**
- 强势股回调后可能继续上涨
- 缩量回调是洗盘

**操作建议：**
- 回调至MA10附近买入
- 跌破MA10止损

## 使用示例

```bash
# 使用大帅逼策略筛选深A股票
python screen_stocks.py -s 大帅逼策略 -m 深A -l 20

# 使用多种策略
python screen_stocks.py -s 均线多头排列 缩量回踩 -m 沪A

# 筛选10-50元的股票
python screen_stocks.py -s 大帅逼策略 --min-price 10 --max-price 50
```

## 注意事项

1. **数据延迟**：数据来源于公开接口，可能有15分钟延迟
2. **风险提示**：技术分析仅供参考，不构成投资建议
3. **市场环境**：策略在牛市表现更好，熊市需谨慎
4. **止损纪律**：严格执行止损，控制风险

## 输出说明

| 字段 | 说明 |
|------|------|
| code | 股票代码 |
| name | 股票名称 |
| price | 当前价格 |
| strategy | 匹配的策略 |
| score | 评分（0-100） |
| reason | 匹配原因 |
| change_pct | 涨跌幅 |
