---
name: stock-screener-cn
description: A股/港股技术形态筛选器。支持多种技术分析策略，包括均线多头排列、缩量回踩、放量突破、K线形态等。当用户询问股票筛选、技术形态、选股条件、均线策略时使用此技能。
---

# A股技术形态筛选器

专注于A股和港股的技术形态筛选，支持多种经典策略。

## 支持的筛选策略

### 1. 均线策略
- **均线多头排列**: MA5 > MA10 > MA20 > MA60
- **均线向上**: 均线连续N日上升
- **金叉/死叉**: 短期均线上穿/下穿长期均线
- **回踩不破**: 股价回踩均线后反弹

### 2. 量价策略
- **缩量回踩**: 股价回调时成交量萎缩
- **放量突破**: 成交量放大的同时突破关键位置
- **量价背离**: 价格与成交量走势不一致

### 3. 组合策略
- **大帅逼策略**: 五日线十三日线均向上 + 缩量回踩 + 未破五日线
- **龙回头**: 强势上涨后回调至关键均线 + 缩量企稳
- **老鸭头**: MA5上穿MA10形成鸭头形态

## 使用方式

用户可以通过自然语言描述筛选条件，例如：
- "帮我筛选均线多头排列的股票"
- "五日线十三日线均向上，昨日缩量回踩未破五日线"
- "找出放量突破的股票"

## 数据源

使用AKShare获取A股实时数据，支持：
- 深A、沪A全市场股票
- 港股通标的
- 实时行情和历史数据

## 输出格式

筛选结果将以表格形式展示：
- 股票代码和名称
- 匹配的策略名称
- 关键指标（均线位置、成交量变化等）
- 信号强度评分

## 快速使用

```bash
# 筛选满足"大帅逼策略"的股票
python scripts/screen_stocks.py -s 大帅逼策略 -m 深A

# 组合多个策略
python scripts/screen_stocks.py -s 均线多头排列 缩量回踩 -m 沪A -l 30
```

## 参数说明

| 参数 | 说明 | 默认值 |
|------|------|--------|
| -s, --strategy | 策略名称（可多选） | 大帅逼策略 |
| -m, --market | 市场：A股/深A/沪A/港股 | A股 |
| -l, --limit | 最大返回数量 | 30 |
| --min-price | 最低价格 | 3.0 |
| --max-price | 最高价格 | 300.0 |

## 详细策略说明

参见 [references/strategies.md](references/strategies.md)

## 依赖安装

```bash
pip install akshare pandas numpy
```

---

**风险提示**：技术分析仅供参考，不构成投资建议。股市有风险，投资需谨慎。
