# 股票查询 API 参考文档

## 数据源：腾讯财经实时行情 API

本技能使用腾讯财经免费公开的 HTTP 接口获取实时股票行情数据，无需 API Key，无需特殊 Header。

### 接口地址

```
https://qt.gtimg.cn/q={symbol}
```

### 请求要求

- **Method**: GET
- **编码**: GBK（响应需用 GBK 解码）
- **无需特殊 Header**，直接请求即可

### 股票代码格式

| 市场 | 前缀 | 示例 | 说明 |
|------|------|------|------|
| 沪市 A 股 | `sh` | `sh600519` | 上海证券交易所 |
| 深市 A 股 | `sz` | `sz300750` | 深圳证券交易所 |
| 港股 | `hk` | `hk00700` | 香港联交所 |
| 美股 | `us` | `usAAPL` | 纽约/纳斯达克 |

### 批量查询

支持一次查询多只股票，用逗号分隔：
```
https://qt.gtimg.cn/q=sh600519,sz300750,hk00700
```

### 返回数据格式

返回一行文本，字段以 `~` 分隔（各市场格式统一）。

#### 通用字段索引

| 索引 | 含义 | 说明 |
|------|------|------|
| [1]  | 股票名称 | 中文名称 |
| [2]  | 股票代码 | |
| [3]  | 当前价格 | |
| [4]  | 昨收盘价 | |
| [5]  | 今日开盘价 | |
| [6]  | 成交量 | A 股单位为手（1手=100股），港股/美股为股 |
| [30] | 行情时间 | 格式因市场而异 |
| [31] | 涨跌额 | |
| [32] | 涨跌幅(%) | |
| [33] | 最高价 | |
| [34] | 最低价 | |
| [37] | 成交额 | A 股单位为万元，港股/美股为当地货币 |

### 注意事项

1. **频率限制**：接口免费，但高频访问可能触发限流（HTTP 429），建议间隔 1 秒以上。
2. **交易时段**：
   - A 股：工作日 9:30-11:30, 13:00-15:00（北京时间）
   - 港股：工作日 9:30-12:00, 13:00-16:00（香港时间）
   - 美股：工作日 9:30-16:00（美东时间），即北京时间 22:30-5:00（夏令时 21:30-4:00）
3. **非交易时段**：返回最近一次交易的收盘数据。
4. **编码**：响应为 GBK 编码，解析时需用 `gbk` 解码。
5. **与新浪 API 的区别**：腾讯 API 无需设置 Referer Header，不会出现 403 问题，稳定性更好。
