---
name: stock-price-query
description: Query real-time stock prices for A-shares (Shanghai/Shenzhen), Hong Kong stocks, and US stocks. Use when the user asks about stock prices, market quotes, price changes, or mentions stock codes/names like 600519, AAPL, 00700, 贵州茅台, 腾讯, etc.
metadata:
  {
    "openclaw":
      {
        "emoji": "📈",
        "requires": { "bins": ["python3"] },
      },
  }
---

# Stock Price Query Skill

## Overview

实时股票价格查询技能，支持查询 A 股（沪深两市）、港股和美股的实时行情数据。通过调用免费公开的行情 API 获取数据，返回结构化的股票信息。

## When to Use

当用户的请求涉及以下场景时触发此技能：

- 用户询问某只股票的当前价格，例如："贵州茅台现在多少钱？"、"查一下苹果的股价"
- 用户想了解股票涨跌情况，例如："腾讯今天涨了还是跌了？"
- 用户提供股票代码查询，例如："600519 现在什么价？"、"AAPL price"
- 用户询问多只股票的价格对比，例如："帮我看看比亚迪和宁德时代的股价"
- 用户说 "查股票"、"股票行情"、"stock price" 等关键词

## How to Use

### 查询流程

1. **解析用户输入**：从用户消息中提取股票代码或股票名称。
2. **识别市场**：根据股票代码格式自动识别所属市场：
   - A 股沪市：以 `sh` 开头或 6 位数字以 6 开头（如 `sh600519`、`600519`）
   - A 股深市：以 `sz` 开头或 6 位数字以 0/3 开头（如 `sz000001`、`300750`）
   - 港股：以 `hk` 开头或纯数字 5 位及以下（如 `hk00700`、`00700`）
   - 美股：纯英文字母代码（如 `AAPL`、`TSLA`、`GOOGL`）
3. **执行查询脚本**：运行 `scripts/stock_query.py` 获取实时数据。
4. **格式化输出**：将结果以清晰友好的格式展示给用户。

### 脚本调用方式

```bash
python3 {{SKILL_DIR}}/scripts/stock_query.py <stock_code> [market]
```

**参数说明：**
- `stock_code`（必需）：股票代码，如 `600519`、`AAPL`、`00700`
- `market`（可选）：市场标识，可选值为 `sh`（沪市）、`sz`（深市）、`hk`（港股）、`us`（美股）。不提供时脚本会自动识别。

**输出格式**：JSON，包含以下字段：
```json
{
  "code": "600519",
  "name": "贵州茅台",
  "market": "sh",
  "current_price": 1688.00,
  "change": 12.50,
  "change_percent": 0.75,
  "open": 1680.00,
  "high": 1695.00,
  "low": 1675.00,
  "prev_close": 1675.50,
  "volume": 2345678,
  "amount": 3956789012.50,
  "time": "2026-02-24 15:00:00",
  "status": "success"
}
```

### 常见股票名称与代码映射

如果用户提供的是股票名称而非代码，先尝试匹配常见股票：

| 名称 | 代码 | 市场 |
|------|------|------|
| 贵州茅台 | 600519 | sh |
| 中国平安 | 601318 | sh |
| 比亚迪 | 002594 | sz |
| 宁德时代 | 300750 | sz |
| 腾讯控股 | 00700 | hk |
| 阿里巴巴 | 09988 | hk |
| 苹果/Apple | AAPL | us |
| 特斯拉/Tesla | TSLA | us |
| 英伟达/NVIDIA | NVDA | us |
| 微软/Microsoft | MSFT | us |

对于不在映射表中的股票名称，提示用户提供准确的股票代码。

### 输出格式要求

查询成功后，以如下紧凑格式展示结果（不要使用表格，避免消息过长导致飞书分页）：

```
📈 **{股票名称}**（{股票代码}.{市场}）

💰 当前价格：{current_price} 元/港元/美元 | 📊 涨跌幅：{change} ({change_percent}%) ↑/↓
📅 行情时间：{time}
📊 今开 {open} | 最高 {high} | 最低 {low} | 昨收 {prev_close}
📦 成交量：{volume} | 成交额：{amount}
```

涨跌幅为正时使用 ↑，为负时使用 ↓。成交额如果超过 1 亿，用"亿"为单位显示（保留两位小数）；超过 1 万不足 1 亿，用"万"为单位显示。

## Edge Cases

- **输入安全校验**：脚本在执行前会严格校验所有输入参数。`stock_code` 仅允许字母和数字（正则 `^[A-Za-z0-9]{1,10}$`），`market` 仅允许白名单值（`sh`/`sz`/`hk`/`us`）。任何包含特殊字符、shell 元字符或超长输入都会被拒绝，防止命令注入。
- **股票代码无效**：返回 "无法识别该股票代码，请确认后重试。支持 A 股（6 位数字）、港股（5 位数字）、美股（英文字母）。"
- **网络请求失败**：返回 "网络请求失败，请稍后重试。"
- **非交易时段**：正常返回最近的收盘数据，并提示 "当前为非交易时段，显示的是最近一次的收盘数据。"
- **股票名称模糊**：提示用户提供准确的股票代码以确保查询准确性。
- **API 限流**：如遇到限流，等待 1 秒后重试一次，仍失败则提示用户稍后再试。
