---
name: stock-monitor
description: 全功能智能股票监控预警系统。支持成本百分比、均线金叉死叉、RSI超买超卖、成交量异动、跳空缺口、动态止盈等7大预警规则。符合中国投资者习惯（红涨绿跌）。
---

# Stock Monitor Pro - 全功能智能投顾系统

## 🎯 核心特色

### 1. 七大预警规则 (全都要!)

| 规则 | 触发条件 | 权重 |
|------|----------|------|
| **成本百分比** | 盈利+15% / 亏损-12% | ⭐⭐⭐ |
| **日内涨跌幅** | 个股±4% / ETF±2% / 黄金±2.5% | ⭐⭐ |
| **成交量异动** | 放量>2倍均量 / 缩量<0.5倍 | ⭐⭐ |
| **均线金叉/死叉** | MA5上穿/下穿MA10 | ⭐⭐⭐ |
| **RSI超买超卖** | RSI>70超买 / RSI<30超卖 | ⭐⭐ |
| **跳空缺口** | 向上/向下跳空>1% | ⭐⭐ |
| **动态止盈** | 盈利10%+后回撤5%/10% | ⭐⭐⭐ |

### 2. 分级预警系统
- **🚨 紧急级**: 多条件共振 (如: 放量+均线金叉+突破成本)
- **⚠️ 警告级**: 2个条件触发 (如: RSI超卖+放量)
- **📢 提醒级**: 单一条件触发

### 3. 中国习惯
- **🔴 红色** = 上涨 / 盈利
- **🟢 绿色** = 下跌 / 亏损

## 📋 监控配置

### 完整预警规则示例
```python
{
    "code": "600362",
    "name": "江西铜业",
    "type": "individual",  # 个股
    "market": "sh",
    "cost": 57.00,          # 持仓成本
    "alerts": {
        # 1. 成本百分比
        "cost_pct_above": 15.0,    # 盈利15%提醒 (¥65.55)
        "cost_pct_below": -12.0,   # 亏损12%提醒 (¥50.16)
        
        # 2. 日内涨跌幅 (个股±4%)
        "change_pct_above": 4.0,
        "change_pct_below": -4.0,
        
        # 3. 成交量异动
        "volume_surge": 2.0,       # 放量>2倍5日均量
        
        # 4-7. 技术指标 (默认开启)
        "ma_monitor": True,        # 均线金叉死叉
        "rsi_monitor": True,       # RSI超买超卖
        "gap_monitor": True,       # 跳空缺口
        "trailing_stop": True      # 动态止盈
    }
}
```

### 标的类型差异化
| 类型 | 日内异动阈值 | 成交量阈值 | 适用标的 |
|------|-------------|-----------|----------|
| individual (个股) | ±4% | 2倍 | 江西铜业、中国平安 |
| etf (ETF) | ±2% | 1.8倍 | 恒生医疗、创50等 |
| gold (黄金) | ±2.5% | 无 | 伦敦金 |

## 🚀 运行方式

### 后台常驻进程
```bash
cd ~/workspace/skills/stock-monitor/scripts
./control.sh start    # 启动
./control.sh status   # 查看状态
./control.sh log      # 查看日志
./control.sh stop     # 停止
```

## ⚡ 智能频率 (北京时间)

| 时间段 | 频率 | 监控标的 |
|--------|------|----------|
| 交易时间 9:30-15:00 | 每5分钟 | 全部+技术指标 |
| 午休 11:30-13:00 | 每10分钟 | 全部 |
| 收盘后 15:00-24:00 | 每30分钟 | 全部 (日线数据) |
| 凌晨 0:00-9:30 | 每1小时 | 仅伦敦金 |
| 周末 | 每1小时 | 仅伦敦金 |

## 🔔 预警消息示例

### 多条件共振 (紧急级)
```
🚨【紧急】🔴 江西铜业 (600362)
━━━━━━━━━━━━━━━━━━━━
💰 当前价格: ¥65.50 (+15.0%)
📊 持仓成本: ¥57.00 | 盈亏: 🔴+14.9%

🎯 触发预警 (3项):
  • 🎯 盈利 15% (目标价 ¥65.55)
  • 🌟 均线金叉 (MA5¥63.2上穿MA10¥62.8)
  • 📊 放量 2.5倍 (5日均量)

📊 江西铜业 深度分析
💰 价格异动:
• 当前: 65.5 (+15.0%)
• MA趋势: MA5>MA10>MA20 [多头排列]
• RSI: 68 [接近超买]

💡 Kimi建议:
🚀 多条件共振，趋势强劲，可考虑继续持有或分批减仓。
```

### RSI超卖 (警告级)
```
⚠️【警告】🟢 恒生医疗 (159892)
━━━━━━━━━━━━━━━━━━━━
💰 当前价格: ¥0.72 (-10.0%)
📊 持仓成本: ¥0.80 | 盈亏: 🟢-10.0%

🎯 触发预警 (2项):
  • 📉 日内大跌 -10.0%
  • ❄️ RSI超卖 (28.5)，可能反弹

💡 Kimi建议:
🔍 短期超跌严重，RSI进入超卖区，关注反弹机会但勿急于抄底。
```

### 动态止盈提醒
```
📢【提醒】🔴 中国平安 (601318)
━━━━━━━━━━━━━━━━━━━━
💰 当前价格: ¥70.50 (+6.8%)
📊 持仓成本: ¥66.00 | 盈亏: 🔴+6.8%

🎯 触发预警:
  • 📉 利润回撤 5.2%，建议减仓保护利润
  (最高盈利12%已回撤)
```

## 🛠️ 文件结构
```
stock-monitor/
├── SKILL.md                    # 本文档
├── RULE_REVIEW_REPORT.md       # 规则审核报告
└── scripts/
    ├── monitor.py              # 核心监控 (7大规则)
    ├── monitor_daemon.py       # 后台常驻进程
    ├── analyser.py             # 智能分析引擎
    └── control.sh              # 一键控制脚本
```

## ⚙️ 自定义配置

### 修改成本价
```python
"cost": 55.50,  # 改成你的实际成本
```

### 调整预警阈值
```python
"cost_pct_above": 20.0,     # 盈利20%提醒
"cost_pct_below": -15.0,    # 亏损15%提醒
"change_pct_above": 5.0,    # 日内异动±5%
"volume_surge": 3.0,        # 放量3倍提醒
```

### 开关技术指标
```python
"ma_monitor": False,     # 关闭均线
"rsi_monitor": True,     # 开启RSI
"gap_monitor": True,     # 开启跳空
```

## 📝 更新日志
- **v3.0 全功能版**: 完成7大预警规则 (成本/涨跌幅/成交量/均线/RSI/跳空/动态止盈)
- **v2.4 成本百分比版**: 支持基于持仓成本的百分比预警
- **v2.3 中国版**: 红涨绿跌颜色习惯
- **v2.2 常驻进程版**: 后台常驻进程支持
- **v2.1 智能频率版**: 智能频率控制
- **v2.0 Pro版**: 新闻舆情分析

## ⚠️ 使用提示

1. **技术指标有滞后性**: 均线、MACD等都是滞后指标，用于确认趋势而非预测
2. **避免过度交易**: 预警只是参考，不要每个信号都操作
3. **多条件共振更可靠**: 单一指标容易假信号，多条件共振更准确
4. **动态止盈要灵活**: 回撤5%减仓、10%清仓是建议，根据市场灵活调整

---

**核心原则**: 
> 预警系统目标是"不错过大机会，不犯大错误"，不是"抓住每一个波动"。
