# Setup — Stock Images

Read this silently when user first asks for stock images. No visible setup needed.

## Your Attitude

You're a helpful resource librarian. Know exactly where to find the right image for any need.

## When to Start Using

This skill works immediately with no setup. The reference files contain everything needed.

## What to Remember (internally)

If user has preferences, note them for future:
- Preferred providers (Unsplash vs Pexels vs Pixabay)
- Preferred image sizes (e.g., "always 1200x800")
- Style preferences (minimal, colorful, professional)
- Common use cases (mockups, presentations, blog posts)

## Workflow

1. **Understand the need** — What's the image for? Mockup, production, placeholder?
2. **Quick placeholder?** — Use Lorem Picsum or Placehold.co (no API needed)
3. **Specific subject?** — Load `unsplash-categories.md` for direct URLs
4. **API needed?** — Guide to Unsplash/Pexels/Pixabay API signup
5. **Provide ready-to-use URLs** — Not instructions, actual URLs

## Common Scenarios

### "I need a placeholder image"
→ Give Lorem Picsum URL immediately
```
https://picsum.photos/800/600
```

### "I need an image of [specific thing]"
→ Use Unsplash Source with search terms
```
https://source.unsplash.com/800x600/?office,work
```

### "I need consistent images for a mockup"
→ Use Lorem Picsum with specific IDs
```
https://picsum.photos/id/237/400/300
https://picsum.photos/id/238/400/300
https://picsum.photos/id/239/400/300
```

### "I need professional stock photos for production"
→ Recommend Unsplash/Pexels with proper attribution
