# 技术指标参考手册

## 移动平均线

### close_50_sma - 50日简单移动平均线
- **类型**: 中期趋势
- **用途**: 识别趋势方向，作为动态支撑/阻力位
- **注意**: 价格滞后，需与更快指标结合

### close_200_sma - 200日简单移动平均线
- **类型**: 长期趋势
- **用途**: 确认整体趋势，识别金叉/死叉
- **注意**: 反应慢，适合战略性确认

### close_10_ema - 10日指数移动平均线
- **类型**: 短期趋势
- **用途**: 捕捉快速动量变化和入场点
- **注意**: 震荡市中噪音大，需长期均线过滤

## MACD 相关

### macd - MACD 值
- **计算**: EMA差值
- **用途**: 交叉信号和背离判断趋势变化
- **注意**: 低波动/横盘时需其他指标确认

### macds - MACD 信号线
- **计算**: MACD的EMA平滑
- **用途**: 与MACD线的交叉触发交易
- **注意**: 单独使用易产生假信号

### macdh - MACD 柱状图
- **计算**: MACD线与信号线之差
- **用途**: 可视化动量强度，提前发现背离
- **注意**: 波动大，需额外过滤

## 动量指标

### rsi - 相对强弱指数
- **阈值**: 70（超买）/ 30（超卖）
- **用途**: 判断超买超卖，观察背离
- **注意**: 强趋势中可能持续极值

## 波动率指标

### boll - 布林带中线
- **计算**: 20日SMA
- **用途**: 价格运动的动态基准
- **搭配**: 必须与上下轨一起使用

### boll_ub - 布林带上轨
- **计算**: 中线 + 2倍标准差
- **用途**: 超买信号和突破区域
- **注意**: 强趋势中价格可能沿带运行

### boll_lb - 布林带下轨
- **计算**: 中线 - 2倍标准差
- **用途**: 超卖信号
- **注意**: 需额外分析避免假反转

### atr - 平均真实波幅
- **用途**: 设置止损位、调整仓位大小
- **注意**: 反应性指标，属于风险管理工具

## 成交量指标

### vwma - 成交量加权移动平均线
- **用途**: 整合价量数据确认趋势
- **注意**: 成交量突增可能导致偏差

## 指标组合建议

### 趋势跟随策略
`close_50_sma` + `close_200_sma` + `macd` + `rsi` + `atr` + `vwma`

### 短线交易策略
`close_10_ema` + `macd` + `macdh` + `rsi` + `boll` + `boll_ub` + `boll_lb` + `vwma`

### 波动率策略
`atr` + `boll` + `boll_ub` + `boll_lb` + `rsi` + `close_10_ema` + `macd` + `vwma`
