---
name: stitch-ui-designer
version: 1.0.0
description: Design, preview, and generate UI code using Google Stitch (via MCP). Helps developers choose the best UI by generating previews first, allowing iteration, and then exporting code.
metadata:
  openclaw:
    emoji: 🎨
    requires:
      bins: ["npx", "mcporter"]
---

# Stitch UI Designer

This skill allows you to design high-quality user interfaces using Google Stitch.

## Workflow

Follow this process to help the user design a UI:

1.  **Setup (First Time Only)**
    -   Check if the `stitch` server is configured in `mcporter`.
    -   If not, configure it: `mcporter config add stitch --command "npx" --args "-y stitch-mcp-auto"`
    -   Ensure the user is authenticated with Google Cloud (the tool may prompt for `gcloud auth`).

2.  **Generate & Preview**
    -   Ask for a description of the interface (e.g., "Login screen for a crypto app").
    -   Use `stitch.generate_screen_from_text` with the prompt.
    -   **Important**: This returns a `screenId`.
    -   Immediately fetch the preview image using `stitch.fetch_screen_image(screenId)`.
    -   Show the image to the user. Do **not** fetch the code yet.

3.  **Iterate & Customize**
    -   Ask the user for feedback on the preview.
    -   If changes are needed, use `stitch.generate_screen_from_text` again (potentially using `stitch.extract_design_context` from the previous screen to maintain style) or just refine the prompt.
    -   Show the new preview.

4.  **Export Code**
    -   Once the user approves the design ("This looks great"), fetch the code.
    -   Use `stitch.fetch_screen_code(screenId)`.
    -   Present the HTML/CSS code or save it to a file as requested.

## Tools (via mcporter)

Call these using `mcporter call stitch.<tool_name> <args>`:

-   **generate_screen_from_text**
    -   Args: `prompt` (string), `projectId` (optional, usually auto-detected by `stitch-mcp-auto`)
    -   Returns: `screenId`, `name`, `url`
    -   *Use this to start a design.*

-   **fetch_screen_image**
    -   Args: `screenId` (string)
    -   Returns: Image data (display this to the user).
    -   *Use this to show the preview.*

-   **fetch_screen_code**
    -   Args: `screenId` (string)
    -   Returns: `html` (string), `css` (string), etc.
    -   *Use this ONLY after user approval.*

-   **create_project**
    -   Args: `name` (string)
    -   *Use if no project exists.*

## Tips

-   **Project Context**: `stitch-mcp-auto` tries to manage the project ID automatically. If you get errors about missing project IDs, ask the user to create or select a Google Cloud project first using `create_project` or by setting the `GOOGLE_CLOUD_PROJECT` env var.
-   **Preview First**: Always prioritize the visual preview. Generating code for a bad design wastes tokens and time.
-   **Stitch MCP Auto**: We use `stitch-mcp-auto` because it handles the complex Google auth setup more gracefully than the standard package.
