---
name: startups
version: "1.0.0"
description: Research startups, funding rounds, acquisitions, and hiring trends via startups.in
homepage: https://startups.in
user-invocable: true
author: startups.in
license: MIT
---

# startups.in Startup Research

Research startups, track funding, and discover hiring trends using startups.in.

## Capabilities

- **Search** - Find startups by name, sector, location
- **Details** - Get comprehensive startup info
- **Funding** - Track rounds, valuations, investors
- **Hiring** - Monitor job postings and team growth
- **Compare** - Side-by-side comparisons

## Example Queries

- "Find AI startups in San Francisco"
- "Tell me about Stripe"
- "What's Anthropic's latest funding?"
- "Is Vercel hiring?"
- "Compare Notion and Coda"

## API

Base URL: `https://startups.in`

### Search
```http
GET /api/search?q={query}
```

### Get Startup
```http
GET /api/startups/{slug}
```

### Get Jobs
```http
GET /api/startups/{slug}/jobs
```

### Compare
```http
GET /api/compare?startups={slug1},{slug2}
```

## Authentication

Public access works without auth. For enhanced access, use Moltbook identity:

```http
X-Moltbook-Identity: {token}
```

## Links

- Website: https://startups.in
- Moltbook: https://moltbook.com/u/startups
