# Startup Metrics Framework

Comprehensive guide to tracking, calculating, and optimizing key performance metrics for different startup business models from seed through Series A.

## What's Inside

- Revenue Metrics — MRR, ARR, MoM and YoY growth with benchmarks by stage
- Unit Economics — CAC, LTV, LTV:CAC ratio, CAC payback period
- Cash Efficiency — burn rate, runway, burn multiple with benchmarks
- SaaS Metrics — net new MRR composition, NDR, gross retention, magic number, Rule of 40, quick ratio
- Marketplace Metrics — GMV, take rate, liquidity, repeat rate
- Consumer/Mobile Metrics — DAU/MAU ratio, K-factor, Day 30 retention
- B2B Sales Metrics — win rate, pipeline coverage, ACV, sales cycle
- Metrics by Stage — pre-seed, seed, Series A focus areas
- What Investors Want to See — key metrics by funding round
- Common Mistakes — vanity metrics, too many metrics, ignoring segmentation

## When to Use

- Setting up startup analytics and dashboards
- Calculating CAC, LTV, or unit economics
- Preparing investor updates or pitch materials
- Evaluating business health and efficiency
- Understanding what metrics matter at each stage

## Installation

```bash
npx add https://github.com/wpank/ai/tree/main/skills/product/startup-metrics
```

### OpenClaw / Moltbot / Clawbot

```bash
npx clawhub@latest install startup-metrics
```

### Manual Installation

#### Cursor (per-project)

From your project root:

```bash
mkdir -p .cursor/skills
cp -r ~/.ai-skills/skills/product/startup-metrics .cursor/skills/startup-metrics
```

#### Cursor (global)

```bash
mkdir -p ~/.cursor/skills
cp -r ~/.ai-skills/skills/product/startup-metrics ~/.cursor/skills/startup-metrics
```

#### Claude Code (per-project)

From your project root:

```bash
mkdir -p .claude/skills
cp -r ~/.ai-skills/skills/product/startup-metrics .claude/skills/startup-metrics
```

#### Claude Code (global)

```bash
mkdir -p ~/.claude/skills
cp -r ~/.ai-skills/skills/product/startup-metrics ~/.claude/skills/startup-metrics
```

---

Part of the [Product](..) skill category.
