# 창업/사업자 플레이북

> 공통 Phase 구조: [`../common/playbook_base.md`](../common/playbook_base.md)

---

## Phase 1: 인텐트 분류 & 파라미터 확인

1. 사용자 요청을 [`references/intent_router.md`](references/intent_router.md)로 분류
2. **연계 스킬 위임 판단**:
   - Business Verify → company-info 스킬
   - Tax Setup → tax-guide 스킬 (VAT Guide / Withholding)
3. 필수 파라미터:
   - **License Check**: 업종명 (없으면 질문)
   - **Startup Cost**: 업종
   - **Sole vs Corp**: 연 매출 수준 (없으면 일반 비교 제공)

---

## Phase 2: 데이터 수집

### 2-1. 허가·신고 법령 → law-search 연계
```bash
bash skills/law-search/scripts/law_search.sh "[업종] 허가 신고" 5
bash skills/law-search/scripts/law_search.sh "[법령명]" 3
```

### 2-2. 창업 지원사업 → korean-gov-programs 연계
```bash
python3 skills/korean-gov-programs/scripts/collect_programs.py
```

### 2-3. 사업자 조회 → company-info 연계
```bash
bash skills/company-info/scripts/biz_status.sh "[사업자번호]"
```

### 2-4. 웹 검색 보강 (최신 공고·트렌드)
```
web_search: "K-스타트업 창업지원사업 2026 공고"
web_search: "소상공인진흥공단 2026 지원사업"
web_search: "[업종] 허가 신고 요건 2026"
```

---

## Phase 3: 핵심 레퍼런스

### 사업자 등록 절차 (홈택스 온라인)
1. 홈택스(hometax.go.kr) → 사업자등록신청
2. 필요 서류: 신분증, 임대차계약서, 업종별 허가증(해당 시)
3. 처리 기간: 1~3 영업일 (일반), 당일 가능

### 주요 업종별 허가·신고 요건

| 업종 | 구분 | 근거 법령 | 담당 기관 |
|------|------|---------|---------|
| 음식점 | 영업 신고 | 식품위생법 제37조 | 시·군·구청 위생과 |
| 카페/제과점 | 영업 신고 | 식품위생법 제37조 | 시·군·구청 위생과 |
| 숙박업 | 영업 신고 | 공중위생관리법 | 시·군·구청 |
| 의료기기 판매 | 신고 | 의료기기법 | 시·도 보건당국 |
| 화장품 판매 | 신고 | 화장품법 | 식약처 |
| 통신판매 | 신고 | 전자상거래법 | 공정거래위원회 |
| 부동산 중개 | 등록 | 공인중개사법 | 시·군·구청 |
| 건설업 | 등록 | 건설산업기본법 | 시·도 건축과 |
| 어린이집 | 인가 | 영유아보육법 | 시·군·구청 |
| 노래방 | 신고 | 음악산업진흥법 | 시·군·구청 |
| 학원 | 등록 | 학원법 | 교육청 |

### 법인세 vs 종합소득세 비교 (2025년)

**법인세율**
| 과세표준 | 세율 |
|---------|------|
| 2억원 이하 | 9% |
| 200억원 이하 | 19% |
| 3,000억원 이하 | 21% |
| 3,000억원 초과 | 24% |

**개인사업자 종합소득세율** → tax-guide 스킬 참조 (6~45%)

**분기점 계산 예시**
- 순이익 5,000만원: 법인세 9% vs 종합소득세 24% → 법인 유리
- 순이익 1,000만원: 법인(9%) vs 종합소득세(15%) → 법인설립비용 감안하면 개인 유리

### 주요 창업 지원 프로그램
| 기관 | 프로그램 | 금액 | 대상 |
|------|---------|------|------|
| 창업진흥원 | 예비창업패키지 | 최대 1억원 | 예비창업자 |
| 창업진흥원 | 초기창업패키지 | 최대 1억원 | 창업 3년 이내 |
| 창업진흥원 | TIPS | R&D 최대 5억원 | 기술 스타트업 |
| 소상공인진흥공단 | 성장기반자금 | 최대 7천만원 | 소상공인 |
| 중소기업진흥공단 | 창업기업지원자금 | 최대 1억원 | 창업 7년 이내 |
| 기술보증기금 | 창업기업 보증 | 보증 한도 내 | 창업 기업 |

---

## Phase 4: 출력

[`references/output_templates.md`](references/output_templates.md) 적용.

### 위임 안내 문구
```markdown
# Business Verify → company-info 위임
→ "사업자 번호 조회는 company-info 스킬이 담당해요.
   [사업자번호]로 조회할게요!"

# Tax Setup → tax-guide 위임
→ "창업 세금은 tax-guide 스킬이 더 자세해요.
   부가세(간이과세 vs 일반과세) 기준부터 설명해드릴게요!"
```

### 면책 문구 (모든 응답 필수)
> ⚠️ 본 내용은 정보 제공 목적이며, 법적·세무 조언이 아닙니다.
> 허가·신고 요건은 변경될 수 있으므로 관할 기관에 최종 확인하세요.
