# OpenClaw Optimizer: Context Compaction for Subagents

## Context Compaction Feature

### Key Capabilities
- Automatic token tracking across sessions
- Auto-summarization at 50,000 token threshold
- Preserves critical context and task intent
- Cost-effective summarization using Haiku model

### Usage Example

```javascript
const { SubagentContextCompactor } = require('./context-compaction');

// Initialize compactor
const compactor = new SubagentContextCompactor({
  tokenThreshold: 50000,
  summaryModel: 'claude-3-5-haiku'
});

// Before spawning subagent
const preparedContext = await compactor.prepareForSubagent(fullContext, sessionKey);
sessions_spawn({
  context: preparedContext,
  // other spawn parameters
});
```

### How It Works
1. Tracks token usage across main and subagent sessions
2. Detects when context approaches 50,000 tokens
3. Extracts and preserves critical information
4. Generates a concise summary using Haiku
5. Maintains session continuity

### Performance Impact
- Minimal overhead
- Reduces API costs by 70-90%
- Prevents runaway context growth

## Logging and Telemetry
Compaction events are logged with:
- Session Key
- Original Token Count
- Compacted Token Count
- Detected Key Themes

## Customization
- Adjust token threshold
- Modify critical information patterns
- Configure preservation of recent exchanges