---
name: "SSL"
version: "1.0.2"
description: "Set up HTTPS, manage TLS certificates, and debug secure connection issues."
---

## Triggers

Activate on: SSL certificate, HTTPS setup, Let's Encrypt, certbot, TLS configuration, certificate expired, mixed content, certificate chain error.

## Core Tasks

| Task | Tool/Method |
|------|-------------|
| Get free cert | `certbot`, acme.sh, Caddy (auto) |
| Check cert status | `openssl s_client -connect host:443` |
| View cert details | `openssl x509 -in cert.pem -text -noout` |
| Test config | ssllabs.com/ssltest or `testssl.sh` |
| Convert formats | See `formats.md` |

## Quick Cert Commands

```bash
# Let's Encrypt with certbot (most common)
certbot certonly --nginx -d example.com -d www.example.com

# Check expiry
echo | openssl s_client -connect example.com:443 2>/dev/null | openssl x509 -noout -dates

# Verify chain is complete
openssl s_client -connect example.com:443 -servername example.com
# Look for "Verify return code: 0 (ok)"
```

## Common Errors

| Error | Cause | Fix |
|-------|-------|-----|
| `certificate has expired` | Cert past valid date | Renew with certbot renew |
| `unable to verify` / `self signed` | Missing intermediate cert | Include full chain in config |
| `hostname mismatch` | Cert doesn't cover this domain | Get cert for correct domain or add SAN |
| `mixed content` | HTTP resources on HTTPS page | Change all URLs to HTTPS or use `//` |
| `ERR_CERT_AUTHORITY_INVALID` | Self-signed or untrusted CA | Use Let's Encrypt or install CA cert |

For detailed troubleshooting steps, see `troubleshooting.md`.

## Server Config Patterns

**Nginx:**
```nginx
server {
    listen 443 ssl http2;
    ssl_certificate /etc/letsencrypt/live/example.com/fullchain.pem;
    ssl_certificate_key /etc/letsencrypt/live/example.com/privkey.pem;
}
```

**Apache:**
```apache
SSLEngine on
SSLCertificateFile /path/to/cert.pem
SSLCertificateKeyFile /path/to/privkey.pem
SSLCertificateChainFile /path/to/chain.pem
```

For Node.js, Caddy, Traefik, and HAProxy, see `servers.md`.

## Renewal

Let's Encrypt certs expire in 90 days. Always automate:

```bash
# Test renewal
certbot renew --dry-run

# Cron (certbot usually adds this)
0 0 * * * certbot renew --quiet
```

## Certificate Types

| Type | Use case |
|------|----------|
| Single domain | One site (example.com) |
| Wildcard (*.domain.com) | All subdomains |
| Multi-domain (SAN) | Multiple different domains on one cert |
| Self-signed | Local dev only — browsers will warn |

## What This Doesn't Cover

- Application auth (JWT, OAuth) → see `oauth` skill
- SSH keys → see `linux` or server skills
- VPN/tunnel setup → see networking skills
- Firewall configuration → see server/infrastructure skills
