---
name: sports-ticker
version: 3.0.6
description: Live sports alerts for Soccer, NFL, NBA, NHL, MLB, F1 and more. Real-time scoring with FREE ESPN API. Track any team from any major league worldwide.
metadata: {"openclaw":{"requires":{"bins":["python3"],"note":"No API keys needed. Uses free ESPN API."}}}
---

# Sports Ticker

Track your favorite teams across **multiple sports** with **FREE live alerts**!

Supports: ⚽ Soccer • 🏈 NFL • 🏀 NBA • 🏒 NHL • ⚾ MLB • 🏎 F1

## First Run (Onboarding)

When no `config.json` exists, running the setup script launches an interactive wizard:

```bash
python3 scripts/setup.py
```

**The wizard asks:**
1. 📺 **Which sports?** — Pick from Soccer, NFL, NBA, NHL, MLB, F1
2. 🏆 **Which teams?** — Choose from popular teams or search for any team
3. 🔔 **Alert style?** — Live scores, final only, or daily digest
4. ⏰ **Game-day reminders?** — Get a heads-up 30 mins before kick-off
5. 🌙 **Quiet hours?** — Pause alerts while you sleep

After setup, your `config.json` is ready and you can start tracking!

**Re-run setup anytime:**
```bash
python3 scripts/setup.py --force  # Overwrites existing config
```

## Quick Start

```bash
# First time? Just run setup!
python3 scripts/setup.py  # Interactive wizard

# Find team IDs (any sport)
python3 scripts/setup.py find "Lakers" basketball
python3 scripts/setup.py find "Chiefs" football
python3 scripts/setup.py find "Barcelona" soccer

# Test
python3 scripts/ticker.py
```

## Config Example

```json
{
  "teams": [
    {
      "name": "Barcelona",
      "emoji": "🔵🔴",
      "sport": "soccer",
      "espn_id": "83",
      "espn_leagues": ["esp.1", "uefa.champions"]
    },
    {
      "name": "Lakers",
      "emoji": "🏀💜💛",
      "sport": "basketball",
      "espn_id": "13",
      "espn_leagues": ["nba"]
    }
  ]
}
```

## Commands

```bash
# Ticker for all teams
python3 scripts/ticker.py

# Live monitor (for cron)
python3 scripts/live_monitor.py

# League scoreboard
python3 scripts/ticker.py league nba basketball
python3 scripts/ticker.py league nfl football
python3 scripts/ticker.py league eng.1 soccer

# 📅 Schedule - View upcoming fixtures (NEW in v3!)
python3 scripts/schedule.py                    # All teams, next 14 days
python3 scripts/schedule.py --days 30          # Look further ahead
python3 scripts/schedule.py --team spurs       # Specific team
python3 scripts/schedule.py --compact          # One-liner format
python3 scripts/schedule.py --json             # JSON output

# 🤖 Auto Setup Crons - Generate match-day crons (NEW in v3!)
python3 scripts/auto_setup_crons.py            # All teams, next 7 days
python3 scripts/auto_setup_crons.py --team spurs --days 14
python3 scripts/auto_setup_crons.py --json     # Machine-readable
python3 scripts/auto_setup_crons.py --commands # OpenClaw CLI commands

# ESPN direct
python3 scripts/espn.py leagues
python3 scripts/espn.py scoreboard nba basketball
python3 scripts/espn.py search "Chiefs" football
```

## Alert Types

- 🏟 Game start (kick-off / tip-off)
- ⚽🏈🏀⚾ Scoring plays (goals, touchdowns, 3-pointers, home runs)
- 🟥 Red cards / Ejections
- ⏸ Halftime / Period breaks
- 🏁 Final results (WIN/LOSS/DRAW)

## ESPN API (Free!)

No key needed. Covers all major sports and 50+ leagues worldwide.

**Supported Sports:**
- Soccer: Premier League, La Liga, Champions League, MLS, and 30+ more
- Football: NFL
- Basketball: NBA, WNBA, NCAA
- Hockey: NHL
- Baseball: MLB
- Racing: Formula 1
