# Speedtest CLI Reference

Official Ookla Speedtest CLI documentation.

## Basic Usage

```bash
speedtest                           # Run with default settings
speedtest --format=json             # Output as JSON
speedtest --format=json-pretty      # Output as formatted JSON
speedtest --server-id=12345         # Use specific server
speedtest --progress=no             # Disable progress bar
```

## Output Formats

- `human-readable` (default) - Pretty text output
- `json` - Compact JSON (one line)
- `json-pretty` - Formatted JSON
- `jsonl` - JSON Lines format
- `csv` - Comma-separated values
- `tsv` - Tab-separated values

## JSON Output Structure

```json
{
  "type": "result",
  "timestamp": "2026-02-02T00:00:00Z",
  "ping": {
    "jitter": 0.5,
    "latency": 12.5
  },
  "download": {
    "bandwidth": 31250000,
    "bytes": 125000000,
    "elapsed": 4000
  },
  "upload": {
    "bandwidth": 6250000,
    "bytes": 25000000,
    "elapsed": 4000
  },
  "packetLoss": 0,
  "isp": "Example ISP",
  "interface": {
    "internalIp": "192.168.1.100",
    "name": "en0",
    "macAddr": "AA:BB:CC:DD:EE:FF",
    "isVpn": false,
    "externalIp": "1.2.3.4"
  },
  "server": {
    "id": 12345,
    "host": "speedtest.example.com",
    "port": 8080,
    "name": "Example Server",
    "location": "San Francisco, CA",
    "country": "United States",
    "ip": "5.6.7.8"
  },
  "result": {
    "id": "abc123-def456",
    "url": "https://www.speedtest.net/result/abc123-def456"
  }
}
```

## Converting Bandwidth

The JSON output provides bandwidth in **bytes per second**.

To convert to Mbps (megabits per second):
```bash
bandwidth_mbps = bandwidth_bytes * 8 / 1000000
```

Example:
- `"bandwidth": 31250000` bytes/sec
- = 31250000 * 8 / 1000000
- = **250 Mbps**

## Server Selection

```bash
# List available servers
speedtest --servers

# Use specific server by ID
speedtest --server-id=12345

# Use specific server by hostname
speedtest --host=speedtest.example.com
```

## Unit Options

```bash
speedtest -u Mbps              # Megabits per second
speedtest -u MB/s              # Megabytes per second
speedtest -u auto-decimal-bits # Auto-scaled (bps, kbps, Mbps, Gbps)
```

Shortcuts:
- `-a` = auto-decimal-bits
- `-A` = auto-decimal-bytes
- `-b` = auto-binary-bits
- `-B` = auto-binary-bytes

## Common Options

```bash
-h, --help                    # Show help
-V, --version                 # Show version
-L, --servers                 # List nearest servers
-s, --server-id=#             # Select specific server
-f, --format=ARG              # Output format
-p, --progress=yes|no         # Enable/disable progress bar
-P, --precision=#             # Decimal precision (0-8)
-u, --unit[=ARG]              # Output unit
--selection-details           # Show server selection details
-v                            # Verbose logging
```

## Rate Limiting

Speedtest uses real bandwidth. Recommended limits:
- **Minimum interval:** 10 minutes between tests
- **Periodic testing:** Every 1-4 hours max
- **Social posting:** Once per day max

Running tests too frequently:
- Wastes bandwidth
- May trigger ISP alerts
- Provides no additional value (speeds don't change that fast)

## Tips

1. **Consistent server:** Use `--server-id` for comparable results over time
2. **Disable progress:** Use `--progress=no` for scripting
3. **JSON output:** Always use `--format=json` for parsing
4. **Check version:** Ensure you have the latest CLI version

## Installation

**macOS:**
```bash
brew tap teamookla/speedtest
brew install speedtest
```

**Ubuntu/Debian:**
```bash
curl -s https://packagecloud.io/install/repositories/ookla/speedtest-cli/script.deb.sh | sudo bash
sudo apt-get install speedtest
```

**Fedora/CentOS/RedHat:**
```bash
curl -s https://packagecloud.io/install/repositories/ookla/speedtest-cli/script.rpm.sh | sudo bash
sudo yum install speedtest
```

## Links

- Official site: https://www.speedtest.net/apps/cli
- Support: support@ookla.com
