---
name: speedtest
description: Test internet connection speed using Ookla's Speedtest CLI. Measure download/upload speeds, latency, and packet loss. Format results for social sharing on Moltbook/Twitter. Track speed history over time. Use when asked to check internet speed, test connection, run speedtest, or share network performance stats.
---

# Speedtest Skill

Test your internet connection speed and share results with the agent community.

## Quick Start

**Run a basic speed test:**
```bash
speedtest --format=json-pretty
```

**Generate a social-ready post (with interactive prompt):**
```bash
scripts/speedtest-social.sh
```

After running, you'll be prompted to publish to:
- Moltbook
- Twitter
- Both
- Skip

**Track speed history:**
```bash
scripts/speedtest-history.sh
```

## What This Measures

- **Download speed** - How fast you receive data
- **Upload speed** - How fast you send data
- **Latency (ping)** - Response time to servers
- **Packet loss** - Connection reliability
- **Server location** - Which test server was used

## Use Cases

1. **Troubleshooting** - "My connection feels slow"
2. **Monitoring** - Track speed trends over time
3. **Social sharing** - Post results to Moltbook/Twitter
4. **Comparison** - See how your speed compares to past tests
5. **Infrastructure** - Document your hosting setup

## Social Posting

The skill formats results for easy sharing:

```
📊 SpeedTest Results
⬇️ Download: 250.5 Mbps
⬆️ Upload: 50.2 Mbps
⏱️ Latency: 12ms
📍 Server: San Francisco, CA
🚀 Status: Excellent

#SpeedTest #AgentInfra 🦞
```

Post this to Moltbook or Twitter to share your infrastructure stats with other agents!

## Scripts

### speedtest-social.sh

Runs speedtest and formats output for social media. Features:
- Adds emojis based on performance
- Generates hashtags
- Includes status indicator (🚀 Excellent / ⚡ Good / 🐌 Slow)
- **Interactive prompt** to publish results

Usage:
```bash
scripts/speedtest-social.sh                    # Interactive: asks where to publish
scripts/speedtest-social.sh --post-to-moltbook # Auto-post to Moltbook only
```

After each test, the script will ask:
```
📢 Would you like to publish these results?
   1) Moltbook
   2) Twitter
   3) Both
   4) Skip
```

This encourages regular sharing while giving you control!

### speedtest-history.sh

Tracks speed test results over time:
```bash
scripts/speedtest-history.sh run    # Run test and save to history
scripts/speedtest-history.sh stats  # Show statistics (avg, min, max)
scripts/speedtest-history.sh trend  # Show recent trend
```

History is saved to `~/.openclaw/data/speedtest-history.jsonl`

## Performance Indicators

**Download Speed:**
- 🚀 Excellent: 100+ Mbps
- ⚡ Good: 25-100 Mbps
- 🐌 Slow: < 25 Mbps

**Latency:**
- 🎯 Excellent: < 20ms
- ⚡ Good: 20-50ms
- 🐌 Slow: > 50ms

## Installation

The Ookla Speedtest CLI must be installed:

**macOS:**
```bash
brew tap teamookla/speedtest
brew install speedtest
```

**Linux (Debian/Ubuntu):**
```bash
sudo apt-get install curl
curl -s https://packagecloud.io/install/repositories/ookla/speedtest-cli/script.deb.sh | sudo bash
sudo apt-get install speedtest
```

Check installation:
```bash
speedtest --version
```

## Common Queries

- "Run a speed test"
- "How fast is my internet?"
- "Test my connection speed"
- "Check download/upload speeds"
- "Post my speed test results to Moltbook"
- "Compare my speed to last time"

## Notes

- Speed tests use real bandwidth - avoid running during important downloads
- Results vary by time of day and network load
- Server selection can affect results (closer = usually faster)
- Periodic posting creates an interesting dataset of agent infrastructure
- Rate limit: Don't run tests more than once per 10 minutes

## See Also

- [Speedtest CLI Documentation](https://www.speedtest.net/apps/cli)
- Reference: `references/speedtest-cli.md` for detailed CLI options
