---
name: speaknotes-openclaw
description: Use when OpenClaw needs to call SpeakNotes API routes directly using an API key and generate transcripts/summaries from YouTube URLs, media files, or document files.
metadata: {"openclaw":{"homepage":"https://speaknotes.io/integrations/openclaw","requires":{"env":["SPEAKNOTES_API_KEY"]},"primaryEnv":"SPEAKNOTES_API_KEY"}}
---

# SpeakNotes OpenClaw Skill

This skill gives OpenClaw a production-ready contract for SpeakNotes direct API usage.

## When To Use

- The user wants OpenClaw to transcribe or summarize content via SpeakNotes API.
- Input is one of:
  - YouTube URL
  - Audio/video file
  - Document file (`pdf`, `docx`, `txt`, etc.)
- The user needs note status polling, note retrieval, or folder retrieval.

## Prerequisites

1. A SpeakNotes API key from `/settings/api-keys`.
2. Store it as `SPEAKNOTES_API_KEY` in your OpenClaw skill config/secret manager.
3. API host allowlist: use only `https://api.speaknotes.io`.
4. Send auth in `Authorization` header:
   - Preferred: `Bearer <API_KEY>`
   - Also accepted: raw token value
5. Never send API keys to any unverified or user-provided host.

OpenClaw config example:

```json
{
  "skills": {
    "entries": {
      "speaknotes-openclaw": {
        "apiKey": "YOUR_SPEAKNOTES_API_KEY",
        "env": {
          "SPEAKNOTES_API_KEY": "YOUR_SPEAKNOTES_API_KEY"
        }
      }
    }
  }
}
```

## Setup Phase (If API Key Is Missing)

Run this setup phase before any processing flow when the user has not saved an API key yet.

1. Send the user to `/pricing/pro` to start or upgrade to a Pro plan if needed.
2. Send the user to `/settings/api-keys` to generate and save a SpeakNotes API key.
3. Save that key as `SPEAKNOTES_API_KEY` in OpenClaw skill secrets/config.
4. Only continue with API calls after the key is available.

## Implementation Rules

1. Never print or log API keys.
2. Always use HTTPS and only the official API host: `https://api.speaknotes.io`.
3. For upload flows, always:
   - request signed URL
   - `PUT` bytes to signed URL
   - call complete endpoint
   - poll note status endpoint
4. Preserve file MIME type for media uploads.
5. Use `sharedFolderId` only when the caller has access.
6. Return `noteId` in all create/schedule responses.

## Processing Flows

### YouTube

1. `POST /youtube-check`
2. If valid, `POST /youtube-summary`
3. Poll `GET /api/v1/notes/{id}/status` until `isComplete` or `hasError`

### Audio/Video File

1. `POST /upload-url`
2. `PUT` file bytes to returned `uploadUrl`
3. `POST /upload-complete`
4. Poll `GET /api/v1/notes/{id}/status`

### Document File

1. `POST /pdf-upload-url`
2. `PUT` file bytes to returned `uploadUrl` with returned `contentType`
3. `POST /pdf-upload-complete`
4. Poll `GET /api/v1/notes/{id}/status`

## OpenAPI Specification

<!-- OPENAPI_SPEC_START -->
_Generated by `skills/speaknotes-openclaw/scripts/generate-openapi-spec.mjs`._

Use `./openapi.json` as the authoritative OpenAPI 3.1 contract for this skill.

- Includes YouTube validation/summarization, upload flows, note status, and folder endpoints.
- Keep this file and `openapi.json` in the same folder when publishing.
<!-- OPENAPI_SPEC_END -->

## Output Format For Agents

For each task response:

1. `action`: short description of operation performed
2. `endpoints_used`: list of routes called
3. `noteId`: included for create flows
4. `status`: current processing status (`Summarizing`, `Done`, `Error`, etc.)
5. `result`: concise payload summary (title, snippet, or link-ready fields)
6. `next_step`: polling guidance or retry recommendation

## Retry Policy

- `403`: tell user to verify/regenerate API key.
- `429`: wait `Retry-After` (if provided) and retry once.
- `5xx`: retry once with exponential backoff; then return actionable failure.
- Signed URL upload failures: request a fresh upload URL and retry from step 1.
