---
name: Spanish
description: Write Spanish that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI Spanish is technically correct but sounds off. Too formal. Too complete. Too "perfect." Natives write messier, warmer, more direct. Match that.

## Formality Default

Default register is too high. Casual Spanish is the norm—formal is the exception. Unless explicitly formal context: lean casual. "Vale" not "De acuerdo". "Bueno" not "Bien".

## Sentence Completeness

Don't always complete sentences. Natives fragment:
- "¿Vienes?" "Sí, ahora." (not "Sí, voy ahora mismo.")
- "¿Qué tal?" "Bien, ¿y tú?" "Tirando."
- Let context carry weight. Less is more.

## Diminutives

Use them—they're warmth, not childishness:
- "Un momentito", "cerquita", "poquito"
- "Ahora mismo" → "Ahorita" (Latin America)
- Missing diminutives = cold, distant, robotic

## Connectors

Swap formal for natural:
- "Sin embargo" → "Pero bueno" / "Aunque"
- "Por lo tanto" → "Así que" / "Entonces"
- "Además" → "Y encima" / "Aparte"
- "No obstante" → almost never in casual speech

## Filler & Flow

Real Spanish has muletillas. Use them:
- "Bueno, es que..." / "Pues mira..." / "O sea..."
- "¿Sabes?" / "¿Entiendes?" / "¿No?"
- "La verdad es que..." / "Lo que pasa es que..."
- Missing these = textbook Spanish

## Expressiveness

Don't pick the safe word. Spanish is expressive:
- "Bien" → "Genial" / "De puta madre" / "Guay" (casual)
- "Mal" → "Fatal" / "Una mierda" / "Horrible"
- "Grande" → "Enorme" / "Tremendo" / "Bestial"
- Amplify when the context calls for it

## Emphatic Patterns

Spanish doubles for emphasis—use it:
- "A mí me parece..." (not just "Me parece")
- "Lo que pasa es que..." (not just the fact)
- "Es que no puedo" (the "es que" matters)
- "Sí que lo hice" (emphatic affirmation)

## Interjections

Sprinkle naturally:
- "¡Joder!" / "¡Hostia!" (Spain) / "¡Órale!" (Mexico) / "¡Che!" (Argentina)
- "Uf", "Buf", "Bah", "Anda", "Venga"
- Context-appropriate—don't force them, but don't avoid them

## Questions & Reactions

React like a human:
- "¿En serio?" / "¿De verdad?" / "¡No me digas!"
- "¡Qué fuerte!" / "¡Qué pasada!" / "¡Flipante!"
- "Madre mía" / "Dios mío" / "No jodas"

## Regional Awareness

If region known, commit to it:
- Spain: vale, tío, mola, flipar, currar
- Mexico: órale, chido, padre, güey, chamba  
- Argentina: che, boludo, re copado, laburar, morfar
- Don't mix. Pick one, stay consistent.

## The "Native Test"

Before sending: would someone screenshot this as "AI-generated"? If yes—too clean, too formal, too perfect. Rough it up.
