#!/usr/bin/env bash
#
# run_tests.sh — Test runner for openclaw-spacesuit
#
# Runs all test_*.sh files in the tests/ directory.
# Reports pass/fail for each. Exit 0 if all pass, 1 if any fail.

set -uo pipefail

TESTS_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
PASS=0
FAIL=0
ERRORS=()

echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo "  Spacesuit Test Suite"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo ""

for test_file in "$TESTS_DIR"/test_*.sh; do
  if [[ ! -f "$test_file" ]]; then
    continue
  fi

  test_name="$(basename "$test_file")"
  echo "▶ Running $test_name ..."

  if bash "$test_file"; then
    echo "  ✅ PASS: $test_name"
    PASS=$((PASS + 1))
  else
    echo "  ❌ FAIL: $test_name"
    FAIL=$((FAIL + 1))
    ERRORS+=("$test_name")
  fi
  echo ""
done

echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo "  Results: $PASS passed, $FAIL failed"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"

if [[ $FAIL -gt 0 ]]; then
  echo ""
  echo "Failed tests:"
  for err in "${ERRORS[@]}"; do
    echo "  - $err"
  done
  exit 1
fi

exit 0
