# TOOLS.md - Local Notes

Skills define *how* tools work. This file is for *your* specifics — the stuff that's unique to your setup.

---

## What Goes Here

Things like:
- Camera names and locations
- SSH hosts and aliases
- Preferred voices for TTS
- Speaker/room names
- Device nicknames
- API key locations and credential search order
- Project management tool configs (Linear, Jira, etc.)
- Chat platform channel IDs and mappings
- Anything environment-specific

## Why Separate?

Skills are shared. Your setup is yours. Keeping them apart means you can update skills without losing your notes, and share skills without leaking your infrastructure.

## 🔑 Credentials Search Order

When looking for API keys, tokens, or credentials:

1. **Workspace `.envrc`** — PRIMARY location for secrets (direnv auto-loads)
2. **Workspace `.env`** — Backup if .envrc doesn't exist
3. **Gateway config** — `openclaw gateway config get`
4. **Tool-specific config** — `~/.config/{tool}/`
5. **Environment variables** — `env | grep -i {keyword}`

**ALWAYS check .envrc first.** That's where secrets usually live.
