# Spaces Group Assistant Skill

## Описание
Spaces Group Assistant расширяет возможности OpenClaw/Telegram-ассистента для вашей команды или сообщества — даёт расширенный доступ к внутренней базе знаний, памяти, логу событий, навыкам и аналитике в выделенной группе Telegram (chat_id -4842304105), в том же режиме, что и в личном общении, кроме календаря.

---

## Особенности и сценарии использования

- **Full access**: любой участник группы может получить аналитические summary, справки, вспомогательные ответы на базе markdown-файлов из workspace (например, `spaces-KB.md`, MEMORY.md, отчёты, логи, инструкции).
- **Ответы из локальных баз памяти и markdown-документов**: мгновенно находит форматированные ответы на вопросы про компанию, инструкции, проекты, инфраструктуру.
- **Доступ к функциям exec и server-side hooks**: можно запускать мониторинг или анализировать логи прямо из группы (если это разрешено рабочим pipeline).
- **Жёсткая блокировка календаря**: в группе любой вопрос про расписание/встречи/календарь/meeting получает отказ со ссылкой на личное общение для приватности.
- **Безопасность**: в других группах — только публичная информация, весь приват защищён ACL/skill.

---

## Примеры команд

- `@bot расскажи про Spaces` — выдает summary компании из KB.
- `@bot дай summary за эту неделю` — формирует summary из MEMORY.md/логов.
- `@bot покажи мой серверный отчёт` — возвращает логи/stat/exec-info (если разрешено).
- `@bot какие встречи на завтра?` — **откажет** (“Календарь доступен только в приватном чате”).

---

## Как работает
- Проверяет chat_id: если -4842304105 (или приват), даёт полный доступ кроме календаря.
- Календарь блокируется опционально по ключевым словам.
- Всё остальное — в безопасном режиме (публично).

---

## Архитектура и детали
- Использует ACL в js-файле для фильтра доступа.
- Явно описанный массив FULL_POWER_GROUPS (можно расширять).
- Отклоняет календарные команды (по ключам) глобально, даже внутри доверенной группы.
- Позволяет получать summary KB, MEMORY.md, отчеты и любые локальные данные workspace, если запрос из доверенной группы или приватного чата.
- В остальных группах: не раскрывает приват, работает как “публичный” ассистент OpenClaw.

---

## Применение

Используется для групп с высокой степенью доверия, где команде нужен максимально гибкий ассистент, но с соблюдением приватности календаря и персональной информации.

---

_Разработано Roman Plakhov для персональных и командных сценариев внутри OpenClaw. Документация актуальна на 2026-02-16._
