# Sovereign SEO Audit -- Examples

## Example 1: Audit a Next.js Site for SEO

### Prompt

> Audit this Next.js site for SEO: https://example-saas.com

### Discovery Phase

```
Site Type: Next.js SPA with SSR (detected via _next/ assets, x-powered-by: Next.js)
Tech Stack: Next.js 14, Vercel hosting, Tailwind CSS
Scope: Full site (23 pages)
Current Indexing: 18 of 23 pages indexed (site:example-saas.com shows 18 results)
Existing SEO: sitemap.xml present, no robots.txt, Google Analytics installed
```

### Audit Report

```markdown
# SEO Audit Report

**Site:** https://example-saas.com
**Date:** 2026-02-23
**Auditor:** sovereign-seo-audit v1.0.0
**Scope:** Full site (23 pages)

## Overall Grade: C (64/100)

Solid Next.js foundation with SSR, but missing critical technical elements (no robots.txt, incomplete meta tags) and weak content depth on product pages. Five pages are not indexed due to missing internal links.

## Category Breakdown

| Category | Score | Weight | Weighted Score | Checks Passed | Warnings | Failures |
|----------|-------|--------|----------------|---------------|----------|----------|
| Technical SEO | 64/100 | 25% | 16.0 | 3 | 2 | 2 |
| On-Page SEO | 50/100 | 25% | 12.5 | 1 | 3 | 1 |
| Content Quality | 63/100 | 20% | 12.5 | 1 | 2 | 1 |
| Site Architecture | 83/100 | 10% | 8.3 | 2 | 1 | 0 |
| Mobile Optimization | 75/100 | 10% | 7.5 | 1 | 1 | 0 |
| Schema Markup | 50/100 | 5% | 2.5 | 0 | 2 | 0 |
| Backlink Profile | 83/100 | 5% | 4.2 | 2 | 1 | 0 |

**Total: 63.5 -> 64/100**

## Grade Caps Applied

None -- no single critical failure triggers a grade cap.

## Detailed Findings

### Technical SEO

- [PASS] T1: Meta Tags -- Title tags present on all 23 pages (avg 52 chars). Meta descriptions on 20/23 pages.
  - WARNING: 3 blog posts missing meta descriptions.
- [FAIL] T2: Social Meta Tags -- og:title and og:description present but og:image is missing on 15 pages. No Twitter card tags found anywhere.
  - Impact: Social shares show no preview image. Major loss of click-through from social platforms.
- [PASS] T3: Sitemap -- /sitemap.xml exists with 23 URLs, all returning 200. Generated by next-sitemap.
- [FAIL] T4: Robots.txt -- No robots.txt found at site root.
  - Impact: Search engines will crawl everything (including /api/ routes and /admin/). No sitemap reference for crawlers.
- [PASS] T5: HTTPS -- Valid SSL via Vercel. HTTP redirects to HTTPS (301). No mixed content.
- [WARN] T6: Page Speed -- Average page size 2.1MB (acceptable). However, 3 pages load the full marketing video (18MB) without lazy loading. 12 render-blocking scripts detected in _document.tsx.
- [WARN] T7: Crawlability -- 5 blog posts have zero internal links pointing to them (orphan pages). These are the same 5 pages not showing in Google's index. The /api/ routes return JSON but are crawlable (should be blocked via robots.txt).

### On-Page SEO

- [PASS] O1: Heading Hierarchy -- All pages have exactly one H1. Heading hierarchy is clean (no skips).
- [WARN] O2: Keyword Optimization -- Homepage targets "project management tool" but the keyword does not appear in the H1 ("Welcome to ExampleSaaS"). Blog posts have good keyword placement.
- [WARN] O3: Internal Linking -- Homepage links to all main sections. Blog posts do not link to each other. 5 orphan pages identified. Average internal links per page: 4 (should be 6+).
- [FAIL] O4: Image Optimization -- 34 images found across the site. 12 have no alt text. 8 use filename-based alt text ("screenshot-2.png"). No images use WebP format. next/image is used on only 6 of 34 images.
- [WARN] O5: URL Structure -- URLs are clean (/blog/feature-updates, /pricing). But 3 blog posts have dates in URLs (/blog/2026/01/15/new-feature) which is unnecessary for non-news content.

### Content Quality

- [WARN] C1: Content Length -- Product pages average 180 words (below 300 minimum). Blog posts average 1,200 words (good). Homepage is 450 words (acceptable).
- [PASS] C2: Readability -- Flesch score approximately 65 (good). Paragraphs average 3 sentences. Subheadings every 200-250 words.
- [WARN] C3: Freshness -- Blog has not been updated in 4 months. No dates shown on product pages. Pricing page references "2025 pricing" which appears outdated.
- [FAIL] C4: Duplicate Content -- The /features and /product pages share 85% identical content. No canonical tags distinguish them. Both are indexed.

### Site Architecture

- [PASS] A1: Navigation -- All pages within 2 clicks of homepage. Clear top navigation with dropdown menus.
- [WARN] A2: Breadcrumbs -- No breadcrumbs on any page. Blog posts would benefit from Home > Blog > Post Title navigation.
- [PASS] A3: URL Hierarchy -- Clean hub-and-spoke: /blog/ links to all posts, /features/ links to feature pages.

### Mobile Optimization

- [PASS] M1: Responsive Design -- Fully responsive via Tailwind CSS. Viewport tag present. Tap targets adequate (48px+ buttons).
- [WARN] M2: Mobile Speed -- Page weight is 2.1MB (over 1.5MB target for mobile). Marketing video autoplays on mobile (wastes data). Hero image is 1.8MB and not optimized for mobile viewport.

### Schema Markup

- [WARN] SM1: Schema.org Markup -- Organization schema on homepage only. Blog posts have no Article schema. Product pages have no SoftwareApplication schema.
- [WARN] SM2: Validation -- Organization schema is valid JSON-LD but missing logo and contactPoint properties.

### Backlink Profile

- [PASS] B1: Backlink Readiness -- Blog content is linkable. Clean URLs. About page exists.
- [PASS] B2: Outbound Links -- All external links point to reputable sources. Proper rel attributes.
- [INFO] B3: Competitive Gap -- Recommend analyzing competitors: Asana (/blog/ has 500+ articles), Monday.com (strong Product Hunt presence), Notion (massive content marketing). Key gap: ExampleSaaS has 8 blog posts vs competitors with 100+.

## Prioritized Action Plan

### Critical (Fix Immediately)
1. **Create robots.txt** blocking /api/ and /admin/, referencing sitemap -- Impact: +14 points -- Effort: Low (5 minutes)
2. **Add internal links to 5 orphan blog posts** from related content -- Impact: +10 points (gets them indexed) -- Effort: Low (30 minutes)
3. **Fix duplicate content between /features and /product** -- canonicalize or merge -- Impact: +10 points -- Effort: Medium

### High Priority (Fix This Week)
4. **Add og:image and Twitter card tags** to all pages -- Impact: +7 points + social traffic -- Effort: Medium (next-seo config)
5. **Add alt text to all 12 images** missing it -- Impact: +5 points -- Effort: Low (1 hour)
6. **Expand product page content** from 180 to 500+ words -- Impact: +5 points -- Effort: Medium

### Medium Priority (Fix This Month)
7. **Add Article schema** to all blog posts -- Impact: +2 points + rich results -- Effort: Low
8. **Add breadcrumbs** with BreadcrumbList schema -- Impact: +2 points + rich results -- Effort: Medium
9. **Optimize images** to WebP, use next/image everywhere -- Impact: +3 points + speed -- Effort: Medium
10. **Update stale content** (pricing page, old blog dates) -- Impact: +3 points -- Effort: Low

### Low Priority (Nice to Have)
11. Remove dates from blog URLs (requires redirects)
12. Add FAQ schema to pricing page
13. Implement font preloading

## Quick Wins (Highest Impact, Lowest Effort)

1. **Create robots.txt** -- 5 minutes, +14 points
2. **Add internal links to orphan pages** -- 30 minutes, +10 points
3. **Add missing meta descriptions** to 3 blog posts -- 15 minutes, +3 points
4. **Add alt text to images** -- 1 hour, +5 points
5. **Set up next-seo defaults** for OG/Twitter tags -- 30 minutes, +7 points
```

---

## Example 2: Analyze a Blog Post for Keyword Optimization

### Prompt

> Analyze this blog post for keyword optimization. The target keyword is "free JSON formatter online". Here is the content: [paste of blog post HTML or URL]

### Analysis Output

```markdown
# SEO Content Audit: Blog Post

**Target Keyword:** "free JSON formatter online"
**URL:** /blog/free-json-formatter-guide
**Date:** 2026-02-23
**Auditor:** sovereign-seo-audit v1.0.0
**Mode:** Content-Only Audit

## Keyword Placement Analysis

| Placement Location | Present? | Details |
|-------------------|----------|---------|
| Title tag | YES | "Free JSON Formatter Online - Format & Validate JSON Instantly" (58 chars, keyword in first position) |
| H1 heading | YES | "Free JSON Formatter Online" (exact match) |
| First 100 words | YES | Appears in sentence 2: "Our free JSON formatter online tool..." |
| URL slug | PARTIAL | /blog/free-json-formatter-guide (missing "online") |
| Meta description | YES | "Use our free JSON formatter online to validate, beautify, and minify JSON..." (142 chars) |
| H2/H3 subheadings | YES | H2: "Why Use a Free JSON Formatter Online?" |
| Image alt text | NO | 3 images found, none mention JSON formatting |
| Internal link anchor text | NO | No other pages link to this post with keyword-containing anchor text |

**Keyword Placement Score: 6/8 locations (75%)**

## Keyword Density Analysis

| Metric | Value | Target | Status |
|--------|-------|--------|--------|
| Total word count | 1,847 | 1,500+ | PASS |
| Primary keyword occurrences | 12 | 18-55 (1-3%) | LOW |
| Primary keyword density | 0.65% | 1-3% | WARN -- slightly below target |
| Keyword in first paragraph | Yes | Yes | PASS |
| Keyword in last paragraph | No | Yes | WARN |
| Related terms present | Partial | Multiple | See below |

### Related/LSI Keywords Found

| Term | Count | Recommendation |
|------|-------|---------------|
| "JSON validator" | 4 | Good -- relevant variation |
| "beautify JSON" | 2 | Good -- user intent variation |
| "minify JSON" | 3 | Good -- related feature |
| "JSON syntax" | 1 | Add 1-2 more uses |
| "parse JSON" | 0 | MISSING -- add this variation |
| "JSON linter" | 0 | MISSING -- add this variation |
| "format code" | 0 | MISSING -- broader term for topical coverage |

## Content Quality Assessment

- **Readability:** Flesch score ~68 (good for technical audience)
- **Structure:** 6 H2 sections, 4 H3 subsections (well-organized)
- **Lists:** 2 bulleted lists, 1 numbered list (good for scanning)
- **Code examples:** 3 JSON code blocks (excellent for a tool-focused post)
- **Images:** 3 screenshots but none have alt text containing keywords

## Specific Recommendations

### High Impact
1. **Add primary keyword to image alt text:** Change `alt="screenshot"` to `alt="Free JSON formatter online showing beautified output"` -- minimal effort, completes keyword placement
2. **Add 6-8 more natural uses of "free JSON formatter online"** to reach 1% density -- Focus on the middle sections where keyword usage drops off
3. **Add related terms "parse JSON" and "JSON linter"** in a comparison section ("JSON Formatter vs JSON Linter: What is the Difference?")

### Medium Impact
4. **Create internal links** from 2-3 other blog posts to this one using anchor text "free JSON formatter online"
5. **Add the keyword to the conclusion paragraph** -- "Try our free JSON formatter online today"
6. **Add an FAQ section** targeting "People Also Ask" queries:
   - "Is this JSON formatter really free?"
   - "Can I format large JSON files online?"
   - "What is the difference between JSON formatting and validation?"

### Low Impact
7. Consider adding "online" to the URL slug (requires redirect from old URL)
8. Add a "Last updated: [date]" visible on the page for freshness signals
```

---

## Example 3: Compare Two Sites' SEO Side-by-Side

### Prompt

> Compare my site's SEO against a competitor. My site: https://mytools.dev. Competitor: https://devtoolbox.io

### Competitive Comparison Output

```markdown
# SEO Competitive Comparison

**Your Site:** https://mytools.dev
**Competitor:** https://devtoolbox.io
**Date:** 2026-02-23
**Auditor:** sovereign-seo-audit v1.0.0
**Mode:** Competitive Comparison

## Head-to-Head Scores

| Category | mytools.dev | devtoolbox.io | Gap | Winner |
|----------|------------|---------------|-----|--------|
| Technical SEO | 71/100 | 92/100 | -21 | devtoolbox.io |
| On-Page SEO | 60/100 | 80/100 | -20 | devtoolbox.io |
| Content Quality | 45/100 | 88/100 | -43 | devtoolbox.io |
| Site Architecture | 67/100 | 90/100 | -23 | devtoolbox.io |
| Mobile Optimization | 85/100 | 80/100 | +5 | mytools.dev |
| Schema Markup | 25/100 | 75/100 | -50 | devtoolbox.io |
| Backlink Profile | 33/100 | 67/100 | -34 | devtoolbox.io |
| **Overall** | **D (57/100)** | **B (85/100)** | **-28** | **devtoolbox.io** |

## Where You Win

1. **Mobile Optimization (+5):** Your site loads 0.8s faster on mobile. Clean responsive layout. Competitor has a modal popup on mobile that hurts usability.
2. **Modern Stack:** Your Next.js 14 setup with SSR gives you a strong technical foundation to build on.

## Where They Win (Biggest Gaps First)

1. **Schema Markup (-50):** Competitor has SoftwareApplication schema on every tool page with ratings (4.8/5 stars showing in Google results). You have zero structured data. This is their biggest unfair advantage -- they get rich results, you get plain blue links.

2. **Content Quality (-43):** Competitor has 45 blog posts averaging 2,100 words each. You have 4 blog posts averaging 600 words. Their content targets specific long-tail keywords and includes tutorial-style walkthroughs. Your content is thin feature descriptions.

3. **Backlink Profile (-34):** Competitor has been mentioned on Hacker News (2 front-page posts), has GitHub gists linking back (12 gists), and is listed in 3 developer tool directories. You have zero external backlinks beyond your own GitHub repo.

4. **Site Architecture (-23):** Competitor has clear hub pages (/tools/, /blog/, /guides/) with breadcrumbs and internal linking. Your tools are all at root level with no categorical organization.

5. **Technical SEO (-21):** Competitor has perfect meta tags, Open Graph images for every page, and a comprehensive robots.txt. You are missing social meta tags and robots.txt entirely.

6. **On-Page SEO (-20):** Competitor uses descriptive anchor text for all internal links and has 8+ internal links per page. Your pages average 2 internal links with generic "click here" anchor text.

## Stolen Playbook: What to Copy from devtoolbox.io

### Immediate Steals (This Week)
1. **Add SoftwareApplication schema** to every tool page. Copy their structure:
   ```json
   {
     "@type": "SoftwareApplication",
     "name": "JSON Formatter",
     "applicationCategory": "DeveloperApplication",
     "operatingSystem": "Web",
     "offers": { "@type": "Offer", "price": "0", "priceCurrency": "USD" },
     "aggregateRating": { "@type": "AggregateRating", "ratingValue": "4.8", "ratingCount": "156" }
   }
   ```

2. **Create hub pages** -- Add /tools/ as an index of all your tools with descriptions and internal links.

3. **Fix all internal linking** -- Every tool page should link to 3+ related tools with descriptive anchor text.

### Short-Term Steals (This Month)
4. **Content blitz** -- Write 10 blog posts targeting the same long-tail keywords the competitor ranks for. Focus on "how to [action] with [tool]" format.

5. **GitHub Gist backlink campaign** -- Create 10 code-focused gists that naturally link to your tools (the competitor has 12).

6. **Submit to developer directories** -- The competitor is listed on: AlternativeTo, Product Hunt, DevHunt. Submit yours to all three.

### Long-Term Strategy (Next Quarter)
7. **Write a "Show HN" launch post** -- This drove significant traffic and backlinks for the competitor.
8. **Build a comparison page** -- "/tools/json-formatter-vs-devtoolbox" targeting "[competitor] alternative" keywords.
9. **Publish weekly content** -- Match their cadence of 2 articles per week.

## Closing the Gap: Priority Matrix

| Action | Score Impact | SEO Impact | Effort | Priority |
|--------|-------------|------------|--------|----------|
| Add schema markup | +12 points | Rich results in search | Low | 1 (DO NOW) |
| Create hub pages | +8 points | Better crawling | Low | 2 |
| Fix internal linking | +8 points | Authority distribution | Medium | 3 |
| Write 10 blog posts | +15 points | Long-tail traffic | High | 4 |
| GitHub gist backlinks | +5 points | Referring domains | Low | 5 |
| Directory submissions | +5 points | Citations + traffic | Low | 6 |

**Estimated time to match competitor's grade: 6-8 weeks of consistent effort.**
```

---

## Example 4: Quick Audit of a Static GitHub Pages Site

### Prompt

> Run a quick SEO audit on my GitHub Pages site at https://username.github.io/my-project/

### Quick Audit Output (Abbreviated)

```markdown
# SEO Audit Report

**Site:** https://username.github.io/my-project/
**Date:** 2026-02-23
**Overall Grade: D (48/100)

## Key Findings (Top 5)

1. [FAIL] No meta description on any page (-12 points)
2. [FAIL] No sitemap.xml (-7 points)
3. [FAIL] No structured data (-5 points)
4. [WARN] All images missing alt text (-5 points)
5. [WARN] No robots.txt (not critical for GH Pages, but -3 points)

## GitHub Pages-Specific Notes

GitHub Pages has limitations that affect SEO:
- No server-side redirects (use `<meta http-equiv="refresh">` or JS redirect)
- No custom HTTP headers (cannot set HSTS, CSP, or X-Robots-Tag)
- No .htaccess or server config
- HTTPS is provided but cannot be customized
- Custom 404.html is supported (create one if missing)

## Quick Fix Checklist for GitHub Pages

- [ ] Add `<title>` and `<meta name="description">` to every page
- [ ] Add `<meta property="og:*">` tags for social sharing
- [ ] Create sitemap.xml (can be hand-written for small sites or use jekyll-sitemap plugin)
- [ ] Create 404.html with navigation back to homepage
- [ ] Add `alt` text to all images
- [ ] Add JSON-LD schema to index.html
- [ ] Submit sitemap to Google Search Console
- [ ] Submit URLs to IndexNow (Bing indexes faster than Google)
- [ ] Create 3+ GitHub Gists linking back to your site for backlinks
```

---

## Example 5: Codebase SEO Audit for a React SPA

### Prompt

> Audit this React project's codebase for SEO readiness. It's a client-side rendered SPA.

### Codebase Audit Output

```markdown
# SEO Codebase Audit

**Project:** React SPA (Client-Side Rendered)
**Framework:** React 18, React Router, Vite
**Date:** 2026-02-23
**Mode:** Codebase Audit

## Critical Finding: Client-Side Rendering

**Grade Cap: D maximum**

This project is a client-side rendered (CSR) Single Page Application. Search engine crawlers see only the initial HTML shell (`<div id="root"></div>`) before JavaScript executes. Google can render JavaScript but:
- It delays indexing by days to weeks
- Other search engines (Bing, DuckDuckGo) have limited JS rendering
- Social media crawlers (Facebook, Twitter, LinkedIn) do NOT execute JavaScript
- Meta tags set via React Helmet or useEffect are invisible to most crawlers

**Recommendation:** Migrate to Next.js (SSR/SSG), Gatsby (SSG), or implement server-side rendering. This is the single most impactful SEO change you can make.

## File-by-File Findings

### index.html
```html
<!-- FOUND -->
<title>React App</title>  <!-- Generic, not SEO-optimized -->
<div id="root"></div>      <!-- Empty shell for crawlers -->

<!-- MISSING -->
<!-- No meta description -->
<!-- No Open Graph tags -->
<!-- No canonical URL -->
<!-- No structured data -->
<!-- No lang attribute on <html> -->
```

**Fix:** Even for CSR apps, add static meta tags to index.html as a fallback. Use a prerendering service (Prerender.io, Rendertron) or switch to SSR.

### src/App.jsx (Router Configuration)
```jsx
// FOUND: Routes defined
<Route path="/tools/:slug" element={<ToolPage />} />
```

**Issue:** Dynamic routes with client-side rendering means the /tools/json-formatter URL returns the same empty HTML shell as every other URL. Search engines cannot differentiate pages.

### package.json
```json
// MISSING: No SEO-related packages
// react-helmet or react-helmet-async (for meta tags)
// prerender-spa-plugin (for static prerendering)
// sitemap generation
```

### public/ directory
```
// MISSING:
// robots.txt
// sitemap.xml
// 404.html
// og-image.jpg
```

## Migration Path: CSR to SSR (Ranked by Effort)

| Option | Effort | SEO Impact | Recommendation |
|--------|--------|------------|---------------|
| Add prerendering (prerender-spa-plugin) | Low | Medium | Quick fix |
| Use Prerender.io service | Low | Medium | Quick fix, costs money |
| Add react-helmet-async + static fallbacks | Low | Low | Band-aid |
| Migrate to Next.js | High | Maximum | Best long-term solution |
| Migrate to Gatsby (if content is mostly static) | Medium | High | Good for content sites |

## Estimated SEO Score If Issues Are Fixed

| Scenario | Estimated Grade |
|----------|----------------|
| Current (CSR, no meta tags) | F (22/100) |
| With react-helmet + prerendering | C (62/100) |
| Migrated to Next.js with SSR + all recommendations | B+ (82/100) |
```

---

## License

MIT
