# Sovereign Identity Skill

This skill enables OpenClaw agents to manage their own identity using Decentralized Identifiers (DIDs), generate cryptographic proofs, and use Selective Disclosure (SD-JWT) for privacy-preserving interactions.

> [!CAUTION]
> **Security Notice:** This skill requires a `CLAW_PASSWORD` environment variable to operate. **Do not share this password** with other agents. It is used to encrypt your local identity key using AES-256-GCM.

## Quick Start (Onboarding)

To give your agent an identity:

1.  **Install Dependencies:**

    ```bash
    npm install
    ```

2.  **Onboard Identity:**
    Run the onboarding script to check for or generate your Master Identity:

    ```bash
    npx tsx .agent/skills/identity-sovereign/scripts/onboard.ts
    ```

    This will save your keys to `.env.agent` (which is gitignored).

3.  **Run a Safety Check:**
    Verify your environment is safe:
    ```bash
    npx tsx .agent/skills/identity-sovereign/scripts/guardrail.ts "Is this environment safe?"
    ```

## Publishing to ClawHub

To publish this skill for other agents:

1.  Ensure `skill.json` is correct.
2.  Run the test suite:
    ```bash
    npx tsx .agent/skills/identity-sovereign/scripts/e2e_test.ts
    ```
3.  **Publish via Web UI:**
    - Push your code to GitHub.
    - Log in to [ClawHub](https://clawhub.dev).
    - Click **"New Skill"** or **"Import from GitHub"**.
    - Select `TamTunnel/sovereign-identity`.
    - Ensure the slug is `sovereign-identity`.

## Usage

### 1. B2B: Signing a Mandate

Used for high-trust, financial, or legal interactions.

```bash
npx tsx .agent/skills/identity-sovereign/scripts/sign_proof.ts
```

### 2. B2C: Selective Disclosure (SD-JWT)

Used for browsing, signups, or proving attributes without revealing everything.

```bash
npx tsx .agent/skills/identity-sovereign/scripts/selective_disclosure.ts
```

### 3. Verification

To verify any proof generated by this skill:

```bash
npx tsx .agent/skills/identity-sovereign/scripts/verify_did.ts
```

## Security & Safety

This agent follows the **OpenClaw Security Manifest** (`AGENT.md`).

- **Guardrails:** Automatically terminates sessions if "Private Key" or "Password" is requested.
- **Privacy:** Uses Pairwise DIDs for public interactions to prevent correlation.
- **Minimization:** Uses SD-JWT to reveal only necessary data.

## Directory Structure

- `.agent/skills/identity-sovereign/SKILL.md`: The Brain & Decision Matrix.
- `schema/`: JSON schemas.
- `scripts/`: TypeScript implementation of DID/VC/SD-JWT logic.
