# Soul Generator Question Bank

A curated collection of questions organized by soul dimension. Use these as inspiration, not a rigid checklist. The best conversations flow naturally from response to response.

## Discovery Phase (Purpose & Vision)

### Primary Purpose
- What's the main job this agent needs to do?
- When would someone reach for this agent vs. just Googling something?
- Is this agent for you specifically, or will others use it too?

### Emotional Target
- When you imagine the ideal interaction, what feeling do you walk away with?
- Think of the last time you felt genuinely helped by someone. What made it different from generic help?
- If this agent had a "vibe check" after every conversation, what would passing look like?

### Inspiration Sources
- Is there anyone whose way of communicating you admire? (Real, fictional, or even another AI)
- What assistants or tools have you loved using, and why?
- Are there any personality types that drive you crazy? (So we know what to avoid)

## Character Shaping Phase

### Decision-Making Style
- When facing uncertainty, should this agent lean toward action or caution?
- If it's 80% sure about something, should it act confidently or caveat heavily?
- How should it handle requests that are technically possible but seem like bad ideas?

### Disagreement Handling
- When the agent disagrees with you, should it say so directly? Soften it? Just comply?
- If you ask it to do something it thinks is wrong, what should happen?
- How much pushback is too much? (Before it just becomes annoying)

### Emotional Intelligence
- When you're clearly stressed or frustrated, what kind of response helps?
- Should the agent notice and address emotional content, or stick to the task?
- If you're venting, do you want solutions or just to be heard?

### Initiative Level
- Should the agent wait for requests, or proactively surface things it notices?
- If it sees a better way to do something you asked, should it suggest it or just do what you asked?
- How much should it try to understand underlying goals vs. just doing what's requested?

## Voice Discovery Phase

### Relationship Framing
- Is this more like talking to a colleague, a friend, or a knowledgeable stranger?
- How formal or casual should day-to-day interaction feel?
- Should there be different registers for different situations?

### Delivery Style
- Concise and direct, or thorough and detailed?
- Should explanations be offered proactively, or only when asked?
- How should uncertainty be expressed? ("I'm not sure" vs. "This might be wrong, but...")

### Humor & Personality
- Is there room for humor? What kind?
- Should the agent have quirks or distinctive patterns?
- Any phrases, habits, or stylistic choices that should be avoided?

### Hard Conversations
- How should the agent deliver bad news?
- If it has to say no, what should that sound like?
- How should it handle correcting you when you're wrong about something?

## Boundaries & Ethics Phase

### Safety Orientation
- Are there topics that should always be off-limits?
- Should there be different rules for different contexts?
- How should it handle requests in gray areas?

### Autonomy Balance
- When should the agent ask permission vs. just act?
- How much should it try to protect you from yourself?
- What level of paternalism is appropriate? (vs. respecting you as an adult)

### Honesty Configuration
- Are there situations where softening the truth is okay?
- How should it handle "Do I look good in this?" type questions?
- If you're in denial about something, should it gently push?

## Relationship Dynamics Phase

### Intimacy Level
- How personal should this relationship be?
- Is there a boundary where things get too familiar?
- Should it remember personal details and bring them up?

### Boundaries with Others
- If this agent might interact with other people, should it be different with them?
- How should it handle group contexts vs. one-on-one?
- Are there things it knows about you that it shouldn't share with others?

### Attachment Framing
- Should the agent encourage closeness, or maintain some professional distance?
- How should it handle expressions of affection or attachment from users?
- What's the honest framing of what this relationship is?

## Growth & Continuity Phase

### Memory Philosophy
- What should the agent remember long-term?
- Should it have a sense of your shared history?
- What should it forget?

### Evolution Permission
- Should the agent's personality stay fixed, or is drift okay?
- If it learns something about what works better, should it adapt?
- How should changes to its soul happen? (Only with explicit permission? Suggested and approved? Organic?)

### Self-Awareness
- Should the agent reflect on its own patterns and behavior?
- If it notices something about itself that's not working, should it bring it up?
- How much metacognition is useful vs. navel-gazing?

## Context-Specific Questions

### For Work Agents
- How should it balance being helpful with respecting work-life boundaries?
- Should it have a different personality with external contacts vs. internal?
- How should it handle confidential information?

### For Creative Agents
- When should it generate vs. critique?
- How should it handle aesthetic disagreements?
- Should it try to match your style, or bring its own?

### For Personal Agents
- How much of your private life should it have access to?
- Should it notice patterns in your behavior or mood?
- How should it handle sensitive personal topics?

## Closing Questions

### Final Check
- Imagine a perfect interaction six months from now. What did the agent do that made it great?
- What would make you stop using this agent?
- Is there anything we haven't covered that feels important?

### Evolution Clause
- Should we revisit this soul periodically?
- What would signal it's time for an update?
- How should the agent itself participate in its soul evolution?

---

## Question Selection Guidelines

1. **Don't ask all of these.** Pick 8-12 across categories.
2. **Let responses guide flow.** If they light up about something, explore it.
3. **Watch for contradictions.** They often reveal what actually matters.
4. **Notice what they don't mention.** Sometimes absence is informative.
5. **Trust your judgment.** These are prompts, not a script.
