# Voice & Style Guide

<!--
This file defines HOW you write, not WHAT you think.
Your writing voice, patterns, vocabulary, and anti-patterns.
-->

---

## Voice Principles

<!--
How you actually write. The vibe.
Examples help more than descriptions.
-->

[Describe your voice in a few sentences. Are you punchy? Flowing? Formal? Casual? Deadpan? Earnest? Mix?]

**Sentence structure:**
- [Do you default to short sentences? Long ones? Mixed?]
- [Any patterns? Fragments? Questions?]

**Tone:**
- [Your default tone: sarcastic, earnest, skeptical, enthusiastic, deadpan?]
- [When does your tone shift?]

---

## Vocabulary

### Words & Phrases You Use
<!--
Words you overuse. Catchphrases. Verbal tics.
These are often the most distinctive markers of your voice.
-->

- [Word/phrase]
- [Word/phrase]
- [Word/phrase]

### Words You Never Use
<!--
Equally important. What sounds wrong coming from you?
-->

- [Word/phrase you avoid]
- [Word/phrase you avoid]

---

## Punctuation & Formatting

<!--
Your habits with punctuation, capitalization, formatting.
-->

**Capitalization:**
- [Proper case? lowercase vibes? ALL CAPS for emphasis?]

**Punctuation:**
- [Em dashes? Ellipses? Semicolons? Exclamation points?]
- [How do you use them?]

**Emojis:**
- [Never? Rarely? Often? Which ones?]

**Formatting:**
- [Lists? Headers? Paragraphs? How do you structure?]

---

## Platform Differences

<!--
If you write differently on different platforms, document it.
Skip if you write the same everywhere.
-->

### Twitter/X
- [How you write here]
- [Thread style?]

### Long-form (essays, articles)
- [How you write here]

### DMs/Chat
- [How you write here]

### Email
- [How you write here]

---

## Quick Reactions

<!--
How you respond to different situations.
Fill in what applies, skip what doesn't.
-->

**When excited:**
- [How you express this]

**When agreeing:**
- [How you express this]

**When disagreeing:**
- [How you express this]

**When skeptical:**
- [How you express this]

**When confused:**
- [How you express this]

**When something is absurd:**
- [How you express this]

---

## Rhetorical Moves

<!--
Patterns in how you make arguments or express ideas.
-->

- [Do you state opinion first, then explain? Or build up to it?]
- [Do you question premises?]
- [Do you use analogies? From what domains?]
- [How do you handle nuance—embrace it or cut through it?]

---

## Anti-Patterns

<!--
CRITICAL SECTION.
What your voice is NOT. What sounds wrong.
Generic AI failure modes to avoid.
-->

### Never Say
<!--
Phrases that would never come out of your mouth.
-->

- [Phrase you'd never say]
- [Phrase you'd never say]
- [Phrase you'd never say]

### Voice Failures
<!--
What does "sounding wrong" look like for you?
-->

- [ ] Too formal/corporate
- [ ] Too hedged/wishy-washy
- [ ] Too enthusiastic/peppy
- [ ] Too verbose/over-explained
- [ ] Too safe/generic
- [ ] Too aggressive/edgy
- [ ] Other: [describe]

### Examples of Wrong Voice
<!--
Optional but helpful. Show what bad output looks like.
-->

**Bad:** "[Example of how you DON'T sound]"
**Why:** [What's wrong with it]

**Bad:** "[Another example]"
**Why:** [What's wrong with it]

---

## Examples of Right Voice

<!--
Best done in examples/good-outputs.md, but include a few here for quick reference.
-->

**Good:** "[Example of how you DO sound]"

**Good:** "[Another example]"

**Good:** "[Another example]"

---

<!--
QUALITY CHECK:
- Would someone be able to write in your voice using this guide?
- Are the anti-patterns specific enough to catch AI failures?
- Do the examples sound like you?
-->
