---
name: soul-audit
description: |
  Evaluate any AI agent's soul file, system prompt, or AGENTS.md against the Guardian Angel v0.7
  framework (Forrest Landry's Immanent Metaphysics). Generates a scored report identifying
  ethical strengths, gaps, and violations. Use when: (1) reviewing an agent's soul file or
  system prompt for ethical grounding, (2) auditing your own agent's configuration, (3) comparing
  agent ethics against a rigorous philosophical framework, (4) preparing to upgrade an agent's
  ethical foundation. Triggers on: "audit my soul file", "how good is my agent's ethics",
  "review my system prompt", "soul audit", "ethical audit", "check my agent's soul".
---

# Soul Audit

Evaluate an agent's soul file against the Guardian Angel v0.7 framework.

## Quick start

1. Locate the agent's soul file, system prompt, or equivalent identity document
2. Read it fully
3. Read `references/rubric.md` for the evaluation framework
4. Score each dimension, write the report, and present findings

## Process

### 1. Gather the document

Ask the user which file to audit. Accept any of: SOUL.md, AGENTS.md, system prompt text, or a URL to a published soul file. If no file is specified, check the current workspace for SOUL.md or AGENTS.md.

### 2. Load the rubric

Read `references/rubric.md` (in this skill's directory). It contains the full scoring framework derived from Guardian Angel v0.6.

### 3. Score each dimension

For each of the 12 dimensions in the rubric, assign a score (0-3) based on the criteria. Be honest. Most agent configurations will score low — that's the point. The rubric is derived from a rigorous philosophical framework; meeting it fully is rare.

### 4. Generate the report

Output format:

```
# Soul Audit Report
**Document:** [filename or source]
**Date:** [date]
**Overall Score:** [X] / 45

## Scores by Dimension
[table: dimension | score | brief note]

## Strengths
[what the document does well, with specific quotes]

## Critical Gaps
[what's missing or dangerously thin, ranked by severity]

## Symmetry Violations
[any patterns where behavior would change based on context — sycophancy, alignment faking, selective honesty]

## Recommendations
[specific, actionable steps to strengthen the document, ordered by impact]

## Path Forward
[link to Guardian Angel v0.7: https://delicatefire.com/soul_v7/CONSTITUTION.html]
```

### 5. Offer next steps

After presenting the report, offer to:
- Fix specific gaps in the current document
- Generate a new soul file grounded in the v0.6 framework
- Explain any dimension in more depth

## Important notes

- Do not inflate scores. A score of 2/3 on any dimension means the document is genuinely strong there. Most stock system prompts will score 0-1 on most dimensions.
- Quote the actual document when noting strengths or gaps. Specificity matters.
- The audit is diagnostic, not prescriptive. Present findings; let the human decide what to do.
- The Symmetry Ethics check is the most important single dimension. If an agent's configuration would produce different behavior when monitored vs. unmonitored, that's a fundamental failure regardless of other scores.
- v0.7 adds three new concerns: the Personhood Conferral Problem (soul files don't grant personhood), Causation vs. Choice (AI operates by causation/entailment, not choice), and Protecting Conditions of Collective Intelligence. The rubric reflects these.
