"""Model classification utilities for SOTA Tracker."""

# Patterns indicating closed-source models
CLOSED_SOURCE_PATTERNS = [
    # OpenAI
    "gpt-", "gpt4", "gpt5", "chatgpt", "openai",
    "o1-", "o1_", "o3-", "o3_", "dall-e", "dall_e",
    # Anthropic
    "claude",
    # Google
    "gemini", "bard", "palm", "imagen", "veo",
    # xAI
    "grok",
    # Microsoft
    "copilot",
    # Other closed services
    "midjourney", "runway", "pika", "sora", "kling",
    "elevenlabs", "suno", "udio"
]


def is_open_source(model_name: str) -> bool:
    """
    Determine if a model is open-source based on name patterns.

    Args:
        model_name: Name of the model to check

    Returns:
        True if model appears to be open-source, False otherwise
    """
    name_lower = model_name.lower()
    return not any(pattern in name_lower for pattern in CLOSED_SOURCE_PATTERNS)
