"""
SOTA data fetchers.

Each fetcher pulls fresh data from external sources:
- HuggingFace: Open LLM Leaderboard, model info, trending
- LMArena: Chatbot Arena Elo rankings
- Artificial Analysis: Quality benchmarks (scraped, no API)
"""

from .huggingface import HuggingFaceFetcher
from .lmarena import LMArenaFetcher
from .artificial_analysis import ArtificialAnalysisFetcher

__all__ = ["HuggingFaceFetcher", "LMArenaFetcher", "ArtificialAnalysisFetcher"]
