"""Centralized constants for SOTA Tracker."""

from pathlib import Path

# =============================================================================
# PATHS
# =============================================================================

PROJECT_DIR = Path(__file__).parent
DATA_DIR = PROJECT_DIR / "data"
DB_PATH = DATA_DIR / "sota.db"
FORBIDDEN_PATH = DATA_DIR / "forbidden.json"
HARDWARE_PROFILES_PATH = DATA_DIR / "hardware_profiles.json"
VRAM_ESTIMATES_PATH = DATA_DIR / "vram_estimates.json"

# =============================================================================
# TIMEOUTS
# =============================================================================

# Database connection timeout (seconds)
DB_TIMEOUT_SECONDS = 30.0

# HTTP request timeout for API fetchers (seconds)
HTTP_TIMEOUT_SECONDS = 30

# Playwright browser timeout (milliseconds)
BROWSER_TIMEOUT_MS = 30000

# Wait for JavaScript to render (milliseconds)
JS_RENDER_WAIT_MS = 3000

# Network idle wait (milliseconds)
NETWORK_IDLE_WAIT_MS = 2000

# =============================================================================
# LIMITS
# =============================================================================

# Maximum models to fetch from leaderboards
MAX_LEADERBOARD_SIZE = 30

# Maximum models to fetch from arena endpoints
MAX_ARENA_SIZE = 20

# Maximum results from scrapers
MAX_SCRAPER_RESULTS = 50

# Maximum content size for regex processing (10MB - ReDoS protection)
MAX_CONTENT_SIZE_BYTES = 10 * 1024 * 1024

# Maximum days to look back for recent releases
MAX_DAYS_LOOKBACK = 365

# Default limit for trending models
DEFAULT_TRENDING_LIMIT = 10

# =============================================================================
# VALID CATEGORIES
# =============================================================================

VALID_CATEGORIES = [
    "image_gen",
    "image_edit",
    "video",
    "llm_local",
    "llm_api",
    "llm_coding",
    "tts",
    "stt",
    "music",
    "3d",
    "embeddings",
]
