# Skills vs MCP: Research & Recommendation for SOTA-MCP

## Executive Summary

**Recommendation: Keep SOTA-MCP as MCP, but add a companion Skill for enhanced usage**

SOTA-MCP should remain an MCP server because it provides *tools* (database queries, model lookup, freshness checks). However, a complementary Skill would teach Claude *how* to use those tools effectively.

---

## What Are Skills vs MCP?

| Aspect | Skills | MCP Servers |
|--------|--------|-------------|
| **Purpose** | Teach Claude *how* to do something | Provide tools and data sources |
| **Invocation** | Automatic (Claude detects relevance) | Manual tool calls |
| **Token Cost** | Low (loads on demand) | Higher (tool schemas always present) |
| **Best For** | Knowledge, patterns, best practices | External integrations, APIs, databases |
| **Example** | "Review PRs using our standards" | "Connect to PostgreSQL" |

**Key Insight**: Skills add intelligence; MCP adds capability.

---

## When to Use Each

### Use MCP When You Need:
- External system connections (databases, APIs, services)
- Real-time data access
- Tool-based operations
- Actions that modify state

**SOTA-MCP is correctly an MCP because it:**
- Provides tools (`query_sota`, `check_freshness`, `get_forbidden`, etc.)
- Queries a database
- Returns structured data
- Performs lookups and comparisons

### Use Skills When You Want:
- Standardized behavior without explicit prompts
- Domain expertise embedded in Claude's reasoning
- Context-aware automatic activation
- Best practices for using tools

---

## Recommendation for SOTA-MCP

### Keep MCP Server For:
1. `query_sota(category)` - Database query tool
2. `check_freshness(model)` - Model validation tool
3. `get_forbidden()` - Forbidden list tool
4. `query_sota_for_hardware(category, workload)` - Hardware-aware filtering
5. `get_model_recommendation(task)` - Recommendation engine
6. `configure_hardware()` - Profile management

### Add Companion Skill For:
Teaching Claude WHEN and HOW to use these tools effectively.

**Example: `~/.claude/skills/sota-model-advisor/SKILL.md`**

```yaml
---
name: sota-model-advisor
description: Ensures Claude recommends current SOTA AI models. Use when discussing image generation, video generation, local LLMs, text-to-speech, or any AI model recommendations.
---

# SOTA Model Advisor

## Mandatory Protocol

Before suggesting ANY AI model, you MUST:

1. **Check SOTA first**: Call `query_sota(category)` to get current SOTA models
   - Categories: `image_gen`, `image_edit`, `video`, `video2audio`, `llm_local`, `llm_api`, `llm_coding`, `tts`, `stt`, `music`, `3d`, `embeddings`

2. **Verify freshness**: Call `check_freshness(model_name)` before suggesting any specific model

3. **Check forbidden list**: Call `get_forbidden()` to see blacklisted models

4. **For local deployment**: Use `query_sota_for_hardware(category, concurrent_workload)` to filter by VRAM

## Hardware Context (January 2026)

User has RTX 5090 (32GB VRAM), prefers uncensored models, local-first.

Common concurrent workloads:
- `image_gen`: ~24GB (FLUX.2-dev, Qwen-Image)
- `video_gen`: ~24GB (HunyuanVideo, Wan 2.6)
- `none`: Full 32GB available

## Why This Matters

Training data is months old. Models like Redux, BAGEL, FLUX.1-dev are outdated but appear in training data. Always verify with SOTA tools.

## Quick Reference (January 2026)

- **Image gen**: Qwen-Image-2512, Z-Image-Turbo, FLUX.2-dev
- **Video**: LTX-2, Wan 2.6, HunyuanVideo 1.5
- **Local LLM**: Qwen 3-32B, Qwen 3-8B (JOSIEFIED for uncensored)
- **FORBIDDEN**: FLUX.1-dev, Redux, BAGEL, SD 1.5/2.0/XL
```

---

## Benefits of Dual Approach

| MCP Only | MCP + Skill |
|----------|-------------|
| Tools available but Claude may forget to use them | Claude automatically checks SOTA before recommending |
| User must prompt "check SOTA first" | Automatic activation when discussing AI models |
| No personalization context | User preferences (uncensored, VRAM) built-in |
| Generic tool usage | Best practices enforced |

---

## Token Efficiency

**MCP alone**: ~5,000 tokens for tool schemas (always loaded)

**Skill alone**: ~200 tokens (name + description until activated)

**Combined**: MCP provides tools, Skill loaded only when relevant (~500 tokens when active)

---

## Implementation Steps

1. **Keep SOTA-MCP as-is** (done)
2. **Create companion Skill**:
   ```bash
   mkdir -p ~/.claude/skills/sota-model-advisor
   # Copy SKILL.md content above
   ```
3. **Test**: Ask Claude about image generation models - should trigger Skill + use MCP tools

---

## Sources

- [Claude Skills Documentation](https://code.claude.com/docs/en/skills)
- [Claude Skills vs MCP - IntuitionLabs](https://intuitionlabs.ai/articles/claude-skills-vs-mcp)
- [Skills vs MCP - Armin Ronacher](https://lucumr.pocoo.org/2025/12/13/skills-vs-mcp/)
- [Simon Willison on Skills](https://simonwillison.net/2025/Oct/16/claude-skills/)

---

## Conclusion

**MCP and Skills are complementary, not competing.**

- MCP = the tools (WHAT Claude can do)
- Skills = the expertise (HOW Claude uses those tools)

For SOTA-MCP: Keep the MCP server for tool functionality, add a Skill to ensure Claude uses those tools correctly and automatically.
