# SOTA Tracker MCP - Evaluation Report

**Date:** January 11, 2026
**Evaluator:** Claude Opus 4.5

## Executive Summary

**Problem:** AI models become obsolete in 3-12 months; LLM training data is stale, causing Claude to suggest outdated models like FLUX.1-dev, Llama 2, or SD XL.

**Solution:** An MCP server that intercepts model recommendations with real-time SOTA data scraped from LMArena, Artificial Analysis, and HuggingFace, filtered by user's actual GPU VRAM.

**Verdict:** Genuinely valuable. Fills a gap no other MCP addresses. Worth maintaining and sharing publicly.

---

## 1. Problem Validation ✅

### Model Obsolescence is Real and Fast

| Model | SOTA Status | Superseded By | Time to Obsolescence |
|-------|-------------|---------------|---------------------|
| FLUX.1-dev | Forbidden | FLUX.2-dev | ~12 months |
| Stable Diffusion XL | Forbidden | FLUX.2-dev, Z-Image-Turbo | ~18 months |
| Llama 2 | Forbidden | Llama 3.3 | ~18 months |
| GPT-3.5 | Forbidden | GPT-4.5 | ~24 months |

### Cost of Suggesting Outdated Models

1. **Wrong advice** - User spends days setting up FLUX.1-dev when FLUX.2-dev exists
2. **Wasted compute** - SD XL needs more steps for worse results than Z-Image-Turbo
3. **Poor results** - Llama 2 can't compete with Qwen3 on any benchmark
4. **Hardware mismatch** - Suggesting 96GB models to 8GB GPU users

### Alternatives Evaluated

| Alternative | Assessment |
|-------------|------------|
| Manual CLAUDE.md updates | Works but requires constant human maintenance |
| Web search per query | Slow, unreliable, context-consuming |
| Other MCPs | **None found** - no SOTA tracker exists |

---

## 2. Architecture Review ✅

### Codebase Stats

- **Total:** ~4,039 lines of Python
- **Structure:** Clean separation of concerns

```
sota-tracker-mcp/
├── server.py (961 lines)     # MCP server + tools
├── init_db.py (1305 lines)   # Schema + seed data
├── scrapers/                  # Playwright scrapers
│   ├── lmarena.py            # LMArena Elo scraper
│   └── artificial_analysis.py
├── fetchers/                  # API fetchers
│   ├── cache_manager.py      # Smart daily caching
│   ├── huggingface.py        # HF API
│   └── lmarena.py            # LMArena API
└── utils/
    ├── hardware.py           # VRAM filtering
    ├── classification.py     # Open-source detection
    └── db.py                 # DB helpers
```

### Design Strengths

1. **Smart caching** - Refreshes once per day on first query, instant thereafter
2. **Graceful degradation** - Failed fetches fall back to cached data
3. **SQLite + JSON** - Simple, portable, no external DB needed
4. **Hardware profiles** - Persisted to `hardware_profiles.json`

### Design Issues

1. **Singleton pattern** for cache manager - fine for MCP, but not thread-safe
2. **Open-source detection** via string matching - naive but works for major models
3. **Scraper fragility** - Playwright scrapers will break if sites change

---

## 3. Data Quality ✅

### Verified Against External Sources

| Model in DB | Claimed | External Verification | Status |
|-------------|---------|----------------------|--------|
| LTX-2 | Released Jan 6, 2026 | Lightricks press release confirms | ✅ Correct |
| FLUX.2-dev | Nov 2025, 32B params | NVIDIA blog confirms | ✅ Correct |
| Qwen3 Coder | #1 open-source coder | 69.6% SWE-Bench verified | ✅ Correct |
| Z-Image-Turbo | 1150 Elo | DigitalOcean review confirms | ✅ Correct |
| Claude Opus 4.5 | #1 API for code | LMArena - 80.9% SWE-bench | ✅ Correct |

### Forbidden List Accuracy

All 13 forbidden models are legitimately outdated.

---

## 4. Value Proposition ✅

### Hardware-Aware Filtering Test

**Test:** Query llm_local while running image generation (24GB concurrent)

**Result:** Correctly filters to models ≤8GB (Qwen3-8B, JOSIEFIED-Qwen3-8B)

### Unique Features

1. **VRAM filtering** - No other tool does this
2. **Uncensored variant tracking** - Links to JOSIEFIED/abliterated models
3. **Concurrent workload awareness** - Adjusts for GPU multitasking
4. **Forbidden list** - Hard blocks outdated models

---

## 5. Competitive Analysis ✅

### Direct Competitors: None Found

Searched awesome-mcp-servers (500+ MCPs) - no SOTA tracker exists.

---

## 6. Strengths

1. **Solves a real problem** - LLM training data staleness is genuine
2. **No competition** - First mover in this space
3. **Clean implementation** - 4K lines, well-structured
4. **Hardware-aware** - Unique VRAM filtering feature
5. **Daily auto-refresh** - Data stays current
6. **Open-source defaults** - Respects user preference for local models

---

## 7. Weaknesses

1. **Manual seed data** - 1300 lines needs human updates
2. **Scraper fragility** - Will break when sites change
3. **No automated tests** - No pytest found
4. **No versioning** - DB schema changes could break installs

---

## 8. Recommendations (Prioritized)

### P0 - Critical
1. Add automated tests for core query functions
2. Add schema migrations for DB upgrades

### P1 - Important
3. GitHub Actions for daily data refresh
4. Add model download URLs
5. Expand forbidden list

### P2 - Nice to Have
6. API pricing data
7. CLI tool
8. Web dashboard

---

## 9. Final Verdict

**YES - Worth maintaining and sharing publicly.**

Unique, valuable, well-built, low maintenance, extensible.
